/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLEEDITOR_H__
#define __GLEEDITOR_H__


#include	<gle/glegwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* --- type macros --- */
#define	GLE_EDITOR(object)	(GTK_CHECK_CAST ((object), gle_editor_get_type (), GleEditor))
#define	GLE_EDITOR_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), gle_editor_get_type (), GleEditorClass))
#define	GLE_IS_EDITOR(object)	(GTK_CHECK_TYPE ((object), gle_editor_get_type ()))


/* --- typedefs --- */
typedef	struct	_GleEditor		GleEditor;
typedef	struct	_GleEditorClass		GleEditorClass;


/* --- structures --- */
struct	_GleEditor
{
  GtkWindow	window;
  
  GleGObject	*gobject;
  
  guint		args_dirty : 1;
  guint		is_widget : 1;
  guint		reload_queued : 1;
  
  GList		*garg_list;
  
  GtkWidget	*object_name_label;
  GtkWidget	*gname_label;
  GtkWidget	*gname_entry;
  GtkWidget	*default_default;
  GtkCTree	*ctree;
  GtkCList	*clist;
  GtkWidget	*notebook;
  GtkWidget	*child_args;
  GtkWidget	*sfield_list;
  GtkWidget	*sfield_signal;
  GtkWidget	*sfield_func;
  GtkWidget	*sfield_data;
  GtkWidget	*sfield_ctype;
};

struct	_GleEditorClass
{
  GtkWindowClass	 parent_class;
  
  GtkTooltips		*tooltips;
  
  void	(*refresh_values)	(GleEditor *editor);
  void	(*reload_values)	(GleEditor *editor);
  void	(*apply_values)		(GleEditor *editor);
  void	(*reset_values)		(GleEditor *editor);
  void	(*restore_values)	(GleEditor *editor);
  void	(*refresh_garg)		(GleEditor *editor,
				 GleGArg   *garg);
};


/* --- prototypes --- */
GtkType		gle_editor_get_type		(void);
GtkWidget*	gle_editor_new			(GleGObject	*gobject);
void		gle_editor_rebuild		(GleEditor	*editor);
void		gle_editor_destroy_args		(GleEditor	*editor);
void		gle_editor_update_names		(GleEditor	*editor);
void		gle_editor_update_signals	(GleEditor	*editor);

/* refresh_values - update screen contents from the actuall GleGArg values.
 * reload_values  - reload the GleGArg values from the object itself, a
 *		    callback from the GleGArg code will automatically cause
 *		    the editor display to be refeshed. the connection list
 *		    will however just be rebuild from the GleGObject.
 * reset_values	  - reset the arg value to the initial value a newly created
 *		    object would have. GleGObject cares for refresh_values.
 * restore_values - restore the args to the values they had upon the last
 *		    call to apply_values. we also do a refresh here since
 *		    some args may not have been updated bfore.
 * apply_values	  - apply the onscreen values to the editor's GtkObject.
 */
void		gle_editor_refresh_values	(GleEditor	*editor);
void		gle_editor_queue_reload_values	(GleEditor	*editor);
void		gle_editor_apply_values		(GleEditor	*editor);
void		gle_editor_reset_values		(GleEditor	*editor);
void		gle_editor_restore_values	(GleEditor	*editor);
void		gle_editor_refresh_garg		(GleEditor	*editor,
						 GleGArg	*garg);
GleEditor*	gle_editor_from_gobject		(GleGObject	*gobject);


/* --- private functions --- */
void		gle_arg_create_field		(GtkArg		*arg,
						 const gchar	*name,
						 GtkWidget     **widget_p,
						 GtkBox		*parent_box,
						 GtkWindow	*window);
void		gle_arg_refresh_field		(GtkArg		*arg,
						 GtkWidget	*widget);
gboolean	gle_arg_set_from_field		(GtkArg		*arg,
						 GtkWidget	*widget);





#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLEEDITOR_H__ */
