/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"glemenus.h"
#include	"glepopups.h"
#include	"gleshell.h"
#include	"gleeditor.h"
#include	"gleprivate.h"
#include	"glepublic.h"
#include	"gleetils.h"



/* --- typedefs --- */
typedef struct _GleMenuPos	GleMenuPos;
struct _GleMenuPos
{
  guint x;
  guint y;
};


/* --- item types --- */
enum
{
  WOPS_NONE,
  WOPS_WIDGET_EDITOR,
  WOPS_SPIT_GLE_NAME,
  WOPS_WIDGET_SIGNALS,
  WOPS_WIDGET_FLAGS,
  WOPS_TREE_DUMP,
  WOPS_EMIT_HIDE,
  WOPS_EMIT_SHOW,
  WOPS_EMIT_UNREALIZE,
  WOPS_EMIT_REALIZE,
  WOPS_QUEUE_DRAW,
  WOPS_QUEUE_RESIZE,
  WOPS_REALLOCATE,
  WOPS_SHOW_TOGGLE,
  WOPS_INC_BORDER,
  WOPS_DEC_BORDER,
  WOPS_EMIT_DESTROY,
  WOPS_LAST
};


/* --- functions --- */
static void
gle_menu_widget_ops_activate (GtkWidget  *item,
			      GtkWidget  *menu)
{
  GtkWidget *widget;
  GtkWindow *dialog;
  guint action;
  
  widget = gtk_object_get_user_data (GTK_OBJECT (menu));
  action = (guint) gtk_object_get_user_data (GTK_OBJECT (item));
  switch (action)
    {
      GtkAllocation allocation;

    case  WOPS_WIDGET_EDITOR:
      gle_popup_widget_editor (widget);
      break;
    case  WOPS_SPIT_GLE_NAME:
      g_print ("Automatic gle-name: %s\n",
	       gle_object_create_gle_name (GTK_OBJECT (widget)));
      break;
    case  WOPS_WIDGET_SIGNALS:
      dialog = gle_object_popup_signal_list (GTK_OBJECT (widget));
      /*      GLE_TAG (dialog); */
      gle_root_connect_object_life (GTK_OBJECT (dialog));
      break;
    case  WOPS_WIDGET_FLAGS:
      dialog = gle_widget_popup_flag_list (widget);
      GLE_TAG (dialog);
      gle_root_connect_object_life (GTK_OBJECT (dialog));
      break;
    case  WOPS_TREE_DUMP:
      dialog = (GtkWindow*) gle_popup_dialog (NULL,
				 NULL,
				 "Button Remove" /* FIXME */,
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 NULL,
				 "Tree dump requested for\n<%s>\n",
				 gtk_type_name (GTK_OBJECT (widget)->klass->type));
      gle_root_connect_object_life (GTK_OBJECT (dialog));
      break;
    case  WOPS_EMIT_HIDE:
      gtk_widget_hide (widget);
      break;
    case  WOPS_EMIT_SHOW:
      gtk_widget_show (widget);
      break;
    case  WOPS_EMIT_UNREALIZE:
      gtk_widget_unrealize (widget);
      break;
    case  WOPS_EMIT_REALIZE:
      gtk_widget_realize (widget);
      break;
    case  WOPS_QUEUE_DRAW:
      gtk_widget_queue_draw (widget);
      break;
    case  WOPS_QUEUE_RESIZE:
      gtk_widget_queue_resize (widget);
      break;
    case  WOPS_REALLOCATE:
      allocation.x = widget->allocation.x;
      allocation.y = widget->allocation.y;
      allocation.width = widget->allocation.width;
      allocation.height = widget->allocation.height;
      gtk_widget_size_allocate (widget, &allocation);
      break;
    case  WOPS_SHOW_TOGGLE:
      gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (widget),
				  ! GTK_TOGGLE_BUTTON (widget)->draw_indicator);
      break;
    case  WOPS_INC_BORDER:
      gtk_container_border_width (GTK_CONTAINER (widget), GTK_CONTAINER (widget)->border_width + 5);
      break;
    case  WOPS_DEC_BORDER:
      gtk_container_border_width (GTK_CONTAINER (widget), GTK_CONTAINER (widget)->border_width - 5);
      break;
    case  WOPS_EMIT_DESTROY:
      gtk_widget_destroy (widget);
      break;
    default:
      break;
    }
}

static void
gle_menu_widget_ops_adjust (GtkWidget  *item,
			    GtkWidget  *widget)
{
  guint action;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_WIDGET (widget));

  action = (guint) gtk_object_get_user_data (GTK_OBJECT (item));
  switch (action)
    {
    case  WOPS_WIDGET_EDITOR:
      gtk_widget_set_sensitive (item, !GTK_OBJECT_DESTROYED (widget));
      break;
    case  WOPS_SPIT_GLE_NAME:
      gtk_widget_set_sensitive (item, FALSE);
      break;
    case  WOPS_WIDGET_SIGNALS:
      gtk_widget_set_sensitive (item, gle_object_get_signal_list (GTK_OBJECT (widget)) == NULL);
      break;
    case  WOPS_WIDGET_FLAGS:
      gtk_widget_set_sensitive (item, gle_widget_get_flag_list (widget) == NULL);
      break;
    case  WOPS_TREE_DUMP:
      break;
    case  WOPS_EMIT_HIDE:
      gtk_widget_set_sensitive (item, GTK_WIDGET_VISIBLE (widget));
      break;
    case  WOPS_EMIT_SHOW:
      gtk_widget_set_sensitive (item, !GTK_WIDGET_VISIBLE (widget));
      break;
    case  WOPS_EMIT_UNREALIZE:
      gtk_widget_set_sensitive (item, GTK_WIDGET_REALIZED (widget));
      break;
    case  WOPS_EMIT_REALIZE:
      gtk_widget_set_sensitive (item, !GTK_WIDGET_REALIZED (widget));
      break;
    case  WOPS_QUEUE_DRAW:
      gtk_widget_set_sensitive (item, GTK_WIDGET_REALIZED (widget));
      break;
    case  WOPS_QUEUE_RESIZE:
      gtk_widget_set_sensitive (item, GTK_WIDGET_REALIZED (widget));
      break;
    case  WOPS_REALLOCATE:
      gtk_widget_set_sensitive (item, GTK_WIDGET_REALIZED (widget));
      break;
    case  WOPS_SHOW_TOGGLE:
      gtk_widget_set_sensitive (item, GTK_IS_TOGGLE_BUTTON (widget));
      break;
    case  WOPS_INC_BORDER:
    case  WOPS_DEC_BORDER:
      gtk_widget_set_sensitive (item, GTK_IS_CONTAINER (widget));
      break;
    case  WOPS_EMIT_DESTROY:
      gtk_widget_set_sensitive (item, !GTK_OBJECT_DESTROYED (widget));
      break;
    default:
      break;
    }
}

GtkWidget*
gle_menu_widget_ops_new (void)
{
  GtkWidget *item;
  GtkWidget *menu;

  menu = gtk_menu_new ();
  gtk_object_set_user_data (GTK_OBJECT (menu), NULL);

  item = gtk_menu_item_new_with_label ("Widget Operations");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new ();
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new ();
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Popup Editor");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_WIDGET_EDITOR,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Spit GLE Name");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_SPIT_GLE_NAME,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Show Signals");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_WIDGET_SIGNALS,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Show Flags");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_WIDGET_FLAGS,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Dump Tree");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_TREE_DUMP,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new ();
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Emit GtkWidget::hide");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_EMIT_HIDE,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Emit GtkWidget::show");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_EMIT_SHOW,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new ();
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Emit GtkWidget::unrealize");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_EMIT_UNREALIZE,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Emit GtkWidget::realize");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_EMIT_REALIZE,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Queue Redraw");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_QUEUE_DRAW,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Queue Resize");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_QUEUE_RESIZE,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Reallocate");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_REALLOCATE,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new ();
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("toggle draw_indicator");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_SHOW_TOGGLE,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("increment border_width");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_INC_BORDER,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("decrement border_width");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_DEC_BORDER,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new ();
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_NONE,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  item = gtk_menu_item_new_with_label ("Emit GtkObject::destroy");
  gtk_widget_set (item,
		  "GtkObject::user_data", (gpointer) WOPS_EMIT_DESTROY,
		  "GtkObject::signal::activate", gle_menu_widget_ops_activate, menu,
		  "GtkWidget::sensitive", FALSE,
		  "GtkWidget::visible", TRUE,
		  "GtkWidget::parent", menu,
		  NULL);

  return menu;
}

static void
gle_menu_position_func (GtkMenu        *menu,
			gint           *x,
			gint           *y,
			gpointer       func_data)
{
  GleMenuPos *mpos;

  mpos = func_data;

  *x = mpos->x;
  *y = mpos->y;
}

void
gle_menu_widget_ops_popup (GtkMenu	*menu,
			   GtkWidget	*widget,
			   guint	 x,
			   guint	 y,
			   guint	 mouse_button,
			   guint32	 time)
{
  GleMenuPos mpos;

  g_return_if_fail (menu != NULL);
  g_return_if_fail (GTK_IS_MENU (menu));
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_WIDGET (widget));

  gtk_object_set_user_data (GTK_OBJECT (menu), widget);
  gtk_container_foreach (GTK_CONTAINER (menu),
			 (GtkCallback) gle_menu_widget_ops_adjust,
			 (gpointer) widget);

  mpos.x = x;
  mpos.y = y;

  gtk_menu_popup (menu,
		  NULL, NULL,
		  NULL /*gle_menu_position_func*/, NULL /*&mpos*/,
		  mouse_button, time);
}
