/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"gleeditor.h"
#include	"gleprivate.h"


/* --- typedefs --- */
typedef struct _GleEditorData	GleEditorData;
struct	_GleEditorData
{
  GtkWidget	*widget;
  GtkWidget	*editor;

  GtkWidget	*label;
  GtkWidget	*entry;
  GList		*arg_data;
};
#define	GLE_EDITOR_DATA(widget)	((GleEditorData*) gtk_object_get_data (GTK_OBJECT ((widget)), gle_key_editor_data))
				   

/* --- prototypes --- */
static void	gle_editor_destroy		(GtkWidget		*editor,
						 GtkWidget		*widget);
static void	gle_toggle_button_set_arg	(GtkToggleButton	*toggle,
						 GtkArg			*arg);
static void	gle_entry_set_arg		(GtkEntry		*entry,
						 GtkArg			*arg);


/* -- variables --- */
static gchar		*gle_arg_key = "gle-arg";
static gchar		*gle_key_editor_data = "gle-widget-editor-data";
static GHashTable	*gle_widget_args = NULL;


/* --- functions --- */
static GtkWidget*
gle_create_arg_field (GtkArg	*arg,
		      gchar	*name,
		      GtkVBox	*parent)
{
  register GtkWidget *widget;

  g_assert (arg != NULL);
  g_assert (parent != NULL);

  widget = NULL;
  switch (arg->type)
    {
      GtkWidget *box;
      GtkWidget *label;
      GtkWidget *entry;

    case GTK_TYPE_BOOL:
      widget = gtk_widget_new (gtk_check_button_get_type (),
			       "GtkButton::label", name,
			       "GtkObject::signal::clicked", gle_toggle_button_set_arg, arg,
			       "GtkWidget::visible", TRUE,
			       NULL);
      gtk_box_pack_start (GTK_BOX (parent), widget, FALSE, FALSE, 0);
      break;

    case GTK_TYPE_INT:
    case GTK_TYPE_UINT:
    case GTK_TYPE_LONG:
    case GTK_TYPE_ULONG:
    case GTK_TYPE_FLOAT:
    case GTK_TYPE_STRING:
      box = gtk_widget_new (gtk_hbox_get_type (),
			    "GtkBox::homogeneous", FALSE,
			    "GtkBox::spacing", 10,
			    "GtkContainer::border_width", 0,
			    "GtkWidget::visible", TRUE,
			    NULL);
      gtk_box_pack_start (GTK_BOX (parent), box, FALSE, TRUE, 0);
      label = gtk_widget_new (gtk_label_get_type (),
			      "GtkLabel::label", name,
			      "GtkLabel::justify", GTK_JUSTIFY_LEFT,
			      "GtkWidget::visible", TRUE,
			      NULL);
      gtk_box_pack_start (GTK_BOX (box), label, FALSE, TRUE, 0);
      entry = gtk_widget_new (gtk_entry_get_type (),
			      "GtkWidget::width", arg->type == GTK_TYPE_STRING ? 140 : 50,
			      "GtkObject::signal::activate", gle_entry_set_arg, arg,
			      "GtkWidget::visible", TRUE,
			      NULL);
      gtk_box_pack_end (GTK_BOX (box), entry, FALSE, TRUE, 0);
      widget = entry;
      break;

    default:
      widget = gtk_widget_new (gtk_label_get_type (),
			       "GtkLabel::label", gtk_type_name (arg->type),
			       "GtkWidget::sensitive", FALSE,
			       "GtkWidget::visible", TRUE,
			       NULL);
      gtk_box_pack_start (GTK_BOX (parent), widget, FALSE, FALSE, 0);
      break;
    }

  if (widget)
    gtk_object_set_data (GTK_OBJECT (widget), gle_arg_key, arg);

  return widget;
}

static void
gle_toggle_blink_widget (GtkWidget *widget)
{
  if (gle_get_flash_widget () != widget)
    gle_set_flash_widget (widget);
  else
    gle_set_flash_widget (NULL);
}

GtkWidget*
gle_editor_popup (GtkWidget   *widget)
{
  GtkWidget *editor;
  GtkWidget *vbox;
  GtkWidget *window_vbox;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *note_book;
  GtkWidget *menu;
  GtkWidget *any;
  GleEditorData *data;
  gchar *string;

  g_return_val_if_fail (widget != NULL, NULL);
  g_return_val_if_fail (GTK_IS_WIDGET (widget), NULL);

  data = GLE_EDITOR_DATA (widget);
  if (data)
    {
      gdk_window_raise (data->editor->window);
      return NULL;
    }

  data = g_new (GleEditorData, 1);
  data->widget = widget;
  data->label = NULL;
  data->entry = NULL;
  data->arg_data = NULL;

  /* window with main container
   */
  editor	= gtk_widget_new (gtk_window_get_type (),
				  "GtkWindow::title", "GLE Widget Editor",
				  "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
				  "GtkObject::signal::delete_event", gtk_true, NULL,
				  "GtkObject::signal::destroy", gle_editor_destroy, widget,
				  "GtkWindow::allow_shrink", FALSE,
				  "GtkWindow::allow_grow", TRUE,
				  "GtkWindow::auto_shrink", TRUE,
				  NULL);
  data->editor = editor;
  GLE_TAG (editor);
  gtk_signal_connect_object_while_alive (GTK_OBJECT (widget),
					 "destroy",
					 GTK_SIGNAL_FUNC (gtk_widget_destroy),
					 GTK_OBJECT (editor));
  window_vbox	= gtk_widget_new (gtk_vbox_get_type (),
				  "GtkBox::homogeneous", FALSE,
				  "GtkBox::spacing", 0,
				  "GtkContainer::border_width", 0,
				  "GtkWidget::parent", editor,
				  "GtkWidget::visible", TRUE,
				  NULL);

  /* widget identifier label
   */
  hbox		= gtk_widget_new (gtk_hbox_get_type (),
				  "GtkBox::homogeneous", TRUE,
				  "GtkBox::spacing", 5,
				  "GtkContainer::border_width", 5,
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), hbox, FALSE, TRUE, 0);
  string = g_strconcat (gtk_type_name (GTK_OBJECT (widget)->klass->type),
			"::",
			"\"",
			widget->name ? widget->name : "",
			"\"",
			NULL);
  data->label	= gtk_widget_new (gtk_label_get_type (),
				  "GtkLabel::label", string,
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (hbox), data->label, FALSE, TRUE, 0);
  g_free (string);
  any		= gtk_widget_new (gtk_hseparator_get_type (),
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), any, FALSE, TRUE, 0);

  /* widget identifier entry
   */
  hbox		= gtk_widget_new (gtk_hbox_get_type (),
				  "GtkBox::homogeneous", FALSE,
				  "GtkBox::spacing", 5,
				  "GtkContainer::border_width", 5,
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), hbox, FALSE, TRUE, 0);
  label		= gtk_widget_new (gtk_label_get_type (),
				  "GtkLabel::label", "GLE Identifier:",
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
  entry		= gtk_widget_new (gtk_entry_get_type (),
				  "GtkWidget::parent", hbox,
				  "GtkWidget::visible", TRUE,
				  "GtkObject::object_signal::activate", gtk_window_activate_default, editor,
				  NULL);
  any		= gtk_widget_new (gtk_hseparator_get_type (),
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), any, FALSE, TRUE, 0);

  /* notebook
   */
  vbox		= gtk_widget_new (gtk_vbox_get_type (),
				  "GtkBox::homogeneous", FALSE,
				  "GtkBox::spacing", 5,
				  "GtkContainer::border_width", 5,
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), vbox, TRUE, TRUE, 0);
  note_book	= gtk_widget_new (gtk_notebook_get_type (),
				  "GtkWidget::parent", vbox,
				  "GtkWidget::visible", TRUE,
				  NULL);
  menu		= gtk_widget_new (gtk_option_menu_get_type (),
				  "GtkWidget::visible", TRUE,
				  NULL);
  any		= gtk_widget_new (gtk_hseparator_get_type (),
				  "GtkWidget::visible", TRUE,
				  "GtkWidget::parent", menu,
				  NULL);
  gtk_notebook_append_page (GTK_NOTEBOOK (note_book), menu, gtk_label_new ("menu page"));
				  
  any		= gtk_widget_new (gtk_hseparator_get_type (),
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), any, FALSE, TRUE, 0);

  /* additional functions
   */
  hbox		= gtk_widget_new (gtk_hbox_get_type (),
				  "GtkBox::homogeneous", TRUE,
				  "GtkBox::spacing", 5,
				  "GtkContainer::border_width", 5,
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), hbox, FALSE, TRUE, 0);
  button	= gtk_widget_new (gtk_button_get_type (),
				  "GtkButton::label", "Reset",
				  "GtkWidget::visible", TRUE,
				  "GtkObject::object_signal::clicked", gle_editor_reset, editor,
				  NULL);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
  button	= gtk_widget_new (gtk_button_get_type (),
				  "GtkButton::label", "Toggle Blinking",
				  "GtkWidget::visible", TRUE,
				  "GtkObject::object_signal::clicked", gle_toggle_blink_widget, widget,
				  NULL);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
  any		= gtk_widget_new (gtk_hseparator_get_type (),
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_start (GTK_BOX (window_vbox), any, FALSE, TRUE, 0);

  /* Apply/Close
   */
  hbox		= gtk_widget_new (gtk_hbox_get_type (),
				  "GtkBox::homogeneous", TRUE,
				  "GtkBox::spacing", 5,
				  "GtkContainer::border_width", 5,
				  "GtkWidget::visible", TRUE,
				  NULL);
  gtk_box_pack_end (GTK_BOX (window_vbox), hbox, FALSE, TRUE, 0);
  button	= gtk_widget_new (gtk_button_get_type (),
				  "GtkButton::label", "Apply",
				  "GtkWidget::parent", hbox,
				  "GtkWidget::visible", TRUE,
				  "GtkWidget::can_default", TRUE,
				  "GtkWidget::has_default", TRUE,
				  "GtkObject::object_signal::clicked", g_print, "blub\n",
				  NULL);
  button	= gtk_widget_new (gtk_button_get_type (),
				  "GtkButton::label", "Close",
				  "GtkWidget::parent", hbox,
				  "GtkWidget::visible", TRUE,
				  "GtkWidget::can_default", TRUE,
				  "GtkObject::object_signal::clicked", gtk_widget_destroy, editor,
				  NULL);

  gtk_object_set_data (GTK_OBJECT (editor), gle_key_editor_data, data);
  gtk_object_set_data (GTK_OBJECT (widget), gle_key_editor_data, data);
  
  gtk_widget_show (editor);

  return editor;
}

static void
gle_editor_destroy (GtkWidget    *editor,
		    GtkWidget	*widget)
{
  GleEditorData *data;

  g_return_if_fail (editor != NULL);
  g_return_if_fail (GTK_IS_WINDOW (editor));
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_WIDGET (widget));
  data = GLE_EDITOR_DATA (widget);

  gtk_object_set_data (GTK_OBJECT (widget), gle_key_editor_data, NULL);
  g_free (data);
}

static void
gle_toggle_button_set_arg (GtkToggleButton	*toggle,
			   GtkArg		*arg)
{
  printf ("gle_toggle_button_set_arg: %d\n", toggle->active);
}

static void
gle_entry_set_arg (GtkEntry	 *entry,
		   GtkArg	 *arg)
{
  printf ("gle_entry_set_arg: \"%s\"\n", entry->text);
}

void
gle_editor_reset (GtkWindow     *editor)
{
  GleEditorData *data;

  g_return_if_fail (editor != NULL);
  g_return_if_fail (GTK_IS_WINDOW (editor));
  data = GLE_EDITOR_DATA (editor);
}
