/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEMAINWINDOW_H__
#define __GLEMAINWINDOW_H__


#include        "glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define GLE_MAIN_WINDOW(object)	   ((GleMainWindow*) GTK_WINDOW ((object)))
#define GLE_IS_MAIN_WINDOW(object) (GTK_IS_WINDOW ((object)) && gle_object_has_gle_tag ((GtkObject*) (object)) && (gle_object_get_gle_tag ((GtkObject*) (object)) == (GleMainWindow*) (object)))


/* --- typedefs --- */
typedef struct _GleCustomerInfo	GleCustomerInfo;
struct _GleCustomerInfo
{
  GtkWidget *customer;
};


/* --- GLE macros --- */
#define GLE_IS_GLE_OBJECT(object)	(gle_object_has_gle_tag ((object)))
#define GLE_GET_MAIN_WINDOW(object)	(gle_object_get_gle_tag ((object)))

/* --- typedefs --- */
typedef GtkWindow                       GleMainWindow;


/* --- prototypes --- */
GleMainWindow*	gle_main_window_popup		(GtkWidget	*customer);
void		gle_widget_set_life_time	(GtkWidget	*widget);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif  /* __GLEMAINWINDOW_H__ */
