/*****************************************************************
 * mps2fbm.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Gary Sherwin & Michael Mauldin.
 * Permission is granted to use this file in whole or in part for
 * any purpose, educational, recreational or commercial, provided
 * that this copyright notice is retained unchanged.  This software
 * is available to all free of charge by anonymous FTP and in the
 * UUNET archives.
 *
 * mps2fbm.c: Convert Microtek Encapsulated Postscript to FBM
 *
 * USAGE
 *	 % mps2fbm < rawfile > fbm
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:26:53 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/mps2fbm.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 18-Oct-89  Gary W. Sherwin (sherwin) at Westinghouse STC.
 *	Created from raw2fbm.c for MPS format
 *****************************************************************/

# include <stdio.h>
# include "fbm.h"

# define USAGE \
"Usage: mps2fbm [ -t'title' -c'credits' ] < rawfile > fbm"

#ifndef lint
static char *fbmid =
"$FBM mps2fbm.c <1.0> 25-Jun-90  (C) 1989,1990 by Gary Sherwin & \
Michael Mauldin, source code available free from MLM@CS.CMU.EDU \
and from UUNET archives$";
#endif
/* MPS bitmap headers in files */
typedef struct mps_filehdr_struct
  {
      char  wlabel[7];		/* Width label */
      char  width[4];		/* Width */
      char  hlabel[13];		/* Height label */
      char  height[4];		/* Height */
      char  junk[792];		/* Other stuff we don't use */
      char  imgkey[11];		/* Key marking end of header */
      char  ehdr[1];		/* End of header */
  } MPSHDR;

main (argc, argv)
char *argv[];
{ register int j, k, rowlen;
  double aspect = 1.0;	/* Default for bitmaps */
  int rows = 400, cols = 640, planes = 1, colpad = 0;
  int rowcount = 1, colcount = 1, shiftcount = 256;
  FBMHDR hdr;
  MPSHDR mpshdr;
  unsigned char *buf, inbyte, nextout, zerro = 0;
  char title[FBM_MAX_TITLE], credits[FBM_MAX_TITLE];

  title[0] = '\0';
  credits[0] = '\0';

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 't':	strncpy (title, *argv+1, FBM_MAX_TITLE);
			title[FBM_MAX_TITLE-1] = '\0';
			CLRARG; break;
	case 'c':	strncpy (credits, *argv+1, FBM_MAX_TITLE);
			credits[FBM_MAX_TITLE-1] = '\0';
			CLRARG; break;
	default:	fprintf (stderr, "%s\n", USAGE);
			exit (1);
      }
    }
  }

  if (!fread (&mpshdr, 0x340,1,stdin))
  {
      fprintf (stdout, "Could not find mps header\n");
      exit (1);
  }
  cols = atoi (mpshdr.width);
  rows = atoi (mpshdr.height);
  planes = 1;
  
  if (cols < 1 || rows < 1)
  { fprintf (stderr, "Illegal width (%d) and height (%d) must be positive\n",
	     cols, rows);
    exit (1);
  }

  rowlen = 2 * ((cols * 8 + 15) / 16);

  /* Build header */
  hdr.rows = rows;
  hdr.cols = cols;
  hdr.planes = planes;
  hdr.bits = 8;
  hdr.physbits = 8;
  hdr.rowlen = rowlen;
  hdr.plnlen = hdr.rowlen * rows;
  hdr.clrlen = 0;
  hdr.aspect = aspect;
  strcpy (hdr.title, title);
  strcpy (hdr.credits, credits);
  
  write_hdr_fbm (&hdr, stdout);
  
  buf = (unsigned char *) malloc (cols);
  
  colpad = cols % 2;
  rowcount = 1;
  colcount = 1;
  while (rowcount <= rows)
  {
      if (! fread (&inbyte, 1, 1, stdin))
      {
	  fprintf (stdout, "premature end of file on input\n");
	  exit(1);
      }
      shiftcount = 256;
      while (shiftcount = shiftcount >> 1)
      {
	  nextout = inbyte & 128;
	  inbyte = inbyte <<1;
	  nextout = ~nextout;
	  if (! fwrite (&nextout, 1, 1, stdout))
	  { perror ("mps2fbm"); exit (1); }
	  if (++colcount > cols)
	  {
	      if (colpad)
	      {
		  if (! fwrite (&zerro, 1, 1, stdout))
		  { perror ("mps2fbm"); exit (1); }
	      }
	      colcount = 1;
	      rowcount++;
	  }
      }
  }
  exit (0);
}
