#ident "%W%" %G%
 
/**************************************************************************
# Copyright (C) 1994 Kubota Graphics Corp.
# 
# Permission to use, copy, modify, and distribute this material for
# any purpose and without fee is hereby granted, provided that the
# above copyright notice and this permission notice appear in all
# copies, and that the name of Kubota Graphics not be used in
# advertising or publicity pertaining to this material.  Kubota
# Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
# OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
# "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
# EXPRESS OR IMPLIED.
**************************************************************************/
 

#include "internal/dogen.h"
#include "dore_develop/develop.h"

/*
   This file contains obsolete functions for compatibility 
   between Dore versions 4.1 and 5.0. It contains functions of 
   the form:

     K_class* 
     K_object* 
     K_system*
     PDk_*
     PRdr_traverse*
     Rk_*
     U_*
*/


/*
 * obsolete K_class functions 
 */

/*
 ======================================================================
 */

K_classes_add_method (method_name, n, methods_list)
     DtPtr method_name;
     DtInt n;
     DtInt methods_list[];
{
    DDerror (ERR_FUNCTION_CHANGED, "K_classes_add_method",
                "DDclass_AddMethod");
}
/*
 ======================================================================
 */

K_class_add_notify (rtn)
     DtPFI rtn;
{
   DDerror (ERR_OBSOLETE_FUNCTION, "K_class_add_notify",
                "DDclass_AddNotify");

   dor_class_add_notify (rtn);
}
/*
 ======================================================================
 */

K_class_add_object_data (class_id, crt_rtn, prt_rtn, dst_rtn)
     DtInt class_id;
     DtPFI crt_rtn;
     DtPFI prt_rtn;
     DtPFI dst_rtn;
{
   extern DtInt dor_class_add_object_data();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_class_add_object_data",
  		 "DDclass_AddObjectData");

   return dor_class_add_object_data (class_id, crt_rtn, prt_rtn, dst_rtn);
}
/*
 ======================================================================
 */

DtInt
K_classes_copy_method (method_id, method_name, n, methods_list)
     DtInt method_id;
     DtPtr method_name;
     DtInt n;
     DtInt methods_list[];
{
    DDerror (ERR_FUNCTION_CHANGED, "K_classes_copy_method",
                "DDclass_CopyMethod");
}
/*
 ======================================================================
 */

DtPFI
K_class_inq_default_method (class_id)
     DtInt class_id;
{
   extern DtPFI dor_class_inq_default_method();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_class_inq_default_method",
                "DDclass_InqDefaultMethod");

   return dor_class_inq_default_method (class_id);
}
/*
 ======================================================================
 */

DtPFI
K_class_inq_method (class_id, method_id)
     DtInt class_id;
     DtInt method_id;
{
   extern DtPFI dor_class_inq_method ();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_class_inq_method",
                "DDclass_InqMethod");

   return dor_class_inq_method (class_id, method_id);
}
/*
 ======================================================================
 */

DtInt
K_classes_replace_method (method_name, method_id, n,
                          methods_list, copy_method_id)
     DtPtr method_name;
     DtInt method_id;
     DtInt n;
     DtInt methods_list[];
     DtInt copy_method_id;
{
    DDerror (ERR_FUNCTION_CHANGED, "K_classes_replace_method",
                "DDclass_ReplaceMethod");
}
/*
 ======================================================================
 */

K_class_set_method (class_id, method_id, rtn)
     DtInt class_id;
     DtInt method_id;
     DtPFI rtn;
{
   DDerror (ERR_OBSOLETE_FUNCTION, "K_class_set_method",
                "DDclass_SetMethod");

   dor_class_set_method (class_id, method_id, rtn);
}
/*
 ======================================================================
 */

/*
 * obsolete K_object functions
 */

K_object_add_reference (object, referencing_object)
     DtObject object;
     DtObject referencing_object;
{
   DDerror (ERR_OBSOLETE_FUNCTION, "K_object_add_reference",
                "DDobject_AddReference");

   dor_object_add_reference (object, referencing_object);
}
/*
 ======================================================================
 */

K_object_delete_reference (object, referencing_object)
     DtObject object;
     DtObject referencing_object;
{
   DDerror (ERR_OBSOLETE_FUNCTION, "K_object_delete_reference",
                "DDobject_DeleteReference");

   dor_object_delete_reference (object, referencing_object);
}
/*
 ======================================================================
 */

K_object_delete (object)
     DtObject object;
{
   DDerror (ERR_OBSOLETE_FUNCTION, "K_object_delete",
                "DeDeleteObject");

   dor_object_check_deletion (object);
}
/*
 ======================================================================
 */

DtPFI
K_object_inq_current_method (object)
     DtObject object;
{
   extern DtPFI dor_object_get_current_method ();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_object_inq_current_method",
                "DDobject_InqCurrentMethod");

   return dor_object_get_current_method(object);
}
/*
 ======================================================================
 */

DtPFI
K_object_inq_default_method (object)
     DtObject object;
{
   extern DtPFI dor_object_inq_default_method ();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_object_inq_default_method",
                "DDobject_InqDefaultMethod");

   return dor_object_inq_default_method (object);
}
/*
 ======================================================================
 */
DtPFI

K_object_inq_method (object, method_id)
     DtObject object;
     DtInt method_id;
{
   extern DtPFI dor_object_get_method();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_object_inq_method",
                "DDobject_InqMethod");

   return dor_object_get_method (object, method_id);
}
/*
 ======================================================================
 */

/*
 * obsolete K_system functions 
 */

DtInt
K_system_inq_number_processors()
{
   DtInt dor_system_inq_number_processors();

   DDerror (ERR_OBSOLETE_FUNCTION, "K_system_inq_number_processors",
                "DDsystem_InqNumberProcessors");

   return dor_system_inq_number_processors();
}
/*
 ======================================================================
 */

/*
 * obsolete PDk_ functions
 */

PDk_create_install_new_driver (name, get_fcns_fcn)
     DtPtr name;
     DtPFI get_fcns_fcn;
{
    static description = DcNullPtr;

    DDerror (ERR_OBSOLETE_FUNCTION, "PDk_create_install_new_driver",
                "DDdevice_InstallDriver");

    dor_device_install_driver(name, description, get_fcns_fcn);
}
/*
 ======================================================================
 */

DtFlag
PDk_set_aborted_draw_flag (device)
    DtPtr device;
{
    DDerror (ERR_FUNCTION_CHANGED, "PDk_set_aborted_draw_flag",
                "DDdevice_SetAbortedDraw");
}
/*
 ======================================================================
 */

DtShadeMode
PDk_inq_shade_mode(device)
        DtPtr device;
{
    DDerror (ERR_FUNCTION_CHANGED, "PDk_inq_shade_mode",
                "DdInqShadeMode");
}
/*
 ======================================================================
 */

void
PDk_inq_shade_range (device, index, range_min, range_max)
        DtPtr device;
        DtInt index;
        DtInt *range_min;
        DtInt *range_max;
{
    DDerror (ERR_FUNCTION_CHANGED, "PDk_inq_shade_range",
                "DDdevice_InqShadeRange");

}
/*
 ======================================================================
 */

DtFlag
PDk_inq_aborted_draw_flag(device)
        DtPtr device;
{
    DDerror (ERR_FUNCTION_CHANGED, "PDk_inq_aborted_draw_flag",
                "DDdevice_InqAbortedDraw");
}

/*
 ======================================================================
 */

PDk_set_shade_mode(device,mode)
     DtPtr device;
     DtShadeMode mode;
{
   DDerror (ERR_FUNCTION_CHANGED, "PDk_set_shade_mode",
                "DdSetShadeMode");
}
/*
 ======================================================================
 */

/*
 * obsolete PRdr_traverse functions
 */

void
PRdr_traverse_display_group()
{
    DDerror (ERR_OBSOLETE_FUNCTION, "PRdr_traverse_display_group",
                "traversal routine passed to output module");
}
/*
 ======================================================================
 */
void
PRdr_traverse_studio_group()
{
    DDerror (ERR_OBSOLETE_FUNCTION, "PRdr_traverse_studio_group",
                "traversal routine pointer passed to output module");
}

/*
 ======================================================================
 */

/*
 * obsolete Rk_ functions
 */

DtFlag
Rk_condex_query_render (object_type)
     DtInt object_type;
{
   extern DtFlag dor_condex_query_render ();

   DDerror (ERR_OBSOLETE_FUNCTION, "Rk_condex_query_render",
                "DDcondex_QueryRender");

   return dor_condex_query_render(object_type);
}
/*
 ======================================================================
 */

DtFlag
Rk_condex_query_execute(object_type)
     DtInt object_type;
{
   extern DtFlag dor_condex_query_execute();

   DDerror (ERR_OBSOLETE_FUNCTION, "Rk_condex_query_execute",
                "DDcondex_QueryExecute");

   return dor_condex_query_execute(object_type);
}
/*
 ======================================================================
 */

Rk_condex_set_disable_prim_exec_flag (switchvalue)
     DtFlag switchvalue;
{
   DDerror (ERR_OBSOLETE_FUNCTION, "Rk_condex_set_disable_prim_exec_flag",
                "DDcondex_SetDisablePrimExecFlag");

   dor_condex_set_disable_prim_exec_flag (switchvalue);
}
/*
 ======================================================================
 */

Rk_device_clear_rectangle_depth (xmin, ymin, xmax, ymax)
        DtInt xmin;
        DtInt ymin;
        DtInt xmax;
        DtInt ymax;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_clear_rectangle_depth",
	"DDdevice_ClearRectangleDepth");
}
/*
 ======================================================================
 */

Rk_device_clear_rectangle_depth_and_color (xmin, ymin, xmax, ymax)
        DtInt xmin;
        DtInt ymin;
        DtInt xmax;
        DtInt ymax;
{
    DDerror (ERR_FUNCTION_CHANGED,
	"Rk_device_clear_rectangle_depth_and_color",
	"DDdevice_ClearRectangleDepthColor");
}

/*
 ======================================================================
 */

Rk_device_flush ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_flush", "DDdevice_Flush");
}
/*
 ======================================================================
 */

DtFlag
Rk_device_inq_aborted_draw_flag ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_aborted_draw_flag",
	"DDdevice_InqAbortedDraw");
}
/*
 ======================================================================
 */

DtVolume *
Rk_device_inq_actual_viewport ()
{
   DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_actual_viewport",
	"DDdevice_InqActualViewport");
}
/*
 ======================================================================
 */

Rk_device_inq_clip_list (nrects, clip_list, extent, partiallyobscured)
     DtUInt *nrects;
     DtReal **clip_list;
     DtReal extent[4];
     DtFlag *partiallyobscured;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_clip_list",
	"DDdevice_InqClipList");
}
/*
 ======================================================================
 */

DtVolume *
Rk_device_inq_clipping_volume ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_clipping_volume",
	"DDdevice_InqClippingVolume");
}
/*
 ======================================================================
 */

Rk_device_inq_ftodscale (ftodscale)
     DtReal ftodscale[3];
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_ftodscale",
	"DDdevice_InqFrameScaleTrans");
}
/*
 ======================================================================
 */

Rk_device_inq_interface_routines (type, rtns)
     DtInt type;
     DtPtr *rtns;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_interface_routines",
	"DDdevice_InqInterfaceRoutines");
}
/*
 ======================================================================
 */

Rk_device_inq_resolution(x, y)
     DtReal *x;
     DtReal *y;
{
   DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_resolution",
	"DdInqResolution");
}
/*
 ======================================================================
 */

Rk_device_inq_scltrn_parms (ctodscale, ctodtranslate)
     DtReal ctodscale[3];
     DtReal ctodtranslate[3];
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_scltrn_parms",
	"DDdevice_InqFrustumScaleTrans");
}
/*
 ======================================================================
 */

DtShadeMode
Rk_device_inq_shade_mode ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_shade_mode",
	"DdInqShadeMode");
}
/*
 ======================================================================
 */

Rk_device_inq_shade_ranges (start, count, entries)
     DtInt start;
     DtInt count;
     DtInt entries[];
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_shade_ranges",
	"DDdevice_InqShadeRange");
}
/*
 ======================================================================
 */

DtFlag
Rk_device_inq_stereo ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_stereo",
	"DDdevice_InqStereo");
}
/*
 ======================================================================
 */

DtVisualType
Rk_device_inq_visual_type ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_inq_visual_type",
	"DdInqVisualType");
}
/*
 ======================================================================
 */
Rk_device_set_aborted_draw_flag (switchvalue)
     DtFlag switchvalue;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_set_aborted_draw_flag",
	"DDdevice_SetAbortedDraw");
}
/*
 ======================================================================
 */

Rk_device_set_background_color (color)
     DtReal color[];
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_set_background_color",
	"DDdevice_SetBackgroundColor");
}
/*
 ======================================================================
 */

Rk_device_set_depth_buffer_enable (flag)
     DtFlag flag;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_set_depth_buffer_enable",
	"DDdevice_SetDepthBufferEnable");
}
/*
 ======================================================================
 */

Rk_device_set_depth_buffer_write (flag)
     DtFlag flag;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_set_depth_buffer_write",
	"DDdevice_SetDepthBufferWrite");
}
/*
 ======================================================================
 */

Rk_device_set_foreground_color (color)
     DtReal color[];
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_set_foreground_color",
	"DDdevice_SetForegroundColor");
}
/*
 ======================================================================
 */

Rk_device_set_shade_index(index)
     DtInt index;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_set_shade_index",
	"DDdevice_SetShadeIndex");
}
/*
 ======================================================================
 */

Rk_device_write_rectangle_byte_rgb (x, y, length, height, pixarr)
     DtInt x, y;
     DtInt length, height;
     DtUChar *pixarr;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_write_rectangle_byte_rgb",
	"prom.write_rectangle_byte_rgb");
}
/*
 ======================================================================
 */

Rk_device_write_scanline_byte_rgb(x,y,length,pixarr)
     DtInt x;
     DtInt y;
     DtInt length;
     DtUChar *pixarr;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_device_write_scanline_byte_rgb",
	"dcm.write_scanline_byte");
}
/*
 ======================================================================
 */

DtInt
Rk_render_add_renderer (renderer_name, render_rtn, del_rtn, new_class_rtn,
                        inq_wcstofcs_rtn)
     DtPtr renderer_name;
     DtPFI render_rtn;
     DtPFI del_rtn;
     DtPFI new_class_rtn;
     DtPFI inq_wcstofcs_rtn;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_render_add_renderer",
	"DDrender_AddRenderer");
}
/*
 ======================================================================
 */

DtInt
Rk_render_insert_renderer (renderer_id, renderer_name, render_rtn,
                           del_rtn, new_class_rtn, inq_wcstofcs_rtn)
     DtInt renderer_id;
     DtPtr renderer_name;
     DtPFI render_rtn;
     DtPFI del_rtn;
     DtPFI new_class_rtn;
     DtPFI inq_wcstofcs_rtn;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_render_insert_renderer",
	"DDrender_AddRenderer");
}
/*
 ======================================================================
 */

dot_object *
Rk_view_inq_active_camera()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_active_camera",
	"DvInqActiveCamera");
}
/*
 ======================================================================
 */

Rk_view_inq_background_color (model, color)
     DtColorModel model;
     DtReal color[];
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_background_color",
	"DvInqBackgroundColor");
}
/*
 ======================================================================
 */

Rk_view_inq_background_just(left, bottom)
     DtReal *left;
     DtReal *bottom;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_background_just",
	"DvInqBackgroundJust");
}
/*
 ======================================================================
 */

DtObject
Rk_view_inq_background_raster ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_background_raster",
	"DvInqBackgroundRaster");
}
/*
 ======================================================================
 */

DtVolume *
Rk_view_inq_boundary ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_boundary",
	"DvInqBoundary");
}
/*
 ======================================================================
 */

DtFlag
Rk_view_inq_clear_flag ()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_clear_flag",
	"DvInqClearFlag");
}
/*
 ======================================================================
 */

DtInt
Rk_view_inq_shade_index()
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_inq_shade_index",
	"DvInqShadeIndex");
}
/*
 ======================================================================
 */

DtObject
Rk_view_resize_raster (width, height)
     DtInt width;
     DtInt height;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_resize_raster",
	"DDview_ResizeRaster");
}
/*
 ======================================================================
 */

DtFlag
Rk_view_traverse_display (method_id)
     DtInt method_id;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_traverse_display",
	"DDview_TraverseDisplay");
}
/*
 ======================================================================
 */

DtFlag
Rk_view_traverse_studio (method_id)
     DtInt method_id;
{
    DDerror (ERR_FUNCTION_CHANGED, "Rk_view_traverse_display",
	"DDview_TraverseStudio");
}
/*
 ======================================================================
 */

/*
 * obsolete U_ functions 
 */

DtFlag
U_bigendian_word_byte_order()
{
    DDerror (ERR_OBSOLETE_FUNCTION, "U_bigendian_word_byte_order",
	"(no equivalent)");

    return (dor_util_bigendian_word_byte_order());
}
/*
 ======================================================================
 */

char *
U_error_get_line()
{

    char *dor_error_get_line();

    DDerror (ERR_OBSOLETE_FUNCTION, "U_error_get_line", "DDerror_GetLine");

    return dor_error_get_line();
}
/*
 ======================================================================
 */

char *U_getenv(name)
     char *name;
{
    char *dor_util_getenv();

    DDerror (ERR_OBSOLETE_FUNCTION, "U_getenv", "DDgetenv");

    return (dor_util_getenv(name));
}
/*
 ======================================================================
 */

U_newerror(number, funcname, string)
    DtInt number;
    DtPtr funcname, string;
{
    DDerror (ERR_OBSOLETE_FUNCTION, "U_newerror", "DDerror");

    dor_error (number, funcname, string);
}
/*
 ======================================================================
 */

DtPtr
U_space_allocate(size)
    DtInt size;
{
    DtPtr dor_space_allocate();

    DDerror (ERR_OBSOLETE_FUNCTION, "U_space_allocate",
	"DDspace_Allocate");

    return(dor_space_allocate(size));
}
/*
 ======================================================================
 */

void
U_space_deallocate(spaceptr)
    dot_address spaceptr;
{
    DDerror (ERR_OBSOLETE_FUNCTION, "U_space_deallocate",
	"DDspace_Deallocate");

    dor_space_deallocate(spaceptr);
}
/*
 ======================================================================
 */

DtPtr
U_space_reallocate(in_ptr, size)
    dot_address in_ptr;
    unsigned size;
{
    DtPtr dor_space_reallocate();

    DDerror (ERR_OBSOLETE_FUNCTION, "U_space_reallocate",
	"DDspace_Reallocate");

    return(dor_space_reallocate(in_ptr, size));
}
/*
 ======================================================================
 */

char *
U_strtok(s1, s2)
    char *s1;
    char *s2;
{
    char *dor_util_strtok();

    DDerror (ERR_OBSOLETE_FUNCTION, "U_strtok", "DDstrtok");

    return (dor_util_strtok(s1, s2));
}
/*
 ======================================================================
 */
