/*ScianPick.c
  Picking system for spaces in SciAn
  Eric Pepke
  May 30, 1991
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianLists.h"
#include "ScianSpaces.h"
#include "ScianDraw.h"
#include "ScianIDs.h"
#include "ScianErrors.h"
#include "ScianMethods.h"
#include "ScianPick.h"
#include "ScianEvents.h"

#define MAXNPICK	200

short curPick;
short pickBuffer[MAXNPICK * 2];

ObjPtr pickObjects[MAXNPICK];

ObjPtr pickList = NULLOBJ;		/*VOLATILE list of just-picked objects*/

void StartPick(space)
ObjPtr space;
/*Starts picking mode in a space*/
{
    pick(pickBuffer, MAXNPICK);
    initnames();
    loadname(-1);
    curPick = 0;
}

void PickObject(object)
ObjPtr object;
/*Declares that object is about to be drawn for picking*/
{
    if (curPick >= MAXNPICK - 1)
    {
	ReportError("PickObject", "Too many objects to pick");
	return;
    }
    pickObjects[curPick] = object;
    loadname(curPick);
    ++curPick;
}

void EndPickObject(object)
ObjPtr object;
/*Ends the picking for object*/
{
    loadname(-1);
}

static void ZeroPickList()
/*Deferred routine to zero the pick list*/
{
    pickList = 0;
}

void StopPick(space)
ObjPtr space;
/*Stops picking mode in a space*/
{
    int nHits, k, c;
    pickList = NULLOBJ;

    nHits = endpick(pickBuffer);
    if (nHits < 0)
    {
	ReportError("StopPick", "Pick buffer was too small");
	nHits = -nHits;
    }

    /*Go through the hits and make a list of objects*/
    k = 0;
    while (nHits)
    {
	c = pickBuffer[k];
	++k;
	while (c)
	{
	    if (pickBuffer[k] >= 0 && pickObjects[pickBuffer[k]])
	    {
		if (!pickList)
		{
		    pickList = NewList();
		}
		PrefixList(pickList, pickObjects[pickBuffer[k]]);
		pickObjects[pickBuffer[k]] = NULLOBJ;
	    }
	    --c;
	    ++k;
	}
	--nHits;
    }
    DoTask(ZeroPickList);
}

ObjPtr PickedObjects()
/*Returns the objects that have been picked*/
{
    return pickList;
}
