/**************************************************
 * File: hb.c
 * Purpose: HDF Broswer on X
 * Contents:
 *  hbMain(): defines motif widgets applications
 *          contexts.  Should be called once for
 *          each HDF file to be browsed.
 * Remarks: 
 **************************************************/
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: hb.c,v 1.6 93/11/05 10:43:36 gbourhis Exp $";
#endif
/* $Log:	hb.c,v $
 * Revision 1.6  93/11/05  10:43:36  gbourhis
 * use XmNvalueChangedCallback instead of XmNarmCallback.
 * name the list & label widget "hdfBrowser" to allow easy setting of the
 * font using X resources.
 * get hbfontList from theLabel.
 * 
 */

#include "hbox.h"

extern void CBSendSel();
extern void CBSendOne();

char *edit_error_message = "\
    Currently edited text has changed.\n\
Text must be saved or discarded before a new  \n\
       editing session may begin.\n\
";

struct func_rec {
	void (*LoadFunc)();
	void (*SendFunc)();
	void (*CancelFunc)();
};

XmFontList hbfontList;


/*----------------------------------------------------------------------------
 * Name:    hbMain
 * Purpose: define motif widgets and dispatcher for X HDF Browser
 * Inputs:  rootWidget: User's toplevel widget ID which will be parent of 
 *             HBoX widgets
 *          file: name of HDF file to browse
 * Returns: 0 on success, -1 on failure
 * User:    HDF system programmers, on machines running X
 * Remarks: 
 *--------------------------------------------------------------------------*/
int hbMain(rootWidget, file, LoadFunc, SendFunc, CancelFunc)
     Widget rootWidget;
     char   *file;
     void (*LoadFunc)();                 /* callback if something is loaded into buffer */
     void (*SendFunc)();                 /* callback if something is sent */
     void (*CancelFunc)();               /* callback if hdfbrowse cancelled */
{
  Widget    formW;
  Widget    formW2;
  Widget    rowCol;
  Widget    rowCol6;                         /* buttons for formW2 */
  Widget    frame;
  Widget    toggleFrame;
  Widget    listform;
  Widget    formW2b[4];
  Widget    listOptions;
  Widget    allSep;
  Widget    menuBar;
  Widget    theLabel;
  Widget    button;
  Widget    pulldown[10];
  Widget    b;
  Widget    g[10];
  Arg       wargs[20];
  Cardinal  n = 0;
  XmString  label;
  int       xpos;      /* x position of user defined button */
  int       sep = 10;  /* separation between list windows */
  int       i;
  int       mlist_width;
  char      *toptitle;    /* top level window title */
  struct func_rec *Funcs;

  ctxt_ptr  me;     /* application context */

  Funcs = (struct func_rec *)malloc(sizeof(struct func_rec));
  Funcs->LoadFunc = LoadFunc;
  Funcs->SendFunc = SendFunc;
  Funcs->CancelFunc = CancelFunc;

  /* ===============================================
   *  
   *  Build application context to send to callbacks
   *
   * ===============================================
   */
  me = (ctxt_ptr) malloc(sizeof(ctxt));
  me->num_desc = 0;
  me->listShellMapped =
  me->editShellMapped = FALSE;
  me->send = 0;
  me->stack = NULL;
  me->hb_file = NULL;
  me->buf_size = 0;
  me->buffer = (tag_ref_ptr) malloc(BUFFER * sizeof(tag_ref));
  me->hb_desc = NULL;
  me->hb_grp;
  
  for(i = 0; i < NUM_LIST; i++) {
    me->num_list[i] = 0;
    me->sizes[i] = 100;
    me->index[i] = (tag_ref_ptr) malloc(me->sizes[i] * sizeof(tag_ref));
  }

#if DEBUG
  printf("in hbMain() context = %d\n", me);
#endif

  if(!file)
    return FAIL;

  /*
   *  Build shells                     
   */
  toptitle = (char *)malloc(strlen(file) + 17);
  sprintf(toptitle, "X HDF Browser: %s", file);

  n = 0;
  XtSetArg(wargs[n], XmNtitle, toptitle); n++;
  me->hdfShell = XtCreatePopupShell("HBoX", topLevelShellWidgetClass,
					rootWidget, wargs, n);
  free(toptitle);

  n = 0;
  XtSetArg(wargs[n], XmNtitle, "Contents"); n++;
  me->listShell = XtCreatePopupShell("HBoX Contents",topLevelShellWidgetClass,
				 rootWidget,wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtitle, "Editor"); n++;
  me->editShell = XtCreatePopupShell("HBoX Editor",topLevelShellWidgetClass,
					rootWidget, wargs, n);

  n = 0;
  me->helpShell = XtCreatePopupShell("HBoX Help", topLevelShellWidgetClass, 
					rootWidget,wargs, n);

  /* ================================================
   *
   *  Build container widgets for lists
   *
   * ================================================
   */

  /*
  ** Initial list to select top level thing to look at
  */

  n = 0;
  XtSetArg(wargs[n], XmNwidth, 510); n++;
  XtSetArg(wargs[n], XmNheight, LIST_HEIGHT + 90); n++;
  formW = XmCreateForm(me->hdfShell, "topForm", wargs, n);
    

  /* =======================================================
   *  Form for help window 
   *========================================================
   */

  n = 0;
  XtSetArg(wargs[n], XmNwidth, 550); n++;
  XtSetArg(wargs[n], XmNheight, LIST_HEIGHT); n++;
  me->helpform = XmCreateForm(me->helpShell, "helpForm", wargs, n);
  XtManageChild(me->helpform);
  
  /*
   * Build button widget to exit help window
   */

  n = 0;
  XtSetArg(wargs[n], XmNwidth, 50); n++;
  XtSetArg(wargs[n], XmNheight, 30); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(wargs[n], XmNrowColumnType, XmWORK_AREA); n++;
  XtSetArg(wargs[n], XmNbuttonType, XmPUSHBUTTON); n++;
  rowCol = XmCreateRowColumn(me->helpform, "HelpRowCol", wargs, n);
  XtManageChild(rowCol);


  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomWidget, rowCol); n++;
  XtSetArg(wargs[n], XmNtopOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNbottomOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNleftOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNrightOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNeditable, False); n++; 
  XtSetArg(wargs[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(wargs[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  me->helpText = XmCreateScrolledText(me->helpform, "helpALLtext", wargs, n);
  XtManageChild(me->helpText);

  n = 0;
  label = XmStringCreateLtoR("  OK  ", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  b = XmCreatePushButtonGadget(rowCol, "helpOK", wargs, n);
  XtAddCallback(b, XmNactivateCallback, CBCancelHelpAll, NULL);
  XtManageChild(b);

  /* ================================================
   *
   *  Build menu bar for main Window
   *
   * ================================================
   */

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  menuBar = XmCreateMenuBar(formW, "Menubar", wargs, n);
  XtManageChild(menuBar);

  n = 0;
  XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
  pulldown[0] = XmCreatePulldownMenu(menuBar, "pulldown", wargs, n);
  pulldown[1] = XmCreatePulldownMenu(menuBar, "pulldown", wargs, n);
  pulldown[2] = XmCreatePulldownMenu(menuBar, "pulldown", wargs, n);
  pulldown[3] = XmCreatePulldownMenu(menuBar, "pulldown", wargs, n);
  XtManageChildren(pulldown, 4);

  /*
   * The 'File' menu
   */
  n = 0;
  label = XmStringCreate("File", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNsubMenuId, pulldown[0]); n++;
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  button = XmCreateCascadeButton(menuBar, "button", wargs, n);
  XtManageChild(button);

  n = 0;
  label = XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  b = XmCreatePushButtonGadget(pulldown[0], "menubutton", wargs, n);
  XtAddCallback(b, XmNactivateCallback, CBClose, CancelFunc);
  XtManageChild(b);

  /*
   * The 'Transport' menu
   */
  n = 0;
  label = XmStringCreate("Transport", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNsubMenuId, pulldown[1]); n++;
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  button = XmCreateCascadeButton(menuBar, "button", wargs, n);
  XtManageChild(button);

  n = 0;
  label = XmStringCreate("Send Selection", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  b = XmCreatePushButtonGadget(pulldown[1], "menubutton", wargs, n);
  XtAddCallback(b, XmNactivateCallback, CBSendSel, SendFunc);
  XtManageChild(b);


  /*
   * The 'Help' menu
   */
  n = 0;
  label = XmStringCreate("Help", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNsubMenuId, pulldown[3]); n++;
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  button = XmCreateCascadeButton(menuBar, "button", wargs, n);
  XtManageChild(button);

  n = 0;
  label = XmStringCreateLtoR("Help", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  b = XmCreatePushButtonGadget(pulldown[3], "menubutton", wargs, n);
  XtAddCallback(b, XmNactivateCallback, CBGetHelpAll, NULL); 
  XtManageChild(b);

 /*=============================================================
  *  End of menuBar stuff
  *=============================================================
  */


  /* =======================================
   *  Build edit windows for DIL's and DIA's
   * =======================================
   */ 


  n = 0;
  XtSetArg(wargs[n], XmNwidth, 500); n++;
  XtSetArg(wargs[n], XmNheight, 200); n++;
  XtSetArg(wargs[n], XmNmappedWhenManaged, True); n++;
  me->editForm = XmCreateForm(me->editShell, "Editor", wargs, n);


  /*
   * build frame, rowColumn, and button widgets for edit options 
   */
  
  n = 0;
  XtSetArg(wargs[n], XmNshadowThickness, 4); n++;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  frame= XmCreateFrame(me->editForm, "frame", wargs, n);
  XtManageChild(frame);

  n = 0;
  XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(wargs[n], XmNbuttonType, XmPUSHBUTTON); n++;
  XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rowCol = XmCreateRowColumn(frame, "EditRowCol", wargs, n);
  XtManageChild(rowCol);

  n = 0;
  label = XmStringCreateLtoR("OK", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  g[0] = XmCreatePushButtonGadget(rowCol, "ok", wargs, n);
  XtAddCallback(g[0], XmNactivateCallback, CBCancel, NULL);

  n = 0;
  label = XmStringCreateLtoR("Save", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  g[1] = XmCreatePushButtonGadget(rowCol, "save", wargs, n);
  XtAddCallback(g[1], XmNactivateCallback, CBSave, NULL);

  n = 0;
  label = XmStringCreateLtoR("Cancel", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  g[2] = XmCreatePushButtonGadget(rowCol, "cancel", wargs, n);
  XtAddCallback(g[2], XmNactivateCallback, CBCancel, NULL);

  n = 0;
  label = XmStringCreateLtoR("Reset", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  g[3] = XmCreatePushButtonGadget(rowCol, "reset", wargs, n);
  XtAddCallback(g[3], XmNactivateCallback, CBReset, NULL);

  n = 0;
  label = XmStringCreateLtoR(" Remove ", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  g[4] = XmCreatePushButtonGadget(rowCol, "reset", wargs, n);
  XtAddCallback(g[4], XmNactivateCallback, CBGetHelpEditor, NULL);

  n = 0;
  label = XmStringCreateLtoR("Help", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  g[5] = XmCreatePushButtonGadget(rowCol, "EditorHelp", wargs, n);
  XtAddCallback(g[5], XmNactivateCallback, CBGetHelpEditor, NULL);

  XtManageChildren(g, 6);

  n = 0;
  XtSetArg(wargs[n], XmNwidth, LIST_WIDTH - 35); n++;
  XtSetArg(wargs[n], XmNheight, 220); n++;
  XtSetArg(wargs[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 4 * EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, frame); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, EDGE_OFFSET); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  me->textedit = XmCreateScrolledText(me->editForm,"scrolledit2", wargs, n);
  XtAddCallback(me->textedit, XmNvalueChangedCallback, CBTextValueChanged, NULL);
  XtManageChild(me->textedit);


  /* ---------------------------------------------------
   *  Build error dialog
   * ---------------------------------------------------
   */

  label = XmStringCreateLtoR(edit_error_message, XmSTRING_DEFAULT_CHARSET);
  n = 0;
  XtSetArg(wargs[n], XmNmessageString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  me->errorBox = XmCreateErrorDialog(me->textedit, "HBoX Error", wargs, n);
  XtAddCallback(me->errorBox, XmNhelpCallback, CBGetHelpEditor, NULL);

  /* =========================================
   *  Build rowColumn widgets to 
   *  handle pulldown menus and toggle buttons
   * =========================================
   */

  /* 
   * Create a bounding frame to group the eight 
   * list option toggle buttons together 
   */

  n = 0;
  XtSetArg(wargs[n], XmNshadowThickness, 4); n++;
/*
  XtSetArg(wargs[n], XmNx,   3); n++;
  XtSetArg(wargs[n], XmNy, 65); n++;
  XtSetArg(wargs[n], XmNwidth, 75); n++;
  XtSetArg(wargs[n], XmNheight, LIST_HEIGHT); n++;
*/
  XtSetArg(wargs[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget,  menuBar); n++;
  XtSetArg(wargs[n], XmNbottomAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_FORM); n++;
  toggleFrame = XmCreateFrame(formW, "frame", wargs, n);
  XtManageChild(toggleFrame);


  n = 0;
/*  XtSetArg(wargs[n], XmNlabelString, label); n++;*/
  XtSetArg(wargs[n], XmNalignment,  XmALIGNMENT_BEGINNING); n++;
  XtSetArg(wargs[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget,  menuBar); n++;
  XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget,  toggleFrame); n++;
  XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
  theLabel  = XmCreateLabelGadget(formW, "hdfBrowser", wargs, n);

  n = 0;
  XtSetArg(wargs[n],XmNfontList,&hbfontList); n++;
  XtGetValues(theLabel,wargs,n);
  {
    XmString blankString,oldString,tmpString;
    label = XmStringCreateSimple("Tag Name");
    blankString = XmStringCreateSimple(" ");
    while(XmStringWidth(hbfontList,label) < TAG_NAME_WIDTH) {
        oldString = label;
        label= XmStringConcat(label,blankString);
        XmStringFree(oldString);
        }
    tmpString = XmStringCreateSimple("Ref   Label");
    oldString = label;
    label = XmStringConcat(label,tmpString);
    XmStringFree(oldString);
    XmStringFree(blankString);
    XmStringFree(tmpString);
  }
  XtVaSetValues(theLabel, XmNlabelString, label, NULL);
  XtManageChild(theLabel);
  XmStringFree(label);



  /* --------------------------------------
   *  The actual list in the first window.
   * --------------------------------------
   */
  n = 0;
/*  XtSetArg(wargs[n], XmNshadowThickness, 4); n++;
  XtSetArg(wargs[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget,  theLabel); n++;
  XtSetArg(wargs[n], XmNbottomAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget,  toggleFrame); n++;
  XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
  frame = XmCreateFrame(formW, "formframe", wargs, n);
  XtManageChild(frame);*/

  n = 0;
/*  XtSetArg(wargs[n], XmNtopAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;*/
  XtSetArg(wargs[n], XmNtopAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget,  theLabel); n++;
  XtSetArg(wargs[n], XmNbottomAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget,  toggleFrame); n++;
  XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNselectionPolicy, XmEXTENDED_SELECT); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  me->list[0] = XmCreateScrolledList(/*frame*/formW, "hdfBrowser", wargs, n);


  n = 0;
  XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(wargs[n], XmNradioBehavior, False); n++;
  listOptions = XmCreateRowColumn(toggleFrame, "list_options", wargs, n);
  XtManageChild(listOptions);

  /**
   ** Create eight list option toggle buttons
   **/


  /*
   * Other toggle button: list Utilities and
   *      Personal Tag types if they exist
   */

  n = 0;
  label = XmStringCreateLtoR("Other", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmN_OF_MANY); n++;
  me->button[0] = XmCreateToggleButton(listOptions, "option1", wargs, n);
  XtAddCallback(me->button[0], XmNvalueChangedCallback, CBGetType, OTHER);

  /*
   * VG: list Vgroups
   */

  n = 0;
  label = XmStringCreateLtoR("VG", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmN_OF_MANY); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  me->button[1] = XmCreateToggleButton(listOptions, "option2", wargs, n);
  XtAddCallback(me->button[1], XmNvalueChangedCallback, CBGetType, VSET);

  /*
   * NDG: list Scientific Data Groups
   */

  n = 0;
  label = XmStringCreateLtoR("NDG", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmN_OF_MANY); n++;
  me->button[2] = XmCreateToggleButton(listOptions, "option3", wargs, n);
  XtAddCallback(me->button[2], XmNvalueChangedCallback, CBGetType, SDS);

  /* 
   * RIG: list Raster Image Groups
   */

  n = 0;
  label = XmStringCreateLtoR("RIG", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmN_OF_MANY); n++;
  me->button[3] = XmCreateToggleButton(listOptions, "option4", wargs, n);
  XtAddCallback(me->button[3], XmNvalueChangedCallback, CBGetType, RIG);

  /*
   * PAL: list Palette Groups
   */

  n = 0;
  label = XmStringCreateLtoR("PAL", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmN_OF_MANY); n++;
  me->button[4] = XmCreateToggleButton(listOptions, "option5", wargs, n);
  XtAddCallback(me->button[4], XmNvalueChangedCallback, CBGetType, PAL); 

/*
  n = 0;
  XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
  allSep = XmCreateSeparatorGadget(listOptions, "allSeparator", wargs, n);
  XtManageChild(allSep);
*/

  /*
   * GROUP: list all groups
   */

  n = 0;
  label = XmStringCreateLtoR("Groups", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  XtSetArg(wargs[n], XmNset, True); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmONE_OF_MANY); n++;
  me->button[5] = XmCreateToggleButton(listOptions, "option7", wargs, n);
  XtAddCallback(me->button[5], XmNvalueChangedCallback, CBGetType, GROUP); 

  /*
   * ALL: list groups + 'others'
   */

  n = 0;
  label = XmStringCreateLtoR("ALL", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(wargs[n], XmNlabelString, label); n++;
  XtSetArg(wargs[n], XmNuserData, me); n++;
  XtSetArg(wargs[n], XmNindicatorType, XmONE_OF_MANY); n++;
  me->button[6] = XmCreateToggleButton(listOptions, "option6", wargs, n);
  XtAddCallback(me->button[6], XmNvalueChangedCallback, CBGetType, ALL); 

  XtManageChildren(me->button, 7);

  /*
   * Manage left over widgets
   */
  XtManageChild(formW);
  XtManageChild(me->editForm);
  XtManageChild(me->list[0]);

  /*
   * Set things to need explicit mapping
   */
  XtSetMappedWhenManaged(me->hdfShell, False);
  XtSetMappedWhenManaged(me->listShell, False);
  XtSetMappedWhenManaged(me->editShell, False);
  XtSetMappedWhenManaged(me->helpShell, False);

  /* open file */
  if (initFile(me, file) == FAIL) {
    printf("hbMain: openFile(%s): failed \n", file);
    return FAIL;
  } 

  /*
   * CBGet_position() is called when an item is selected from a list 
   *  with a double click
   */
  XtAddCallback(me->list[0], XmNdefaultActionCallback, CBSendOne,
	(caddr_t)Funcs); 

  /* 
   * Display top level browser shell and its contents
   */
  XtPopup(me->hdfShell,XtGrabNone);

  /*
   * Initialize lists
   */
  me->list_type = GROUP;
  getDesc(me);

  return HB_OK;
}

