/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <dtm/dtm.h>
#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))

#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))
#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))
#define DEF_DEPTH	DefaultDepth(myDpy, DefaultScreen(myDpy))
#define DEF_ROOT	DefaultRootWindow(myDpy)

#include "doodle.h"
#include "view.h"
#include "viewer.h"
#include "mode.h"
#include "net.h"


extern void DrawPoints();
extern void RubberPoint();
extern void RubberSelect();
extern void RubberLineSelect();
extern int MySendDoodle();


extern NetPort *outP;
extern Pixmap	scratchPix;
extern XFontStruct *drawFont;
extern GC	drawAreaGC;
extern GC	invGC;
extern Display	*myDpy;
extern int      Swidth, Sheight, Sascent;
extern charRec *fontTable;



void
DrawText(V, buf, length, x, y, color)
	View *V;
	char *buf;
	int length;
	int x, y;
	unsigned long color;
{
	if ((V->type == V_RASTER)||(V->type == V_WHITEBOARD))
	{
		XSetForeground(myDpy, drawAreaGC, color);
		if (V->areaSelect)
		{
			RubberSelect(V, V->drawArea);
		}
		if (V->lineSelect)
		{
			RubberLineSelect(V, V->drawArea, 0);
		}
		if (V->pointSelect)
		{
			RubberPoint(V, V->drawArea, 0);
		}
		XDrawString(myDpy, XtWindow(V->drawArea), drawAreaGC,
				x, y, buf, length);
		XDrawString(myDpy, V->doodlePix, drawAreaGC,
				x, y, buf, length);
		if (V->pointSelect)
		{
			RubberPoint(V, V->drawArea, 1);
		}
		if (V->lineSelect)
		{
			RubberLineSelect(V, V->drawArea, 0);
		}
		if (V->areaSelect)
		{
			RubberSelect(V, V->drawArea);
		}
	}
}



void
PixelText(V, buf, length, x, y, color)
	View *V;
	char *buf;
	int length;
	int x, y;
	unsigned long color;
{
	XImage *tmpimage;
	POINT *doodle;
	int i, j, len, status, indx;
	unsigned long pix;
	unsigned int width, height;

	width = V->cData->xdim;
	height = V->cData->ydim;
	indx  = (int)((unsigned char)buf[0]);
	if (fontTable[indx].length == -1)
	{
		XSetForeground(myDpy, drawAreaGC, DEF_BLACK);
		XFillRectangle(myDpy, scratchPix, drawAreaGC, 0, 0,
				Swidth, Sheight);
		XSetForeground(myDpy, drawAreaGC, DEF_WHITE);
		XDrawString(myDpy, scratchPix, drawAreaGC, 0, Sascent,
				buf, length);
		tmpimage = XGetImage(myDpy, scratchPix, 0, 0, Swidth, Sheight,
				AllPlanes, ZPixmap);

		doodle = (POINT *)MALLOC(sizeof(POINT) * Swidth * Sheight);
		len = 0;
		for (j=0; j<Sheight; j++)
		{
			for (i=0; i<Swidth; i++)
			{
				pix = XGetPixel(tmpimage, i, j);
				if (pix == DEF_WHITE)
				{
					doodle[len].x = (short)(x + i);
					doodle[len].y = (short)(y - Sascent +j);
					if ((doodle[len].x < width)&&
						(doodle[len].y < height)&&
						((V->type == V_RASTER)||
						(V->type == V_WHITEBOARD))
					    && V->cData->doodleImage != NULL)
					{
					   XPutPixel(V->cData->doodleImage,
						doodle[len].x, doodle[len].y,
						color);
					}
					len++;
				}
			}
		}
		XDestroyImage(tmpimage);
		fontTable[indx].doodle = (POINT *)MALLOC(sizeof(POINT) * len);
		for (i=0; i<len; i++)
		{
			fontTable[indx].doodle[i].x = doodle[i].x - x;
			fontTable[indx].doodle[i].y = doodle[i].y - y;
		}
		fontTable[indx].length = len;
	}
	else
	{
		doodle = (POINT *)MALLOC(sizeof(POINT) *
					fontTable[indx].length);
		for (i=0; i< fontTable[indx].length; i++)
		{
			doodle[i].x = x + fontTable[indx].doodle[i].x;
			doodle[i].y = y + fontTable[indx].doodle[i].y;
			if ((doodle[i].x < width)&&(doodle[i].y < height)&&
				((V->type == V_RASTER)||
				(V->type == V_WHITEBOARD))
			    && V->cData->doodleImage != NULL)
			{
				XPutPixel(V->cData->doodleImage,
					doodle[i].x, doodle[i].y, color);
			}
		}
	}

	if ((V->type == V_SHEET)||(V->type == V_TEXT))
	{
		DrawPoints(V, V->cData, doodle, 0, (fontTable[indx].length - 1),
				color, 1);
	}

	status = MySendDoodle(V, 1, fontTable[indx].length, doodle, True, True);
	FREE(doodle);
}


void
InitDrawText(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (V->Mode == TEXTINSERT)
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}

	V->ret_x = win_x;
	V->text_x = win_x;
	V->text_y = win_y;

	XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
		V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	V->Mode = TEXTINSERT;
}


void
KeyDoodle(V, w, KEvent)
	View *V;
	Widget w;
	XKeyPressedEvent *KEvent;
{
	KeySym ks;
	char buf[80];
	int length;
	int dir, ascent, descent;
	XCharStruct all;
	unsigned int keys;

	length = XLookupString(KEvent, buf, 80, NULL, NULL);
	buf[length] = '\0';
	if (length)
	{
if (length > 1)
{
fprintf(stderr, "DANGER WILL ROBINSON!  TEXT STRING TOO LONG!  DANGER! (%d)\n",length);
}
		ks = XLookupKeysym(KEvent, 0);
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
		if (ks != XK_Return)
		{
			DrawText(V, buf, length, V->text_x, V->text_y, V->doodleColor);
		}
		XTextExtents(drawFont, buf, length, &dir,
			&ascent, &descent, &all);
		XFlush(myDpy);
		if (ks != XK_Return)
		{
			PixelText(V, buf, length, V->text_x, V->text_y, V->doodleColor);
		}
		if (ks == XK_Return)
		{
			V->text_y = V->text_y + Sheight;
			V->text_x = V->ret_x;
		}
		else
		{
			V->text_x = V->text_x + all.width;
		}
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}

