/*
  File: testwff.c
  Author: K.R. Sloan,
  Last Modified: 28 April 1988
  Purpose: test and example use of the Washington file Format 
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

FILE *FileDescriptor;
FrameBufferType *FrameBuffer;
int Left, Bottom, Top, Right, BitsPerBand;
char WhatBands[10], Name[NameLength], Value[ValueLength];
int x,y;
int bottom,left,top,right;
unsigned short Pixel[4];
unsigned short Block[200][4];
unsigned short *p;
int N,i;

int
main()
 {
  FrameBuffer = (FrameBufferType *)0;
  OpenFB(&FrameBuffer);

  GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right);
  fprintf(stderr,"Default: Bottom = %d, Left = %d, Top = %d, Right = %d\n",
          Bottom,Left,Top,Right);

  Bottom = 16; Left = 16; Top = 31; Right = 31;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right);
  fprintf(stderr,"Reset to: Bottom = %d, Left = %d, Top = %d, Right = %d\n",
          Bottom,Left,Top,Right);

  GetColorSystem(FrameBuffer, WhatBands, &BitsPerBand);
  fprintf(stderr,"Default: WhatBands = %s, BitsPerBand = %d\n",
                WhatBands,BitsPerBand);

  strcpy(WhatBands,"YIQA"); BitsPerBand = 12; /* 1, 7, 8, 12, 16 */
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);
  GetColorSystem(FrameBuffer, WhatBands, &BitsPerBand);
  fprintf(stderr,"Reset to: WhatBands = %s, BitsPerBand = %d\n",
                WhatBands,BitsPerBand);

  strcpy(Name,"X-perimental");
  strcpy(Value,"like, value man");
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Value,"wrong, Bullwinkle!");
  GetDescriptor(FrameBuffer, Name, Value);
  fprintf(stderr,"Name = %s, Value = %s\n",Name,Value);

  for (N=0;N<20;N++)
   {
    GetDescriptorN(FrameBuffer, N, Name, Value);
    if (Name[0] == '\0') break;
    fprintf(stderr,"%d: %s = %s\n",N, Name, Value);
   }

  x = 18; y = 17;
  Pixel[0] = 'Y'; Pixel[1] = 'I'; Pixel[2] = 'Q'; Pixel[3] = 'A';
  fprintf(stderr,"Putting [%d, %d, %d, %d] at (%d,%d)\n",
       Pixel[0],Pixel[1],Pixel[2],Pixel[3],x,y);
  PutPixel(FrameBuffer, x, y, Pixel);

  Pixel[0] = 0; Pixel[1] = 0; Pixel[2] = 0; Pixel[3] = 0;
  GetPixel(FrameBuffer, x, y, Pixel);
  fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
   x,y,Pixel[0],Pixel[1],Pixel[2],Pixel[3]);

  x += 5; y += 5;
  bottom = y-2; left = x-2; top = y+2; right = x+2;
  p = &Block[0][0];

  for(y=bottom; y<=top;y++)
   for(x=left; x<=right; x++)
    {
     *(p++) = (unsigned short)(x+y);
     *(p++) = (unsigned short)(x-y);
     *(p++) = (unsigned short)(x*y);
     *(p++) = (unsigned short)(x/y);
    }
  PutBlock(FrameBuffer,bottom,left,top,right,Block);

  fprintf(stderr,"First Column of Block:\n");
  for(y=bottom; y<=top;y++)
   {
    Pixel[0] = 0; Pixel[1] = 0; Pixel[2] = 0; Pixel[3] = 0;
    GetPixel(FrameBuffer, left, y, Pixel);
    fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
                left,y,Pixel[0],Pixel[1],Pixel[2],Pixel[3]);
   }

  Pixel[0] = 0; Pixel[1] = 0; Pixel[2] = 0; Pixel[3] = 0;
  GetPixel(FrameBuffer, left, bottom, Pixel);
  fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
   left,bottom,Pixel[0],Pixel[1],Pixel[2],Pixel[3]);

  x += 5; y += 5;
  bottom += 5; left += 5; top += 5; right += 5;
  Pixel[0] = 1; Pixel[1] = 2; Pixel[2] = 3; Pixel[3] = 4;
  PutConstant(FrameBuffer,bottom,left,top,right,Pixel);
  Pixel[0] = 0; Pixel[1] = 0; Pixel[2] = 0; Pixel[3] = 0;
  GetPixel(FrameBuffer, left, bottom, Pixel);
  fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
   left, bottom,Pixel[0],Pixel[1],Pixel[2],Pixel[3]);

  FileDescriptor = fopen("test.wff","w");
  if (FileDescriptor == (FILE *)0)
   {
    fprintf(stderr,"Can't open test.wff - aborting\n");
    exit(-1);
   }
  WriteImage(FileDescriptor, FrameBuffer);

  fclose(FileDescriptor);
  CloseFB(&FrameBuffer);
  fprintf(stderr,"Image file created\n");

  OpenFB(&FrameBuffer);
  FileDescriptor = fopen("test.wff","r");
  if (FileDescriptor == (FILE *)0)
   {
    fprintf(stderr,"Can't open test.wff - aborting\n");
    exit(-1);
   }
  ReadImage(FileDescriptor, FrameBuffer);

  GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right);
  fprintf(stderr,"After reading file: Bottom = %d, Left = %d,Top = %d, Right = %d\n",Bottom,Left,Top,Right);

  GetColorSystem(FrameBuffer, WhatBands, &BitsPerBand);
  fprintf(stderr,"WhatBands = %s, BitsPerBand = %d\n",
                WhatBands,BitsPerBand);

  strcpy(Name,"X-perimental");
  GetDescriptor(FrameBuffer, Name, Value);
  fprintf(stderr,"Name = %s, Value = %s\n",Name,Value);
  for (N=0;N<20;N++)
   {
    GetDescriptorN(FrameBuffer, N, Name, Value);
    if (Name[0] == '\0') break;
    fprintf(stderr,"%d: %s = %s\n",N, Name, Value);
   }

  x = 18; y = 17;
  Pixel[0] = -1; Pixel[1] = -1; Pixel[2] = -1; Pixel[3] = -1;
  GetPixel(FrameBuffer, x, y, Pixel);
  fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
   x,y,Pixel[0],Pixel[1],Pixel[2],Pixel[3]);

  x += 5; y += 5;
  bottom = y-2; left = x-2; top = y+2; right = x+2;
  fprintf(stderr,"First Column of Block:\n");
  for(y=bottom; y<=top;y++)
   {
    Pixel[0] = 0; Pixel[1] = 0; Pixel[2] = 0; Pixel[3] = 0;
    GetPixel(FrameBuffer, left, y, Pixel);
    fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
                left,y,Pixel[0],Pixel[1],Pixel[2],Pixel[3]);
   }

  GetBlock(FrameBuffer,bottom,left,top,right, Block);
  fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
   left,bottom,Block[0][0],Block[0][1],Block[0][2],Block[0][3]);

  x += 5; y += 5;
  bottom += 5; left += 5; top += 5; right += 5;
  GetBlock(FrameBuffer,bottom,left,top,right, Block);
  fprintf(stderr,"AIS[%d,%d] = [%d, %d, %d, %d]\n",
   left,bottom,Block[0][0],Block[0][1],Block[0][2],Block[0][3]);

  CloseFB(&FrameBuffer);

  exit(0);
 }
