/*
   File: DisplayWFF.c
   Author: K.R. Sloan
	   S. Mann
   Last Modified: 6 April 1990
   Purpose: Display a WFF format image file on the ...
   See also: Display2c.
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

/* 1 */

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

#define DisplayPixel int
/* CHANGE FROM HERE */
/* 2 */typedef struct DSL
/* 2 */ { 
/* 2 */  int r[512];
/* 2 */  int g[512];
/* 2 */  int b[512];
/* 2 */ } DisplayScanLineType;
/* TO HERE */

static void
PackForDisplay(ScreenScanLinePtr,x, PixelPtr,
                BitsPerBand, KnownColorSystem)
 DisplayScanLineType *ScreenScanLinePtr;
 int x;
 unsigned short *PixelPtr;
 int BitsPerBand, KnownColorSystem;
 {
  int b;
  switch (KnownColorSystem)
   {
    case 1: /* RGB */
    case 2: /* RGBA */
     {
/* CHANGE FROM HERE */
/* 3 */      (ScreenScanLinePtr->r)[x] = PixelPtr[0] << (16-BitsPerBand);
/* 3 */      (ScreenScanLinePtr->g)[x] = PixelPtr[1] << (16-BitsPerBand);
/* 3 */      (ScreenScanLinePtr->b)[x] = PixelPtr[2] << (16-BitsPerBand);
/* TO HERE */
      break;
     }      
    case 3: /* I */
     {
      int I;
      I = PixelPtr[0] << (16-BitsPerBand);
      (ScreenScanLinePtr->r)[x] = I;
      (ScreenScanLinePtr->g)[x] = I;
      (ScreenScanLinePtr->b)[x] = I;
      break;
     }      
    case 4: /* D */
     {
      double D;
      int I; 
      D = ((double)(PixelPtr[0] << (16-BitsPerBand))) / (double)((2 << 16)-1);
      I = exp(D)*(double)((2 << 16)-1)/exp(1.0);
      (ScreenScanLinePtr->r)[x] = I;
      (ScreenScanLinePtr->g)[x] = I;
      (ScreenScanLinePtr->b)[x] = I;
      break;
     }      
    default:
     fprintf(stderr,"PackForDisplay: unknown Color System\n");
   } 
 }

static void
DisplayScanLine(ScreenScanLine,y, Left, Right)
 DisplayScanLineType *ScreenScanLine;
 int y, Left, Right;
 {
  int i;

/* CHANGE FROM HERE */
/* 4 */  fprintf(stdout,"%4d:%4d-%4d =",y,Left,Right);
/* 4 */  for (i=Left;i<=Right;i++)
/* 4 */   fprintf(stdout," %2x/%2x/%2x",ScreenScanLine->r[i],
/* 4 */                                 ScreenScanLine->g[i],
/* 4 */                                 ScreenScanLine->b[i]);
/* 4 */  fprintf(stdout,"\n");
/* TO HERE */
 }

static DisplayScanLineType ScreenScanLine;
static void
Display(FileDescriptor, PrintHeader)
 FILE *FileDescriptor;
 int PrintHeader;
 {
  FrameBufferType *FrameBuffer;
  int Left, Bottom, Top, Right, BitsPerBand, BandsPerPixel;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  int x,y,n;
  int KnownColorSystem;
  unsigned short ScanLine[8196]; /* this ought to be enough */
 
  FrameBuffer = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FrameBuffer))                   return;
  if (FAILURE == ReadImage(FileDescriptor, FrameBuffer)) return;

  if (PrintHeader)
   for (n=0;;n++)
    {
     GetDescriptorN(FrameBuffer, n, Name, Value);
     if (Name[0] == '\0') break;
     fprintf(stdout,"%d: [%s = %s]\n",n, Name, Value);
    }


  if (FAILURE == GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FrameBuffer); return; }
  if (FAILURE == GetColorSystem(FrameBuffer, WhatBands, &BitsPerBand))
   { (void)CloseFB(&FrameBuffer); return; }
  if (FAILURE == GetDescriptor(FrameBuffer,"BitsPerBand",Value))
   { (void)CloseFB(&FrameBuffer); return; }
  BitsPerBand = atoi(Value);

  BandsPerPixel = strlen(WhatBands);
  if      (0 == strcmp(WhatBands,"RGB"))  KnownColorSystem = 1;
  else if (0 == strcmp(WhatBands,"RGBA")) KnownColorSystem = 2;
  else if (0 == strcmp(WhatBands,"I"))    KnownColorSystem = 3;
  else if (0 == strcmp(WhatBands,"D"))    KnownColorSystem = 4;
  else 
   {
    fprintf(stderr,"Display: %s is unknown ColorSystem\n",WhatBands);
    if (BandsPerPixel < 3) 
     {
      KnownColorSystem = 3;
      fprintf(stderr,"Display: using ColorSystem = I\n");
     }
    else
     {
      KnownColorSystem = 1;
      fprintf(stderr,"Display: using ColorSystem = RGB\n");
     }
   }

  for (y=Bottom;y<=Top;y++)
   {
    if (FAILURE == GetBlock(FrameBuffer,y,Left,y,Right, ScanLine))
     { (void)CloseFB(FrameBuffer); return; }
    for (x=Left;x<=Right;x++)
     {
      PackForDisplay(&ScreenScanLine,x, &ScanLine[(x-Left)*BandsPerPixel], 
                     BitsPerBand, KnownColorSystem);
     }
    DisplayScanLine(&ScreenScanLine,y, Left, Right);
   }

  (void)CloseFB(&FrameBuffer);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
/* 5 */  int PrintHeader = 1;

  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

/* 6 */

  Display(stdin,PrintHeader);

/* CHANGE FROM HERE */
/* 7 */  fprintf(stdout,"\n                -30-\n");
/* TO HERE */
  exit (0);
}

