/*
** Author:      James Painter
** Purpose:     Convert a WFF file to Wiebe format (.wf). 
**
** Copyright (c), 1988 GRAIL, University of Washington
** $Revision$
** $Date$
** $Locker$
** $Log$
*/
#include <assert.h>
#include <stdio.h>
#include "wff.h"

static char *ProgramName;

				/* Forward declarations */
extern FrameBufferType *OpenWFFFile();
extern void  WriteWiebeHeader(), WriteWiebeScanLine(), ReadWFFScanLine(), 
             PackScanLine(), CloseWFFFile();

Usage()
{
  fprintf( stderr, "Usage: %s < input > output\n", ProgramName );
  exit(1);
}


main(argc,argv)
     int argc;
     char *argv[];
{
  int ArgsParsed = 0;
  int xsize, ysize;
  FrameBufferType *wffdesc;
  unsigned char *ScanLineOut[1024];
  unsigned short *ScanLineIn;
  int i;

  ProgramName = argv[ArgsParsed++];
  if (argc != ArgsParsed)  Usage();

  wffdesc = OpenWFFFile( stdin, &xsize, &ysize );
  assert( wffdesc );  

  WriteWiebeHeader( stdout, xsize, ysize );


  for(i=0; i<ysize; i++) {
    ScanLineOut[i]  = (unsigned char  *)
      calloc( (xsize+15) / 16, 2*sizeof(unsigned char) );
    assert( ScanLineOut[i] );
  }

  ScanLineIn = (unsigned short *)
    calloc( xsize, sizeof(unsigned short) );
  assert( ScanLineIn );

  for(i=0; i<ysize; i++) 
    {
      ReadWFFScanLine( wffdesc, xsize, ScanLineIn );
      PackScanLine( xsize, ScanLineIn, ScanLineOut[i] );
    }

  for(i=ysize-1; i >=0; i--) {
      WriteWiebeScanLine( stdout, xsize, ScanLineOut[i] );
    }
  CloseWFFFile( wffdesc );
}


void PackScanLine( xsize, ScanLineIn, ScanLineOut )
     int xsize;
     unsigned short *ScanLineIn;
     unsigned char *ScanLineOut;
{
  register unsigned short *pin, *pend;
  register unsigned char *pout;

  pin  = ScanLineIn; 
  pend = pin + xsize;
  pout = ScanLineOut;
  while ( pin < pend ) {	/* Unpack the bits */
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);             *pout <<= 1;
    *pout |= (*pin++ == 0);
    pout++;
  }
}


/*  These functions deal with Wiebe files */
void
WriteWiebeHeader( stream, xsize, ysize )
     FILE *stream;
     int xsize, ysize;
{
  int low, high;


  high = xsize / 256;
  low  = xsize % 256;
  putc(high,stream);
  putc(low ,stream);

  high = ysize / 256;
  low  = ysize % 256;
  putc(high,stream);
  putc(low ,stream);
}

void WriteWiebeScanLine( stream, xsize, ScanLine )
     FILE *stream;
     int xsize;
     unsigned char *ScanLine;
{
  int nwritten, towrite = (xsize+15)/16;

  nwritten = fwrite( ScanLine, 2, towrite, stream );
  assert( nwritten == towrite);
}

/* ------------------------------------------------------------------------ */

/* These function deal with WFF files */

FrameBufferType *  OpenWFFFile( stream, xsize, ysize )
     FILE *stream;
     int *xsize, *ysize;
{
  FrameBufferType *FrameBuffer = NULL;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];

  OpenFB(&FrameBuffer);
  assert(FrameBuffer);
  PassImageIn( stream, FrameBuffer);

  GetBounds(FrameBuffer, &Bottom, &Left, &Top, &Right);
  GetColorSystem(FrameBuffer, WhatBands,  &BitsPerBand);
  if (strcmp(WhatBands, "I") != 0) {
    fprintf( stderr, "WFF file must be I(ntensity) image\n");
    Usage();
  }
  *xsize = Right - Left + 1;
  *ysize = Top   - Bottom + 1;
    
  return FrameBuffer;
}  


void ReadWFFScanLine( wffdesc, xsize, ScanLine )
     FrameBufferType *wffdesc;
     int xsize;
     unsigned short *ScanLine;
{
  assert (SUCCESS == NextNPixelsIn( wffdesc, xsize, ScanLine ));
}


void CloseWFFFile( wffdesc )
     FrameBufferType *wffdesc;
{
  CloseFB( &wffdesc );
}

