/*
  File: wff2TeX.c
  Author: K.R. Sloan
  Last Modified: 11 January 1990
  Purpose: print a .wff image, in a form suitable for TeXing
 */

#include <stdio.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr, "Usage is\n\t%s [g] [t]\n", 
                  RoutineName);
 }

static char TTChars[]
 ="@mgWREM8B96HwaxSQNsdDA0GUKb5PFynVkzohO3CZvfXr4ctYT7/*L1Ji?lIj)+!;',:.";
static char GrayChars[]
 ="oonmlkjihgfedcba`_^]\\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543222";

/*
  NOTE: the first (last) character above are intentionally doubled (tripled).
        In fact, the character set includes  'p', '1', and '0'.
        However, these look ugly
 */

void wff2TeX(s, GrayChar)
 FILE *s;
 char GrayChar[65];
 {
  FrameBufferType *FB;
  int Left, Right, Top, Bottom, BitsPerBand;
  unsigned short Pixel[99], p;
  char WhatBands[80];
  int BitsPerPixel;
  int x, y; 

  FB = (FrameBufferType *)0;
  OpenFB(&FB);
  ReadImage(s, FB);
  GetBounds (FB, &Bottom, &Left, &Top, &Right);
  GetColorSystem (FB, WhatBands, &BitsPerPixel);  

  if (0 != strcmp(WhatBands, "I"))
   {
    fprintf(stderr, 
           "Warning:  ColorSystem: %s.  Treating first band as Intensity\n",
	    WhatBands );
   }

  for (y = Top; y >= Bottom; y--)   
   {
    for (x = Left; x <= Right; x++)
     {
      GetPixel(FB, x, y, Pixel);
      p = (Pixel[0] << (16 - BitsPerPixel)) >> 10;  /* 6 bit result */  
      fprintf(stdout,"%c", GrayChar[p]);
     }
    fprintf(stdout,"\n"); fflush(stdout);
   }
  CloseFB(&FB);
 }

int main(argc, argv)
 int argc;
 char *argv[]; 
 {
  int ArgsParsed = 0;
  char *font = GrayChars;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit (-1); }	
    switch (argv[ArgsParsed++][1])
     {
      case 't': font = TTChars; break;
      case 'g': font = GrayChars; break;
      default:
      case 'h': { usage(); exit (-1); }	 
     }
   }

  wff2TeX(stdin, font);

  exit (0);
 }
