#include <stdio.h>
#include <image.h>

IMAGE	*newvshim;
int	pixformat,
	dimc,
	newdimc,
	dimv[3] = {1,1,1},
	newdimv[3] = {1,1,1},
	newendpts[3][2],
	coarseness[3] = {1,1,1};
char	*pixvals;

IMAGE *subimcreat(vshim,newname,endpts)
IMAGE *vshim;
char newname[];
int endpts[3][2];
{

	int	i, j, top,		/* indices */
		numitems;		/* items in image */
	int	pixsize;		/* used to allocate space for image */
	char	*malloc();


	/* Open image */
	if (vshim == INVALID) return(INVALID);
	if (imdim(vshim,&pixformat,&dimc) == INVALID) errorterm();
	if (dimc>3) return(INVALID);

	/* Set up dimensions of new image */
	if (imbounds(vshim,dimv) == INVALID) errorterm();
	numitems = 1;
	newdimc = 0;
	for (i=0; i<dimc; i++) {
	    if (endpts[i][0] <0 | endpts[i][1] > (dimv[i]-1)) return(INVALID);
	    if ( (top = endpts[i][1]-endpts[i][0])>0){
		j=newdimc; newdimc++;
		newendpts[j][0]=0;
		newendpts[j][1]=top;
		numitems = numitems*(top+1);
		newdimv[j] = top+1;}
	    }
	if (newdimc==0){newdimc=1; dimv[0] = 1;}  /* extract one pixel */

	/* Open new image */
	if ((newvshim=imcreat(newname,DEFAULT,pixformat,newdimc,newdimv))
		== INVALID) errorterm();

	/* Allocate room and transfer subimage */
	switch(pixformat){
		case GREY: 
			pixsize = sizeof(GREYTYPE);
			break;
		case COLOR:
			pixsize = sizeof(COLORTYPE);
			break;
		case COLORPACKED:
			pixsize = sizeof(CPACKEDTYPE);
			break;
		case USERPACKED:
			pixsize = sizeof(USERTYPE);
			break;
		default:
			fprintf(stderr,"Unknown pixel type\n");
			break;
			}
	if ((pixvals = malloc(numitems*pixsize))==NULL)  return(INVALID);
	if (imgetpix(vshim,endpts,coarseness,(char *)pixvals) == INVALID) 
		errorterm();
	if (imputpix(newvshim,newendpts,coarseness,(char *)pixvals) == INVALID) 
		errorterm();
	free(pixvals);
	return(newvshim);

}
