/*
  File: Byrd2wffF.c
  Author: K.R. Sloan
  Last Modified: 17 January 1992
  Purpose: convert Vitria Byrd's images to wff

 */

#include <stdio.h>
#include <math.h>
#include "wff.h"

int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"usage is:\n\t%s [-h][-v]\n",
                   RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }


/* fixed size images - easy!  (but...upside down, sigh) */

#define ImageWidth  512
#define ImageLength 480
static unsigned char Image[ImageWidth][ImageLength];

static void ReadByrdImage(s)
 FILE *s;
 {
  int x,y;
  unsigned char p;

  for(y=0;y<ImageLength;y++)
   for(x=0;x<ImageWidth;x++)
    {
     fread(&p,1,1,s);
     Image[x][y] = p;
    }
 }

static void
Pass(fdIn, fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBout = (FrameBufferType *)0;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int  BitsPerBand, BandsPerPixel;
  int x,y;
  unsigned short Pixel[1];

  /* Read the Byrd image */
  ReadByrdImage(fdIn);
  
  /* Create and write out .wff header */
  FBout = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBout))  FatalError("OpenFB failed");
  Bottom = 0      ;             Left  = 0;
  Top    = ImageLength - 1;     Right = ImageWidth - 1;
  SetBounds(FBout, Bottom, Left, Top, Right);
  (void) strcpy(WhatBands,"I"); BitsPerBand = 8;
  SetColorSystem(FBout, WhatBands,  BitsPerBand);
  BandsPerPixel = 1;

  (void) strcpy(Name,"X-CreatedBy");
  (void) strcpy(Value,RoutineName);
  SetDescriptor(FBout, Name, Value);

  if (FAILURE == PassImageOut(fdOut, FBout))
   FatalError("PassImageOut failed");

  for (y=Bottom;y<=Top;y++) 
   for (x=Left;x<=Right;x++)
   {
    Pixel[0] = (unsigned short)Image[x][Top-y]; /* invert */
    if (FAILURE == NextPixelOut(FBout, Pixel))
     FatalError("NextPixelOut failed");
   }
  (void)CloseFB(&FBout);
 }

int main (argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0]) {usage(); exit(-1);}
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': usage(); exit(-1);
     }
   }

  Pass(stdin,stdout);
  exit(0);
 }
