/*
   File: rgba2a.c
   Authors: K.R. Sloan,
            James Painter
   Last Modified: 13 April 1988
   Purpose: Convert an rgba wff file to an intensity image (A channel).
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = NULL, *FBout = NULL;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int  BitsPerBand;
  int x,y,n;
  short Pixel[99];  /* that ought to be enough... */
  int passed = 0;
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

   /* Make sure the input image is an RGBA image */
  GetColorSystem( FBin, WhatBands, &BitsPerBand );
  if (strcmp(WhatBands,"RGBA") != 0) {
    fprintf( "Sorry. This program only knows how to deal with RGBA images.\n" );
    exit (1 );
  }
  /* Set the output color system */
  SetColorSystem( FBout, "I", BitsPerBand );
  
  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
  for (y=Bottom;y<=Top;y++)
   {
    for (x=Left;x<=Right;x++)
     {
      if (FAILURE == NextPixelIn(FBin,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
      /*
         this would be a good place to modify the Pixel
       */
      Pixel[0] = Pixel[3];
      if (FAILURE == NextPixelOut(FBout,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
     }
   }
  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);
  exit (0);
}

