/*
   File: Thresh.c
   Author: K.R. Sloan
   Last Modified: 30 May 1989
   Purpose: Pass a WFF format image file from stdin to stdout
            Produce a binary image, thresholding at t in [0.0, 1.0]
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

double atof();

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [t]\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut,Threshold)
 FILE *fdIn, *fdOut;
 double Threshold;
 {
  FrameBufferType *FBin, *FBout;
  int Bottom, Left, Top, Right, Bands;
  char Name[NameLength], Value[ValueLength], WhatBands[NameLength];
  int x,y,n,b,BitsPerBand,MaxValue;
  unsigned short Pixel[99];  /* that ought to be enough... */
  int passed = 0;
  unsigned short t;

 
  FBin  = (FrameBufferType *) 0;
  FBout = (FrameBufferType *) 0;
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
  GetColorSystem(FBin,WhatBands,&BitsPerBand);
  Bands = strlen(WhatBands);

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  MaxValue = (1 << BitsPerBand) -1;
  t = (double)MaxValue * Threshold;
  for (y=Bottom;y<=Top;y++)
   {
    for (x=Left;x<=Right;x++)
     {
      if (FAILURE == NextPixelIn(FBin,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

      for (b=0;b<Bands;b++)
       if (Pixel[b] < t) Pixel[b] = 0;
       else              Pixel[b] = MaxValue;

      if (FAILURE == NextPixelOut(FBout,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
     }
    wffFlush(FBout);
   }

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  double Threshold = 0.5;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  Threshold = atof(argv[ArgsParsed++]);
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout,Threshold);

  exit (0);
}

