/*
  File: Combine.c
  Author: K.R. Sloan
  Last Modified: 1 June 1990
  Purpose: Combine n single band images into one multiband image
           someday, perhaps someone will write "Separate"  
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

static char *RoutineName;

static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-b bands band0.wff band1.wff ...][-h]\n",
           RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s\n",s); exit(1);
 }

static void
Pass(WhatBands,BandsPerPixel,fdIn,fdOut)
 char *WhatBands;
 int BandsPerPixel;
 FILE *fdIn[];
 FILE *fdOut;
 {
  FrameBufferType *FBin[10]; /* that should be enough */
  FrameBufferType *FBout;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n;
  unsigned short *Pixel;
  int passed = 0;
  int b;

  for(b=0;b<BandsPerPixel;b++)
   {     
    FBin[b] = (FrameBufferType *)0;
    if (FAILURE == OpenFB(&FBin[b]))
     FatalError("OpenFB fails on input"); 
    if (FAILURE == PassImageIn(fdIn[b], FBin[b]))
     FatalError("PassImageIn fails");
   }

  FBout =  (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBout))   FatalError("OpenFB fails on output");
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  /*  believe the first input band image  for everything except ColorSystem */
  /*  someone ambitious can add consistency checking... */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin[0], n, Name, Value);
    if (Name[0] == '\0') break;

    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }

    if (0 == strcmp(Name,"ColorSystem"))
     SetDescriptor(FBout, Name, WhatBands);
    else SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   FatalError("PassImageOut failed");

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin[0], &Bottom, &Left, &Top, &Right)) 
   FatalError("GetBounds failed");

  Pixel = (unsigned short *) 
    malloc( sizeof(unsigned short) * (unsigned)(BandsPerPixel) );
  if ((unsigned short *)0 == Pixel)
   FatalError("No memory for scan line buffer");
      
  for (y=Bottom;y<=Top;y++)
   {
     for(x=Left; x <=Right; x++) 
       {
         for(b=0; b<BandsPerPixel; b++)
          if (FAILURE == NextPixelIn(FBin[b], &Pixel[b]))
           FatalError("NextPixelIn failed");
	 if (FAILURE == NextPixelOut(FBout, Pixel))
           FatalError("NextPixelOut failed");
       }
   }       

  for (b=0;b<BandsPerPixel;b++) (void)CloseFB(&FBin[b]);
  (void)CloseFB(&FBout);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  char *WhatBands;
  int BandsPerPixel,b;
  char *FileName[10];
  FILE *fdIn[10];

  RoutineName = argv[ArgsParsed++];
  while (ArgsParsed < argc)
   {
    if ('-' != argv[ArgsParsed][0])   { usage(); exit (-1); }
    switch (argv[ArgsParsed++][1])
     {
      case 'b': 
                if (argc <= ArgsParsed)  { usage(); exit (-1); }
                WhatBands = argv[ArgsParsed++];
                BandsPerPixel = strlen(WhatBands);
                if ((argc-ArgsParsed) < BandsPerPixel) { usage(); exit (-1); }
                if (10 < BandsPerPixel) FatalError("too many bands");   
                for (b=0;b<BandsPerPixel;b++)
                 FileName[b] = argv[ArgsParsed++];
                break; 

      default:
      case 'h': { usage(); exit (-1); }
     }
   }  


  for (b=0;b<BandsPerPixel;b++)
   if (!(fdIn[b] = fopen(FileName[b],"r"))) FatalError("fopen failed");

  Pass(WhatBands,BandsPerPixel,fdIn,stdout);

  exit (0);
}

