/*
** Author:      James Painter
** Purpose:     Microcode interface to REMOTE uEngine
**
** Copyright (c), 1988 GRAIL, University of Washington
**
** $Revision$
** $Date$
** $Locker$
** $Log$
*/
#include <stdio.h>
#include "uEngine.h"


/* Private variables */
Args *_uEArgs = 0;		/* Point to argument block */
int *_uEnext;			/* next pointer int _uEArgs->cmd */
int *_uEend;			/* end pointer for  _uEArgs->cmd */
int   _uEcolor = -1;		/* Current color */

FILE *uEngineFile = 0;

uESync( )
{
  fflush( uEngineFile );
}

/* Wait for all pending commands to finish, then write out buffered commands */
uEFlush()
{
  int i, size;
  int *next, *end;
   
  /* Send the new data down */
  _uEArgs->count = (_uEnext  - _uEArgs->cmd);
  size = _uEArgs->count;
  next =  _uEArgs->cmd;
  end  = next + size;
  while (next < end) {
    i = *next++;
    putc( i & 0xFF, uEngineFile ); i >>= 8;
    putc( i & 0xFF, uEngineFile ); i >>= 8;
    putc( i & 0xFF, uEngineFile ); i >>= 8;
    putc( i & 0xFF, uEngineFile );
  }

  /* Reset args */
  _uEnext = _uEArgs->cmd;

  return 0; /* success */
}
  

/*
  Initalize uEngine.  Mode can be HighRes or LowRes.
 */
int uEInitialize(Mode)
 mode Mode;
 {
   extern char *malloc();
  /* Allocate memory for the microcode command buffer */
  _uEArgs = (Args *) malloc( sizeof(Args) + BUFFER_SIZE*sizeof(int) );
  if (_uEArgs == 0) 
    fprintf(stderr, "No memory for microcode command buffer!\n" );
  else {
    _uEnext = _uEArgs->cmd;
    _uEend  = _uEnext + BUFFER_SIZE;
  }

  uEngineFile = stdout;
  putc( Mode, uEngineFile ); putc( 0, uEngineFile); putc( 0, uEngineFile);
  putc( 0, uEngineFile);
  return( 0 ); /* success */ 
 }

/*
  devClose insures that all operations are complete and closes up
 */
int uEFinalize()
 {
   /* Flush any pending commands out to the bit slice */
   uEFlush();

   /* Wait for the commands to finish */
   uESync();

  return(0); /* success */ 
 }

