/*
  File: dev0/DEVICE.c
  Author: K.R. Sloan
  Last Modified: 10 February 1991
  Purpose: definitions for the generic graphics device used by SGP
           this version prints out a PostScript-style message for each call.

           Hack this code to port SGP to your favorite device.

           Even better, write an interpreter for the PostScript-style output,
           and pipe our output to your interpreter.

           Everything here is output-only.  For other assumptions/decisions,
           read the code.

           devPick always fails...
 */
#include <stdio.h>
#include "DEVICE.h"

/*  Device state  - made global for convenience ... */
int devLeft, devBottom, devRight, devTop;
int devClipL, devClipB, devClipR, devClipT;
int devCurrentColor;
FILE *devOutputStream = stdout;
double devAspectRatio = 1.0;
/*
   devInit initializes the display, loading color maps if necessary
   There are two modes: color and mono.  Here, we assume a full-color
   display, and the two modes are identical

   devInit may also need to fill in the "physical" size of the display
   here, we output the "physical" limits to help your interpreter 
 */
int devInit(color, OutputStream)
 int color;
 FILE *OutputStream;
 {
  devOutputStream = OutputStream;
  devLeft = 0;  devBottom = 0; devRight = 639; devTop = 479;
  fprintf(devOutputStream,"%d %d %d %d %d devInit\n",
             color,devLeft,devBottom,devRight,devTop);
  devSetClipWin(devLeft,devBottom,devRight,devTop);
  devCurrentColor = devColorCode(1.0, 1.0, 1.0);
  return(0); /* success */ 
 }

/*
  devClose insures that all operations have completed, and closes up
 */
int devClose()
 {
  fprintf(devOutputStream,"devClose\n");
  fflush(devOutputStream);
  return(0); /* success */
 }  

/*
  devSetClipWin establishes a clipping window
  restrictions such as (L<R) must be enforced here!
 */
int devSetClipWin(L, B, R, T)
 int L, B, R, T;
 {
  if (L<R) { devClipL=L; devClipR=R; } else { devClipL=R; devClipR=L;} 
  if (B<T) { devClipB=B; devClipT=T; } else { devClipB=T; devClipT=B;} 
  if (devLeft < devRight)
   {
    if (devClipL < devLeft)   devClipL = devLeft;
    if (devClipR > devRight)  devClipR = devRight;
   }
  else
   {
    if (devClipL < devRight)  devClipL = devRight;
    if (devClipR > devLeft)   devClipR = devLeft;
   }

  if (devBottom < devTop)
   {
    if (devClipB < devBottom) devClipB = devBottom;
    if (devClipT > devTop)    devClipT = devTop;
   }
  else 
   {
    if (devClipB < devTop)    devClipB = devTop;
    if (devClipT > devBottom) devClipT = devBottom;
   }

  fprintf(devOutputStream,"%d %d %d %d devSetClipWin\n",
            devClipL, devClipB, devClipR, devClipT);

  return(0); /* success */
 }

/*
 devClearScreen fills the entire screen with a particular color
 */
int devClearScreen(color)
 int color;
 {
  fprintf(devOutputStream,"%d devClearScreen\n",color);
  return(0); /* success */
 }

/*
   the following routines draw primitive shapes on the physical device
   All of them clip against the device's clipping window.
   All of them paint in the device's current color
 */

/*
  devLine draws a line
 */
int devLine(x0, y0, x1, y1)
 int x0, y0, x1, y1; 
 {
  fprintf(devOutputStream,"%d %d %d %d devLine\n", x0, y0, x1, y1);
  return(0); /* success */
 }

/*
 devRect fills a rectangle
 */
int devRect(L, B, R, T)
 int L, B, R, T;
 {
  fprintf(devOutputStream,"%d %d %d %d devRect\n", L, B, R, T);
  return(0); /* success */
 }

/*
 devDisc fills a disc
 */
int devDisc(x, y, r)
 int x, y, r;
 {
  fprintf(devOutputStream,"%d %d %d devDisc\n", x, y, r);
  return(0); /* success */
 }

/*
 devCircle draws a circle
 */
int devCircle(x,y,r)
 int x,y,r;
 {
  fprintf(devOutputStream,"%d %d %d devCircle\n", x, y, r);
  return(0); /* success */
 }

/*
 devSolidTriangle fills a triangle
 */
int devSolidTriangle(x0, y0, x1, y1, x2, y2)
 int x0, y0, x1, y1, x2, y2;
 {
  fprintf(devOutputStream,"%d %d %d %d %d %d devSolidTriangle\n",
                  x0, y0, x1, y1, x2, y2);
  return(0); /* success */
 }

/*
 devShadeTriangle shades a triangle
   with color codes specified at each vertex
 */
int devShadeTriangle(x0, y0, c0, x1, y1, c1, x2, y2, c2)
 int x0, y0, c0, x1, y1, c1, x2, y2, c2;
 {
  fprintf(devOutputStream,"%d %d %d %d %d %d %d %d %d devShadeTriangle\n",
                  x0, y0, c0, x1, y1, c1, x2, y2, c2);
  return(0); /* success */
 }

/*
 devSetColor establishes the current color
 */
int devSetColor(color)
 int color;
 {
  devCurrentColor = color;
  fprintf(devOutputStream,"%d devSetColor\n", color);
  return(0); /* success */
 }

/*
   devColorCode returns a framebuffer value - here we assume a full-color
   display, with 8-bits each of rgb, packed as:
            [00000000rrrrrrrrggggggggbbbbbbbb]
 */ 
int devColorCode(R, G, B)
 double R,G,B; 
 {
  int devR, devG, devB;

  devR = 255.0 * R;
  devG = 255.0 * G;
  devB = 255.0 * B;
  return (  ((devR & 0xff) << 16)
          | ((devG & 0xff) <<  8)
          | ((devB & 0xff)      ) );
 }

/*
  devColorDecode generates r,g,b values in [0.0, 1.0] 
 */
int devColorDecode(code, R, G, B)
 int code;
 double *R, *G, *B;
 {
  int devR, devG, devB;

  devR = (code >> 16) & 0xff;
  devG = (code >>  8) & 0xff;
  devB = (code      ) & 0xff;
  *R = (double)devR / 255.0;
  *G = (double)devG / 255.0;
  *B = (double)devB / 255.0;
  return (0);
 }

int devPick(x,y,button)
 int *x,*y,*button;
 {
  *x = 0; *y = 0; *button = 0; return(-1);  /* what pointer? */
 }
/*       -30-         */

