/*
  File: Triangles.h
  Author: K.R. Sloan
  Last Modified: 18 April 1990
  Purpose: hidden-surface rendering of triangles

           The user program should allocate an array of TriangleType3D,
           and fill in the geometry and color information for each vertex.

           RenderTriangles displays the entire collection of triangles,
           with hidden surfaces removed.      

           NOTE: RenderTriangles destroys the contents of the Triangle array.

 */
typedef struct T3D
                {
                 /* for each (of three) vertex */
                 /* user specifies geometry in World Coordinates */
                 PointType3D   Vertex[3];
                 VectorType3D  Normal[3];
                 sgpColorType  Diffuse[3];
                 sgpColorType  Specular[3];
                 double        Specularity[3];
                 /* for the triangle as a whole */ 
                 VectorType3D  N;
                 double        d;
                 /* in ViewBox */ 
                 double MinX, MinY, MinZ;
                 double MaxX, MaxY, MaxZ;
                 /* for loop control */
                 int Looping;
		} TriangleType3D;

extern void RenderTriangles(); /* RenderTriangles(n, T, MaxT)
                                   int n;
                                   TriangleType3D T[MaxT];       
                                   int MaxT;                  */
extern void RenderMode(); /* RenderMode(Preview, Interior, Outline)
                                   int Preview;
                                   sgpColorType Interior, Outline; */

/*
   this function is provided here as a public service
 */ 
static void PrintTriangle(s,t)
 FILE *s;
 struct T3D *t;
 {
  fprintf(s,"[%f %f %f][%f %f %f][%f %f %f]\n",
              t->Vertex[0].x, t->Vertex[0].y, t->Vertex[0].z,
              t->Vertex[1].x, t->Vertex[1].y, t->Vertex[1].z,
              t->Vertex[2].x, t->Vertex[2].y, t->Vertex[2].z);
  fprintf(s,"[%f %f %f][%f %f %f][%f %f %f]\n",
              t->Normal[0].dx, t->Normal[0].dy, t->Normal[0].dz,
              t->Normal[1].dx, t->Normal[1].dy, t->Normal[1].dz,
              t->Normal[2].dx, t->Normal[2].dy, t->Normal[2].dz);
  fprintf(s,"[%f %f %f][%f %f %f] %f\n",
              t->Diffuse[0].r, t->Diffuse[0].g, t->Diffuse[0].b,
              t->Specular[0].r, t->Specular[0].g, t->Specular[0].b,
              t->Specularity[0]);
  fprintf(s,"[%f %f %f][%f %f %f] %f\n",
              t->Diffuse[1].r, t->Diffuse[1].g, t->Diffuse[1].b,
              t->Specular[1].r, t->Specular[1].g, t->Specular[1].b,
              t->Specularity[1]);
  fprintf(s,"[%f %f %f][%f %f %f] %f\n",
              t->Diffuse[2].r, t->Diffuse[2].g, t->Diffuse[2].b,
              t->Specular[2].r, t->Specular[2].g, t->Specular[2].b,
              t->Specularity[2]);

  fprintf(s,"sgpTriangle\n");
 }

/*
  these are kludge-control.  BEWARE: because of these, it is a bit more 
  difficult to use "Scanline", or "Warnock" alone.  See the comments there.
  If you used "Triangles" alone, or both "Triangles" and "Scanline", all
  is well
 */
extern int TwoSided, LeftHanded, Facets;
extern sgpColorType Background;
extern double Transparency;
 
