/*
  File: Contours.c
  Author: K.R. Sloan, Jr. , James Painter, David Meyers
  Last Modified 8 November 1989
  Purpose: definitions for Points and Contours
 */

#include <TypeDefinitions.h>
#include <Contours.h>
#include <errno.h>
#include <stdio.h>
extern char *malloc(); 
extern void free();
extern void perror();

PointsType *NewPoints(HowMany)
 int HowMany;
 {
  PointsType *New;
  if (!(New = (PointsType *)malloc( sizeof (PointsType))))
   {
    (void) fprintf(stderr,"NewPoints: no memory!\n");
    return (PointsType *)0;
   }
  if (!(New->P = (PointType *)malloc( (unsigned) HowMany*sizeof (PointType))))
   {
    (void) fprintf(stderr,"NewPoints: no memory!\n");
    free((char*)New);
    return (PointsType *)0;
   }
  New->n = HowMany;
  return New;
 }


/*
** FreePoints releases a contour created with NewPoints.
*/
void FreePoints ( c )
 PointsType *c;
 {
  free ( (char *) c->P );
  free ( (char *) c );
 }

/*
** CopyPoints makes a copy of a list of Points
*/
PointsType *CopyPoints ( c )
 PointsType *c;
 {
  int i;
  PointsType *Result;

  Result = NewPoints ( c->n );
  if (!Result) return Result;
  for (i=0; i< c->n; i++ )
    Result->P[i] = c->P[i];
  return Result;
 }
