/**********************************************************************
 *
 * z3950server.h --
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef Z3950SERVER_H
#define Z3050SERVER_H

#include "comtypes.h"

// each "server" (ie collection) consists of a {z39.50 server + database} pair.
class z3950_server {
 protected:
  text_t title;    // Descriptive name
  text_t z_initstr; // a string returned when the connection is initialised.
  text_tmap meta;  // metadata for this collection (ie server/database pair)
  text_tmap format;
  text_tmap about; // langauge/abouttext pair for collection.
  ShortColInfo_t *info; // has  (database) name, host and port
  text_tarray *titles; 
  bool connect();
  bool connected; // tcp connection to the z39.50 server (target)
  bool gotsinglerecord; // if we do, then we don't need all titles...

 public:
  z3950_server();
  ~z3950_server();
  void setName(const text_t &newname);
  const text_t getName() {return title;}
  void setMeta(const text_t &key, const text_t &value);
  const text_tmap *getMeta() {return &meta;}
  const text_tmap *getFormat() {return &format;}
  void setInfo(ShortColInfo_t *newinfo) {info=newinfo;}
  const ShortColInfo_t *getInfo() {return info;}
  void addcfgAbout(const text_t &lang, const text_t &abouttext);
  bool getcfgAbout(const text_t &lang, text_t &abouttext);
  // now the functions that actually talk to the target (ie zserver) over tcp
  text_t &getzAbout(); // gets any name, id, MOTD, etc from server.
  text_tarray *getrecordTitles(const text_t &query,
			       const int querytype,
			       const text_t &fields,
			       const int first, const int count,
			       int *nummatches, comerror_t &err);
  /* only get one record at a time? (Eventually we could buffer them, but
     for now... */
  bool getfullrecord(const text_t &query, const int querytype,
		     const text_t &fields,
		     const int ID, text_t &rettitle, 
		     text_t &rettext,comerror_t &err);
 private:
  void parseQuery(const text_t &query, const int querytype, 
		  const text_t &fields, 
		  text_t &parsed_query);
};

typedef  vector<z3950_server *>  z3950_server_array;

#endif
