###########################################################################
#
# win32 makefile -- src/recpt
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = c:\gsdl
STLPATH = c:\stlport

AR = lib
CC = cl
CPPFLAGS =
LDFLAGS =
DEFS = -DNZDL -DQUIET -D__WIN32__ -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H \
       -DSHORT_SUFFIX -DPARADOCNUM -DHAVE_CONFIG_H -D__STL_NO_NEW_IOSTREAMS \
       -DGSDLSERVER -DGSDLUSAGELOG	
INCLUDES = -I$(GSDLHOME)\src\recpt -I$(GSDLHOME)\lib -I$(GSDLHOME)\src\colservr \
	   -I$(GSDLHOME)\packages\mg -I$(GSDLHOME)\packages\mg\lib \
	   -I$(GSDLHOME)\packages\mg\src\text -I$(GSDLHOME)\packages\wingdbm \
	   -I$(STLPATH) -I$(GSDLHOME)\packages\wincrypt

LIBS = $(GSDLHOME)\packages\wingdbm\gdbm.lib $(GSDLHOME)\packages\wincrypt\crypt.lib

COMPILE = $(CC) -c $(CPPFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) $(LDFLAGS) -o $@

.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


COMMONHEADERS = receptionist.h cgiwrapper.h cgiargs.h action.h browserclass.h \
                converter.h recptconfig.h cgiutils.h OIDtools.h browsetools.h htmlgen.h \
		statusaction.h pageaction.h comtypes.h recptproto.h \
		pingaction.h queryaction.h documentaction.h \
		extlinkaction.h buildaction.h htmlutils.h \
		querytools.h formattools.h tipaction.h authenaction.h infodbclass.h \
                userdb.h usersaction.h vlistbrowserclass.h hlistbrowserclass.h \
		datelistbrowserclass.h invbrowserclass.h pagedbrowserclass.h \
		htmlbrowserclass.h delhistoryaction.h historydb.h

RECEPTHEADERS = 

LIBRARYHEADERS = nullproto.h

HEADERS = $(COMMONHEADERS) $(RECPTHEADERS) $(LIBRARYHEADERS)


COMMONSOURCES = receptionist.cpp cgiwrapper.cpp cgiargs.cpp action.cpp browserclass.cpp \
                converter.cpp recptconfig.cpp cgiutils.cpp OIDtools.cpp browsetools.cpp \
		htmlgen.cpp statusaction.cpp pageaction.cpp comtypes.cpp \
		recptproto.cpp pingaction.cpp queryaction.cpp documentaction.cpp \
		extlinkaction.cpp buildaction.cpp htmlutils.cpp querytools.cpp formattools.cpp \
		tipaction.cpp authenaction.cpp infodbclass.cpp userdb.cpp usersaction.cpp \
		vlistbrowserclass.cpp hlistbrowserclass.cpp datelistbrowserclass.cpp \
		invbrowserclass.cpp pagedbrowserclass.cpp htmlbrowserclass.cpp \
		delhistoryaction.cpp historydb.cpp


RECPTSOURCES = recptmain.cpp

LIBRARYSOURCES = nullproto.cpp librarymain.cpp

SOURCES = $(COMMONSOURCES) $(RECPTSOURCES) $(LIBRARYSOURCES)


COMMONOBJECTS = receptionist.obj cgiwrapper.obj cgiargs.obj action.obj browserclass.obj \
                converter.obj recptconfig.obj cgiutils.obj OIDtools.obj browsetools.obj \
		htmlgen.obj statusaction.obj pageaction.obj comtypes.obj \
		recptproto.obj pingaction.obj queryaction.obj documentaction.obj \
		extlinkaction.obj buildaction.obj htmlutils.obj querytools.obj \
		formattools.obj tipaction.obj authenaction.obj \
                infodbclass.obj userdb.obj usersaction.obj vlistbrowserclass.obj \
		hlistbrowserclass.obj datelistbrowserclass.obj invbrowserclass.obj \
		pagedbrowserclass.obj htmlbrowserclass.obj delhistoryaction.obj \
		historydb.obj

RECPTOBJECTS = recptmain.obj

LIBRARYOBJECTS = nullproto.obj librarymain.obj

OBJECTS = $(COMMONOBJECTS) $(RECPTOBJECTS) $(LIBRARYOBJECTS)


COLSERVROBJECTS = $(GSDLHOME)\src\colservr\mgq.obj \
                  $(GSDLHOME)\src\colservr\mgsearch.obj \
                  $(GSDLHOME)\src\colservr\querycache.obj \
                  $(GSDLHOME)\src\colservr\queryinfo.obj \
                  $(GSDLHOME)\src\colservr\collectserver.obj \
                  $(GSDLHOME)\src\colservr\colservrconfig.obj \
                  $(GSDLHOME)\src\colservr\maptools.obj \
                  $(GSDLHOME)\src\colservr\filter.obj \
                  $(GSDLHOME)\src\colservr\source.obj \
                  $(GSDLHOME)\src\colservr\browsefilter.obj \
                  $(GSDLHOME)\src\colservr\queryfilter.obj \
                  $(GSDLHOME)\src\colservr\mggdbmsource.obj \
                  $(GSDLHOME)\src\colservr\phrasesearch.obj \
                  $(GSDLHOME)\src\colservr\phrasequeryfilter.obj

EXEC = recpt.exe library.exe

all: $(EXEC)

clean:
	del *.obj
	del recpt.exe
	del library.exe

install:
	copy library.exe $(GSDLHOME)\cgi-bin\library.exe

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

RECPT_OBJS = $(COMMONOBJECTS) $(RECPTOBJECTS) \
    $(GSDLHOME)\lib\gsdllib.lib  \
    $(GSDLHOME)\packages\mg\src\text\libtextin.lib \
    $(GSDLHOME)\packages\mg\lib\libmg.lib

recpt.exe: $(RECPT_OBJS)
           $(LINK) $(RECPT_OBJS) $(LIBS) 

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

LIBRARY_OBJS = $(COMMONOBJECTS) $(LIBRARYOBJECTS) $(COLSERVROBJECTS) \
    $(GSDLHOME)\lib\gsdllib.lib \
    $(GSDLHOME)\packages\mg\src\text\libtextin.lib \
    $(GSDLHOME)\packages\mg\lib\libmg.lib

library.exe: $(LIBRARY_OBJS)
	     $(LINK) $(LIBRARY_OBJS) $(LIBS) 
