/**********************************************************************
 *
 * queryaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef QUERYACTION_H
#define QUERYACTION_H

#include "gsdlconf.h"
#include "action.h"
#include "receptionist.h"

struct colinfo_t {
  void clear();
  colinfo_t () {clear();}

  format_t *formatlistptr;
  browserclass *browserptr;
};

struct QueryResult_t {
  void clear ();
  QueryResult_t () {clear();}

  ResultDocInfo_t doc;
  text_t collection;
};

struct gteqQueryResult_t 
{
  bool operator()(const QueryResult_t &t1, const QueryResult_t &t2) const
  { return t1.doc.ranking >= t2.doc.ranking; }
};

typedef set<QueryResult_t, gteqQueryResult_t> QueryResult_tset;


class queryaction : public action {

protected:

  receptionist *recpt;

  text_t formatstring;
  int num_phrases;

  virtual void define_query_macros (cgiargsclass &args, displayclass &disp, 
			    const FilterResponse_t &response); 

  void define_form_macros (displayclass &disp, cgiargsclass &args, 
			   recptprotolistclass *protos, ostream &logout);

  void set_fqfselection_macro (const FilterOption_t &option, 
			      displayclass &disp);


  void define_history_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  virtual void set_option_macro (const text_t &macroname, text_t current_value,
			 const FilterOption_t &option, displayclass &disp);

  void output_ccp (cgiargsclass &args, recptprotolistclass *protos,
		   displayclass &disp, outconvertclass &outconvert,
		   ostream &textout, ostream &logout);
  
  bool search_multiple_collections (cgiargsclass &args, 
				    recptprotolistclass *protos,
				    browsermapclass *browsers, 
				    displayclass &disp,
				    outconvertclass &outconvert, 
				    ostream &textout,
				    ostream &logout);
  
  bool search_single_collection (cgiargsclass &args, 
				 const text_t &collection,
				 recptprotolistclass *protos, 
				 browsermapclass *browsers, 
				 displayclass &disp, 
				 outconvertclass &outconvert, 
				 ostream &textout, ostream &logout);


  bool save_search_history(cgiargsclass &args, 
			   const FilterResponse_t &response); 

public:
  queryaction ();
  virtual ~queryaction () {}

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}
  
  void configure (const text_t &key, const text_tarray &cfgline);
  bool init (ostream &logout);
  
  virtual text_t get_action_name () {return "q";}
  
  virtual bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response, text_t &response_data, 
			 ostream &logout);
  
  virtual void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  virtual void define_external_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);
  
  virtual bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);
};

#endif
