/**********************************************************************
 *
 * htmlgen.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "htmlgen.h"
#include "unitool.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\map>
#elif defined(GSDL_USE_STL_H)
#  include <map.h>
#else
#  include <map>
#endif



// highlighttext highlights query terms in text string and 
// outputs the resulting text string
void highlighttext (text_tarray &termvars, displayclass &disp, text_t &text,
		    outconvertclass &outconvert, ostream &textout, ostream &/*logout*/) {
  map<text_t, int, lttext_t> terms;
  map<text_t, int, lttext_t>::const_iterator it;
  for (unsigned int i = 0; i < termvars.size(); i++) {
    terms[termvars[i]] = 1;
  }

  // get the text to start and end a hightlight
  text_t starthighlight = "<b><u>";
  text_t endhighlight = "</u></b>";
  if (disp.isdefaultmacro("Global", "starthighlight"))
    disp.expandstring("Global", "_starthighlight_", starthighlight);
  if (disp.isdefaultmacro("Global", "endhighlight"))
    disp.expandstring("Global", "_endhighlight_", endhighlight);


  text_t::iterator here = text.begin(); 
  text_t::iterator end = text.end();
  text_t word, buffer;
  while (here != end) {
    if (is_unicode_letdig(*here)) {
      // not word boundary
      word.push_back(*here);
      here++;

    } else {
      // found word boundary
      // add last word if there was one
      if (!word.empty()) {
	it = terms.find(word);
	if (it != terms.end()) {
	  word = starthighlight + word + endhighlight;
	}
	buffer += word;
        word.clear();
      }

      if (*here == '<') {
        // skip over rest of html tag
	while ((here != end) && (*here != '>')) {
	  buffer.push_back(*here);
	  here++;
	}
      }

      buffer.push_back(*here);
      here++;

      if (buffer.size() > 1024) {
	textout << outconvert << buffer;
	buffer.clear();
      }
    }
  }
  textout << outconvert << buffer;
}
