/**********************************************************************
 *
 * datelistbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "datelistbrowserclass.h"
#include <assert.h>


datelistbrowserclass::datelistbrowserclass () {
}

datelistbrowserclass::~datelistbrowserclass () {
}

text_t datelistbrowserclass::get_browser_name () {
  return "DateList";
}

void datelistbrowserclass::load_metadata_defaults (text_tset &metadata) {
  metadata.insert ("Date");
  metadata.insert ("doctype");
}

text_t datelistbrowserclass::get_default_formatstring () {
  return "<td>[link][icon][/link]</td><td>[highlight]{Or}{[Title],Untitled}[/highlight]</td><td>[Date]</td>";
}

int datelistbrowserclass::output_section_group (ResultDocInfo_t &/*section*/, cgiargsclass &/*args*/,
						const text_t &/*collection*/, int /*colnumber*/, 
						format_t * /*formatlistptr*/, bool /*use_table*/, 
						text_tset &/*metadata*/, bool &/*getParents*/,
						recptproto * /*collectproto*/, displayclass &/*disp*/, 
						outconvertclass &/*outconvert*/, ostream &/*textout*/, 
						ostream &/*logout*/) {
  return 0;
}

int datelistbrowserclass::output_section_group (FilterResponse_t &sections, cgiargsclass &args,
						const text_t &collection, int colnumber, format_t *formatlistptr, 
						bool use_table, text_tset &/*metadata*/, bool &/*getParents*/,
						recptproto * collectproto, displayclass &disp, 
						outconvertclass &outconvert, ostream &textout, ostream &logout) {

  text_t lastyear = "0000";
  text_t lastmonth = "00";
  text_t tabbing, endtabbing;

  if (use_table || colnumber > 0) {
    textout << "<table><tr><td>";
    // get tab size
    text_t tab; int itab;
    disp.expandstring ("Global", "_tabwidth_", tab);
    itab = tab.getint();
    if (colnumber > 0) 
      textout << "<img src=\"_httpimg_/space.gif\" width=" << (itab*colnumber) << ">";
    textout<< "</td><td>";
  }

  textout << "<table>\n";

  ResultDocInfo_tarray::iterator thissection = sections.docInfo.begin();
  ResultDocInfo_tarray::iterator endsection = sections.docInfo.end();

  while (thissection != endsection) {

    text_t &doctype = (*thissection).metadata["doctype"].values[0];
    text_t &date = (*thissection).metadata["Date"].values[0]; 

    // bail on this document if it has no date
    if (date.empty()) continue;

    text_t::const_iterator datebegin = date.begin();
    int datesize = date.size();
    
    if (datesize < 4) continue;
    text_t thisyear = substr (datebegin, datebegin+4);
    text_t thismonth = "00";
    if (datesize >= 6)
      thismonth = substr (datebegin+4, datebegin+6); 

    text_t link = "<a href=\"_httpdocument_&cl=";
    text_t icon = "_document:iconclosedbook_";
      
    if (doctype == "classify") {
      icon = "_document:iconclosedbookshelf_";
      link += (*thissection).OID + "\">";
    } else link += args["cl"] + "&d=" + (*thissection).OID + "\">";

    textout << "<tr valign=top>";

    if (thisyear != lastyear) {
      textout << outconvert << "<td><b>" << thisyear << "</b></td>";
      lastyear = thisyear;
    } else
      textout << "<td></td>";
    
    if (thismonth != lastmonth) {
      textout << outconvert << disp << ("<td><b>_textmonth" + thismonth + "_</b></td>");
      lastmonth = thismonth;
    } else
      textout << "<td></td>";
    
    if (!use_table) textout << "<td>\n";
    
    textout << outconvert << disp 
            << get_formatted_string (collection, collectproto,
				     *thissection, disp, formatlistptr, 
				     link, icon, false,
				     logout) << "\n";
    
    if (!use_table) textout << "</td>";
    
    textout << "</tr>\n";
    
    thissection ++;
  }

  textout << "</table>\n";

  if (use_table  || colnumber > 0) textout << "</td></tr></table>\n";
  return 1;
}
