/**********************************************************************
 *
 * collectoraction.h -- 
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef COLLECTORACTION_H
#define COLLECTORACTION_H

#include "action.h"
#include "receptionist.h"

class collectoraction : public action {
  
protected:

  bool disabled;
  receptionist *recpt;
  char *gsdlosc;
  char *gsdlhomec;
  char *pathc;

  text_t message;

  bool do_mkcol;

  text_t get_button (const text_t &thispage, const text_t &color, 
		     const text_t &type, bool enabled);

  void set_fullnamemenu (displayclass &disp, cgiargsclass &args,
			 recptprotolistclass *protos, ostream &logout);

  void set_cfgfile (displayclass &disp, cgiargsclass &args, ostream &logout);

  void set_statusline (displayclass &disp, cgiargsclass &args, ostream &logout);

  void update_cfgfile_clone (cgiargsclass &args, ostream &logout);

  void update_cfgfile_partial (cgiargsclass &args, ostream &logout);

  void update_cfgfile_complete (cgiargsclass &args, ostream &logout);

  text_t carriage_replace (const text_t &intext, int sw);

  text_t get_directory_name (const text_t &fullname);

  bool collection_protected (const text_t &collection);

  void assign_tmpname (cgiargsclass &args, ostream &logout);

  void gsdl_mkcol (cgiargsclass &args, ostream &logout);

  void gsdl_build (cgiargsclass &args, ostream &logout);

  void gsdl_cancel_build (cgiargsclass &args, ostream &logout);

  text_t get_collectdir (cgiargsclass &args);

  bool uses_weird_plugin (const text_t &collection);

  void create_colserver (const text_t &collection, ostream &logout);

  void remove_colservr (const text_t &collection, ostream &logout);

  bool create_event_header_file (const text_t &filename, cgiargsclass &args, 
				 ostream &logout);

  text_t get_event_header (cgiargsclass &args);

public:
  collectoraction ();
  virtual ~collectoraction ();

  void configure (const text_t &key, const text_tarray &cfgline);

  bool init (ostream &logout);

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  text_t get_action_name () {return "collector";}

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response,text_t &response_data, 
			 ostream &logout);

  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);
};


#endif
