###########################################################################
#
# gcc win32 makefile -- src/recpt
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 2000  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

AR = ar
RANLIB = ranlib
CC = g++
DELETE = del
INSTALL = copy

o = .o
/ = \\

CPPFLAGS = -g -Wall
DEFS = -D__WIN32__ -DGSDL_USE_IOS_H
LIBS = ..$/..$/packages$/wingdbm$/gdbm.a ..$/..$/packages$/wincrypt$/crypt.a

INCLUDES = -I"..$/..$/lib" -I"..$/colservr" -I"..$/..$/packages$/mg$/lib" \
           -I"..$/..$/packages$/mg$/src$/text" -I"..$/..$/packages$/wincrypt" \
           -I"..$/..$/packages$/wingdbm" -I"."
 
COMPILE = $(CC) -c $(DEFS) $(INCLUDES) $(CPPFLAGS)
LINK = $(CC) $(LDFLAGS) -o $@
 
.SUFFIXES:
.SUFFIXES: .c $o
.c$o:
	$(COMPILE) $<

.SUFFIXES: .cpp $o
.cpp$o:
	$(COMPILE) $< 

COMMONHEADERS = receptionist.h cgiwrapper.h cgiargs.h action.h browserclass.h \
                converter.h recptconfig.h cgiutils.h OIDtools.h browsetools.h htmlgen.h \
		statusaction.h pageaction.h comtypes.h recptproto.h \
		pingaction.h queryaction.h documentaction.h \
		extlinkaction.h buildaction.h htmlutils.h \
		querytools.h formattools.h tipaction.h authenaction.h infodbclass.h \
                userdb.h usersaction.h vlistbrowserclass.h hlistbrowserclass.h \
		datelistbrowserclass.h invbrowserclass.h pagedbrowserclass.h \
		htmlbrowserclass.h delhistoryaction.h historydb.h

RECEPTHEADERS = 

LIBRARYHEADERS = nullproto.h

HEADERS = $(COMMONHEADERS) $(RECPTHEADERS) $(LIBRARYHEADERS)


COMMONSOURCES = receptionist.cpp cgiwrapper.cpp cgiargs.cpp action.cpp browserclass.cpp \
                converter.cpp recptconfig.cpp cgiutils.cpp OIDtools.cpp browsetools.cpp \
		htmlgen.cpp statusaction.cpp pageaction.cpp comtypes.cpp \
		recptproto.cpp pingaction.cpp queryaction.cpp documentaction.cpp \
		extlinkaction.cpp buildaction.cpp htmlutils.cpp querytools.cpp formattools.cpp \
		tipaction.cpp authenaction.cpp infodbclass.cpp userdb.cpp usersaction.cpp \
		vlistbrowserclass.cpp hlistbrowserclass.cpp datelistbrowserclass.cpp \
		invbrowserclass.cpp pagedbrowserclass.cpp htmlbrowserclass.cpp \
		delhistoryaction.cpp historydb.cpp

RECPTSOURCES = recptmain.cpp

LIBRARYSOURCES = nullproto.cpp librarymain.cpp

SOURCES = $(COMMONSOURCES) $(RECPTSOURCES) $(LIBRARYSOURCES)


COMMONOBJECTS = receptionist$o cgiwrapper$o cgiargs$o action$o browserclass$o \
                converter$o recptconfig$o cgiutils$o OIDtools$o browsetools$o \
		htmlgen$o statusaction$o pageaction$o comtypes$o \
		recptproto$o pingaction$o queryaction$o documentaction$o \
		extlinkaction$o buildaction$o htmlutils$o querytools$o \
		formattools$o tipaction$o authenaction$o \
                infodbclass$o userdb$o usersaction$o vlistbrowserclass$o \
		hlistbrowserclass$o datelistbrowserclass$o invbrowserclass$o \
		pagedbrowserclass$o htmlbrowserclass$o delhistoryaction$o \
		historydb$o

RECPTOBJECTS = recptmain$o

LIBRARYOBJECTS = nullproto$o librarymain$o

OBJECTS = $(COMMONOBJECTS) $(RECPTOBJECTS) $(LIBRARYOBJECTS)


COLSERVROBJECTS = ..$/colservr$/mgq$o \
                  ..$/colservr$/mgsearch$o \
                  ..$/colservr$/querycache$o \
                  ..$/colservr$/queryinfo$o \
                  ..$/colservr$/collectserver$o \
                  ..$/colservr$/colservrconfig$o \
                  ..$/colservr$/maptools$o \
                  ..$/colservr$/filter$o \
                  ..$/colservr$/source$o \
                  ..$/colservr$/browsefilter$o \
                  ..$/colservr$/queryfilter$o \
                  ..$/colservr$/mggdbmsource$o \
                  ..$/colservr$/phrasesearch$o \
                  ..$/colservr$/phrasequeryfilter$o


EXEC = library.exe

all: $(EXEC)

clean:
	if EXIST *$o $(DELETE) *$o
	if EXIST $(EXEC) $(DELETE) $(EXEC)

install:
	$(INSTALL) $(EXEC) ..$/..$/cgi-bin$/

LIBRARY_OBJS = $(COMMONOBJECTS) $(LIBRARYOBJECTS) $(COLSERVROBJECTS) \
    ..$/..$/lib$/gsdllib.a  \
    ..$/..$/packages$/mg$/src$/text$/libtextin.a \
    ..$/..$/packages$/mg$/lib$/libmg.a

library.exe: $(LIBRARY_OBJS)
	$(LINK) $(LIBRARY_OBJS) $(LIBS) 
