/**************************************************************************
 *
 * mg_invf_dict_dump.cpp -- Program to printthe various inverted dictionaries
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mg_invf_dict_dump.cpp,v 1.2 2001/02/02 01:13:05 kjm18 Exp $
 *
 **************************************************************************/

#include "sysfuncs.h"
#include "messages.h"

#include "mg_files.h"
#include "invf.h"

/*
   $Log: mg_invf_dict_dump.cpp,v $
   Revision 1.2  2001/02/02 01:13:05  kjm18
   changed the help message

   Revision 1.1  2000/01/14 02:17:51  sjboddie
   Rodgers new C++ mg

 */


static void process_files (char *filename,
			   bool printHeader,
			   bool printWords,
			   bool printTags) {
  // open the dictionary
  FILE *dictFile = open_file (filename, INVF_DICT_SUFFIX, "rb",
			      MAGIC_STEM_BUILD, MG_ABORT);
  invf_dict_header idh;
  idh.Read (dictFile);

  // print the information from the inverted dictionary file header
  if (printHeader) {
    cout << "lookback: " << idh.lookback << "\n";
    cout << "word_dict_start: " << idh.word_dict_start << "\n";
    cout << "word_dict_size: " << idh.word_dict_size << "\n";
    cout << "tag_dict_start: " << idh.tag_dict_start << "\n";
    cout << "tag_dict_size: " << idh.tag_dict_size << "\n";
    cout << "num_docs: " << idh.num_docs << "\n";
    cout << "num_frags: " << idh.num_frags << "\n";
    cout << "num_words: " << idh.num_words << "\n";
    cout << "total_bytes: " << idh.total_bytes << "\n";
    cout << "index_string_bytes: " << idh.index_string_bytes << "\n";
    cout << "num_levels: " << idh.num_levels << "\n";

    cout << "\n";
  }


  if (printWords) {
    fseek (dictFile, idh.word_dict_start, SEEK_SET);
    
    unsigned long wordNum;
    word_dict_el wordEl;
    wordEl.SetNumLevels (idh.num_levels);
    for (wordNum=0; wordNum<idh.word_dict_size; wordNum++) {
      wordEl.Read (dictFile, idh.num_levels);
      cout << "\"" << wordEl.el << "\"\n";// (" << wordNum << ")\n";
    }
    
    cout << "\n";
  }

  // write out the tag part of the dictionary
  if (printTags) {
    fseek (dictFile, idh.tag_dict_start, SEEK_SET);
    
    unsigned long tagNum;
    dict_el tagEl;
    for (tagNum=0; tagNum<idh.tag_dict_size; tagNum++) {
      // read in the next tag and inverted file pointer
      tagEl.Read (dictFile);
      
      cout << "\"" << tagEl.el << "\" (" << tagNum << ")\n";
    }
  }
  
  // close open files
  fclose (dictFile);
}


int main (int argc, char **argv) {
  char *filename = "";
  int ch;
  msg_prefix = argv[0];
  opterr = 0;

  bool printHeader = false;
  bool printWords = false;
  bool printTags = false;

  while ((ch = getopt (argc, argv, "f:d:rwth")) != -1) {
    switch (ch) {
    case 'f':		// input file
      filename = optarg;
      break;
    case 'd':
      set_basepath (optarg);
      break;
    case 'r':
      printHeader = true;
      break;
    case 'w':
      printWords = true;
      break;
    case 't':
      printTags = true;
      break;
    case 'h':
    case '?':
      fprintf (stderr, "usage: %s [-h] [-r] [-w] [-t] [-f input_file] "
	       "[-d data directory]\n(-rwt:print header, words, tags)\n", 
	       argv[0]);
      exit (1);
    }
  }

  process_files (filename, printHeader, printWords, printTags);
  return 0;
}
