/**************************************************************************
 *
 * mg_decompress_text.cpp -- 
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mg_decompress_text.cpp,v 1.2 2000/04/18 04:02:02 kjm18 Exp $
 *
 **************************************************************************/

#include "sysfuncs.h"

#include "TextGet.h"
#include "UCArray.h"

#include "messages.h"
#include "mg_files.h"


int main (int argc, char **argv) {
  int ch;
  char *filename = "";
  char *basePath = "";
  UCArray level;
  SetCStr (level, "Document");

  opterr = 0;
  msg_prefix = argv[0];

  // process the command line arguments
  while ((ch = getopt (argc, argv, "f:d:K:h")) != -1) {
    switch (ch) {
    case 'f':		/* input file */
      filename = optarg;
      break;
    case 'd':
      basePath = optarg;
      set_basepath (optarg);
      break;
    case 'K':
      SetCStr (level, optarg);
      break;
    case 'h':
    case '?':
      fprintf (stderr, "usage: %s [-h] [-K level] [-d directory] -f name\n",
	       argv[0]);
      exit (1);
    }
  }

  // load up the text information
  TextData td;
  if (!td.LoadData (basePath, filename)) {
    FatalError (1, "Couldn't load text information for \"%s\"", filename);
  }
  
  // output each document in the level
//    cout << td.levels << "\n";
  
  TextLevelInfo levelInfo = td.levels.levelInfo[level];
  unsigned long docNum = 1;
  UCArray docText;
  while (docNum <= levelInfo.numEntries) {
//      TextIdx docIdx;
//      if (GetDocIdx (td, level, docNum, docIdx)) {
//        cout << "doc: " << docNum << "\n";
//        cout << docIdx;
//      }
    
    if (!GetDocText (td, level, docNum, docText)) {
      FatalError (1, "Error while trying to get document %u", docNum);
    }

    cout << docText << "\n";
    
    docNum++;
  }
  
  return 0;
}


