/**************************************************************************
 *
 * WordData.h -- 
 * Copyright (C) 1999  NZDL
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: WordData.h,v 1.1 2000/01/14 02:26:03 sjboddie Exp $
 *
 **************************************************************************/

class WordData
{

 public:
  unsigned long docCount;
  unsigned long wordCount;

  inline void read(FILE *f)
    {
      fread((char *) &docCount, sizeof(docCount), 1, f);
      fread((char *) &wordCount, sizeof(wordCount), 1, f);

      NTOHUL(docCount);
      NTOHUL(wordCount);
    }

  inline unsigned long documents()
    {
      return docCount;
    }

  inline int words()
    {
      return wordCount;
    }
};
