/**************************************************************************
 *
 * TextGet.h -- Decompressing the text
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TextGet.h,v 1.2 2000/04/18 04:02:02 kjm18 Exp $
 *
 **************************************************************************/

#ifndef TEXTGET_H
#define TEXTGET_H

#include "text.h"
#include "FText.h"


class TextData {
public:
  compression_dict cd;
  FILE *textFile;
  FILE *textIdxFile;
  compressed_text_header cth;
  FTextLevel levels;

  TextData ();
  void Clear ();

  // loads compression dictionary, the compressed text header,
  // and all level informaiton
  bool LoadData (char *basepath, char *textname);
  bool UnloadData ();
};


// note: document numbers start at 1

// get information about where a document starts and finishes
bool GetDocIdx (TextData &td, const UCArray &docLevel,
		unsigned long docNum, TextIdx &docIdx);


// decompress a document's text
bool GetDocText (TextData &td, const UCArray &docLevel,
		 unsigned long docNum, UCArray &docText);

#endif
