/**************************************************************************
 *
 * FIvfLevelInfo.h -- File functions for document levels
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: FIvfLevelInfo.h,v 1.1 2000/01/14 02:17:36 sjboddie Exp $
 *
 **************************************************************************/

#ifndef FIVFLEVELINFO_H
#define FIVFLEVELINFO_H

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\map>
#elif defined(GSDL_USE_STL_H)
#  include <map.h>
#else
#  include <map>
#endif

#include <stdio.h>
#include "UCArray.h"


class IvfLevelInfo {
public:
  UCArray levelTag;
  unsigned long numEntries; // N for level
  unsigned long approxWeightsDiskPtr;
  unsigned long exactWeightsDiskPtr;
  bool workInLevel;  // this is just a working variable,
                     // it is not saved or read from the file
  
  IvfLevelInfo ();
  void Clear ();

  bool Read (FILE *f);
  bool Write (FILE *f) const;
};

// stream output for debugging purposes
ostream &operator<<(ostream &s, const IvfLevelInfo &l);


typedef map<UCArray, IvfLevelInfo, LTUCArray> IvfLevelInfoMap;


class FIvfLevel {
public:
  UCArray docTag;
  UCArray indexLevel;    // empty for word level index
  IvfLevelInfoMap levelInfo;
  
  FIvfLevel ();
  void Clear ();

  bool Read (FILE *f);
  bool Write (FILE *f) const;
};

// stream output for debugging purposes
ostream &operator<<(ostream &s, const FIvfLevel &l);


#endif
