/**************************************************************************
 *
 * bitio_m_stdio.h -- Macros for bitio to a file
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: bitio_m_stdio.h,v 1.1 2000/01/14 02:17:03 sjboddie Exp $
 *
 **************************************************************************
 *
 *  This file contains macros for doing bitwise input and output on a FILE*.
 *  With these routines you cannot mix reads and writes on the FILE,
 *  or multiple writes, at the same time and guarantee them to work, also you 
 *  cannot seek to a point and do a write. The decode routine can detect when
 *  you run off the end of the file and will produce an approate error message.
 *
 *
 **************************************************************************/

#ifndef H_BITIO_M_STDIO
#define H_BITIO_M_STDIO

#include "bitio_m_abstract.h"


class stdio_bitio_buffer : public bitio_buffer {
protected:
  FILE *file;
  unsigned char buffer;
  unsigned char btg;
  unsigned long bytesWritten;
  
public:
  stdio_bitio_buffer (FILE *f = NULL);

  void attachFile (FILE *f);

  unsigned char GetBtg () { return btg; }
  unsigned long GetBytesWritten () { return bytesWritten; }
  
  void seek (unsigned long byte, unsigned char bit);
  void seek (unsigned long topos);
  void error();
  long add00(long b);
  long addff(long b);
  int  bit();
  int  bitOffset() { return btg; }
  void done();

  void encodeStart();
  void encodeBit(int bit);
  void encodeDone();
};


/*#define ENCODE_START(f)							\
  {									\
    stdio_bitio_buffer buffer(f);                                       \
    buffer.encodeStart();

#define ENCODE_CONTINUE(b)						\
  {									\
    stdio_bitio_buffer buffer;                                          \
    buffer.unpause(b);

#define ENCODE_PAUSE(b) buffer.pause(&b);}

#define ENCODE_DONE buffer.encodeDone();}

#define DECODE_START(f)							\
  {		                                                        \
    stdio_bitio_buffer buffer(f);

#define DECODE_CONTINUE(b)						\
  {									\
    stdio_bitio_buffer buffer;                                          \
     buffer.unpause(b);

#define DECODE_ADD_FF(b) b = buffer.addff(b)

#define DECODE_ADD_00(b) b = buffer.add00(b)

#define DECODE_BIT buffer.bit()

#define DECODE_DONE buffer.done();}

#define DECODE_PAUSE(b) buffer.pause(&b);}
*/

#endif
