/**********************************************************************
 *
 * source.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "source.h"
#include <assert.h>


// default constructor does nothing
sourceclass::sourceclass () {
}

// default destructor does nothing
sourceclass::~sourceclass () {
}

// configure should be called once for each configuration line
// default does nothing
void sourceclass::configure (const text_t &/*key*/, const text_tarray &/*cfgline*/) {
}

// init should be called after all the configuration is done but
// before any other methods are called
// default does nothing
bool sourceclass::init (ostream &/*logout*/) {
  return true;
}


// translate_OID translates OIDs using ".pr", ."fc" etc.
bool sourceclass::translate_OID (const text_t &/*OIDin*/, text_t &/*OIDout*/, 
				 comerror_t &err, ostream &/*logout*/) {
  err = noError;

  return false;
}


// get_metadata fills out the metadata if possible, if it is not responsable
// for the given OID then it will return false.
bool sourceclass::get_metadata (const text_t &/*requestParams*/, const text_t &/*refParams*/, 
				bool /*getParents*/, const text_tset &/*fields*/, 
				const text_t &/*OID*/, MetadataInfo_tmap &metadata, 
				comerror_t &err, ostream &/*logout*/) {
  metadata.erase(metadata.begin(), metadata.end());
  err = noError;

  return false;
}

bool sourceclass::get_document (const text_t &/*OID*/, text_t &/*doc*/, 
				comerror_t &err, ostream &/*logout*/) {
  err = noError;

  return false;
}


bool operator==(const sourceptr &x, const sourceptr &y) {
  return (x.s == y.s);
}

bool operator<(const sourceptr &x, const sourceptr &y) {
  return (x.s < y.s);
}


// thesource remains the property of the calling code but
// should not be deleted until it is removed from this list.
void sourcelistclass::addsource (sourceclass *thesource) {
  // can't add a source that doesn't exist
  assert (thesource != NULL);
  if (thesource == NULL) return;

  sourceptr sp;
  sp.s = thesource;

  sourceptrs.push_back(sp);
}
