/**********************************************************************
 *
 * colservrconfig.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: colservrconfig.cpp,v 1.4 2001/01/25 18:26:44 cs025 Exp $
 *
 *********************************************************************/

/*
   $Log: colservrconfig.cpp,v $
   Revision 1.4  2001/01/25 18:26:44  cs025
   Included CORBA branch for first time

   Revision 1.2.2.1  2000/04/04 15:02:31  cs025
   Corba first commit

   Revision 1.2  1999/09/07 04:57:20  sjboddie
   added gpl notice

   Revision 1.1  1999/02/21 22:32:55  rjmcnab

   Initial revision.

 */


#include "colservrconfig.h"
#include "fileutil.h"
#include "cfgread.h"


#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace/std/iostream>
#  include <ospace/std/fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#  include <fstream.h>
#else
#  include <iostream>
#  include <fstream>
#endif

// collect_cfg_read reads collect.cfg returning true on success.
bool collect_cfg_read (collectserver &cserver, const text_t &gsdlhome,
		       const text_t &collection) {
  text_t filename = filename_cat (gsdlhome, "collect");
  filename = filename_cat (filename, collection);
  filename = filename_cat (filename, "etc");
  filename = filename_cat (filename, "collect.cfg");
  if (!file_exists (filename)) {
    filename = filename_cat (gsdlhome, "etc");
    filename = filename_cat (filename, "collect.cfg");
    if (!file_exists (filename)) return false;
  }

  return cserver.read_configfile(filename);
  /*
  // read in the collection configuration file
  text_t key;
  text_tarray cfgline;
  char *cstr = filename.getcstr();
  ifstream confin (cstr);
  delete cstr;

  if (confin) {
    while (read_cfg_line(confin, cfgline) >= 0) {
      if (cfgline.size () >= 2) {
	key = cfgline[0];
	cfgline.erase(cfgline.begin());

	// configure the collection server
	cserver.configure (key, cfgline);
      }
    }
    confin.close ();
    return true;
  }
  return false;
  */
}


// build_cfg_read reads build.cfg and returns true on success.
bool build_cfg_read (collectserver &cserver, const text_t &gsdlhome,
		     const text_t &collection) {
  text_t filename = filename_cat (gsdlhome, "collect");
  filename = filename_cat (filename, collection);
  filename = filename_cat (filename, "index");

  filename = filename_cat (filename, "build.cfg");
  if (!file_exists (filename)) {
    filename = filename_cat (gsdlhome, "index");
    filename = filename_cat (filename, "build.cfg");
    if (!file_exists (filename)) return false;
  }

  return cserver.read_configfile(filename);

  /*
  // read in the build configuration file
  text_t key;
  text_tarray cfgline;
  char *cstr = filename.getcstr();
  ifstream confin (cstr);
  delete cstr;

  if (confin) {
    while (read_cfg_line(confin, cfgline) >= 0) {
      if (cfgline.size () >= 2) {
	key = cfgline[0];
	cfgline.erase(cfgline.begin());

	// configure the collection server
	cserver.configure (key, cfgline);
      }
    }
    confin.close ();
    return true;
  }
  return false;
  */
}
