/*
 * Copyright (c) 1995-2000, Index Data
 * See the file LICENSE for details.
 * Sebastian Hammer, Adam Dickmeiss
 *
 * $Log: ber_null.c,v $
 * Revision 1.1  2000/08/03 03:11:15  johnmcp
 * Added the YAZ toolkit source to the packages directory (for z39.50 stuff)
 *
 * Revision 1.11  2000/02/29 13:44:55  adam
 * Check for config.h (currently not generated).
 *
 * Revision 1.10  2000/01/31 13:15:21  adam
 * Removed uses of assert(3). Cleanup of ODR. CCL parser update so
 * that some characters are not surrounded by spaces in resulting term.
 * ILL-code updates.
 *
 * Revision 1.9  1999/11/30 13:47:11  adam
 * Improved installation. Moved header files to include/yaz.
 *
 * Revision 1.8  1995/09/29 17:12:18  quinn
 * Smallish
 *
 * Revision 1.7  1995/09/27  15:02:55  quinn
 * Modified function heads & prototypes.
 *
 * Revision 1.6  1995/05/22  11:32:01  quinn
 * Fixing Interface to odr_null.
 *
 * Revision 1.5  1995/05/16  08:50:46  quinn
 * License, documentation, and memory fixes
 *
 * Revision 1.4  1995/04/18  08:15:16  quinn
 * Added dynamic memory allocation on encoding (whew). Code is now somewhat
 * neater. We'll make the same change for decoding one day.
 *
 * Revision 1.3  1995/03/08  12:12:09  quinn
 * Added better error checking.
 *
 * Revision 1.2  1995/02/09  15:51:46  quinn
 * Works better now.
 *
 * Revision 1.1  1995/02/02  16:21:52  quinn
 * First kick.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <yaz/odr.h>

/*
 * BER-en/decoder for NULL type.
 */
int ber_null(ODR o)
{
    switch (o->direction)
    {
    	case ODR_ENCODE:
	    if (odr_putc(o, 0X00) < 0)
	    	return 0;
#ifdef ODR_DEBUG
	    fprintf(stderr, "[NULL]\n");
#endif
	    return 1;
	case ODR_DECODE:
	    if (*(o->bp++) != 0X00)
	    {
	    	o->error = OPROTO;
	    	return 0;
	    }
#ifdef ODR_DEBUG
	    fprintf(stderr, "[NULL]\n");
#endif
	    return 1;
	case ODR_PRINT: return 1;
	default: o->error = OOTHER; return 0;
    }
}
