/*
 * Copyright (c) 1995-1999, Index Data.
 * See the file LICENSE for details.
 * Sebastian Hammer, Adam Dickmeiss
 *
 * $Log: prt-exp.c,v $
 * Revision 1.1  2000/08/03 03:09:51  johnmcp
 * Added the YAZ toolkit source to the packages directory (for z39.50 stuff)
 *
 * Revision 1.13  1999/11/30 13:47:11  adam
 * Improved installation. Moved header files to include/yaz.
 *
 * Revision 1.12  1999/04/20 09:56:48  adam
 * Added 'name' paramter to encoder/decoder routines (typedef Odr_fun).
 * Modified all encoders/decoders to reflect this change.
 *
 * Revision 1.11  1999/03/18 12:57:13  adam
 * Fixed bug in TargetInfo encoder/decoder.
 *
 * Revision 1.10  1998/05/18 13:06:52  adam
 * Changed the way attribute sets are handled by the retriaval module.
 * Extended Explain conversion / schema.
 * Modified server and client to work with ASN.1 compiled protocol handlers.
 *
 * Revision 1.9  1998/02/11 11:53:32  adam
 * Changed code so that it compiles as C++.
 *
 * Revision 1.8  1996/01/02 11:46:41  quinn
 * Changed 'operator' to 'roperator' to avoid C++ conflict.
 *
 * Revision 1.7  1995/12/14  16:28:07  quinn
 * More explain stuff.
 *
 * Revision 1.6  1995/12/14  11:09:09  quinn
 * Fixed bug in tagging.
 *
 * Revision 1.5  1995/12/05  11:15:50  quinn
 * Work.
 *
 * Revision 1.4  1995/09/29  17:11:54  quinn
 * Smallish
 *
 * Revision 1.3  1995/09/27  15:02:42  quinn
 * Modified function heads & prototypes.
 *
 * Revision 1.2  1995/08/15  11:59:43  quinn
 * Updated External
 *
 * Revision 1.1  1995/08/10  08:54:02  quinn
 * Added Explain
 *
 *
 */

#include <yaz/proto.h>

int z_LanguageCode(ODR o, char **p, int opt, const char *name);
int z_CommonInfo(ODR o, Z_CommonInfo **p, int opt, const char *name);
int z_HumanStringUnit(ODR o, Z_HumanStringUnit **p, int opt, const char *name);
int z_HumanString(ODR o, Z_HumanString **p, int opt, const char *name);
int z_IconObjectUnit(ODR o, Z_IconObjectUnit **p, int opt, const char *name);
int z_IconObject(ODR o, Z_IconObject **p, int opt, const char *name);
int z_ContactInfo(ODR o, Z_ContactInfo **p, int opt, const char *name);
int z_NetworkAddressIA(ODR o, Z_NetworkAddressIA **p, int opt,
		       const char *name);
int z_NetworkAddressOPA(ODR o, Z_NetworkAddressOPA **p, int opt,
			const char *name);
int z_NetworkAddressOther(ODR o, Z_NetworkAddressOther **p, int opt,
			  const char *name);
int z_NetworkAddress(ODR o, Z_NetworkAddress **p, int opt, const char *name);
int z_AccessInfo(ODR o, Z_AccessInfo **p, int opt, const char *name);
int z_QueryTypeDetails(ODR o, Z_QueryTypeDetails **p, int opt,
		       const char *name);
int z_PrivateCapOperator(ODR o, Z_PrivateCapOperator **p, int opt,
			 const char *name);
int z_PrivateCapabilities(ODR o, Z_PrivateCapabilities **p, int opt,
			  const char *name);
int z_RpnCapabilities(ODR o, Z_RpnCapabilities **p, int opt, const char *name);
int z_Iso8777Capabilities(ODR o, Z_Iso8777Capabilities **p, int opt,
			  const char *name);
int z_ProxSupportPrivate(ODR o, Z_ProxSupportPrivate **p, int opt,
			 const char *name);
int z_ProxSupportUnit(ODR o, Z_ProxSupportUnit **p, int opt, const char *name);
int z_ProximitySupport(ODR o, Z_ProximitySupport **p, int opt,
		       const char *name);
int z_SearchKey(ODR o, Z_SearchKey **p, int opt, const char *name);
int z_AccessRestrictionsUnit(ODR o, Z_AccessRestrictionsUnit **p, int opt,
			     const char *name);
int z_AccessRestrictions(ODR o, Z_AccessRestrictions **p, int opt,
			 const char *name);
int z_CostsOtherCharge(ODR o, Z_CostsOtherCharge **p, int opt,
		       const char *name);
int z_Costs(ODR o, Z_Costs **p, int opt, const char *name);
int z_Charge(ODR o, Z_Charge **p, int opt, const char *name);
int z_DatabaseList(ODR o, Z_DatabaseList **p, int opt, const char *name);
int z_AttributeCombinations(ODR o, Z_AttributeCombinations **p, int opt,
			    const char *name);
int z_AttributeCombination(ODR o, Z_AttributeCombination **p, int opt,
			   const char *name);
int z_AttributeValueList(ODR o, Z_AttributeValueList **p, int opt,
			 const char *name);
int z_AttributeOccurrence(ODR o, Z_AttributeOccurrence **p, int opt,
			  const char *name);
int z_AttributeValue(ODR o, Z_AttributeValue **p, int opt, const char *name);
int z_TargetInfo(ODR o, Z_TargetInfo **p, int opt, const char *name);
int z_DatabaseInfo(ODR o, Z_DatabaseInfo **p, int opt, const char *name);
int z_TagTypeMapping(ODR o, Z_TagTypeMapping **p, int opt, const char *name);
int z_SchemaInfo(ODR o, Z_SchemaInfo **p, int opt, const char *name);
int z_ElementInfo(ODR o, Z_ElementInfo **p, int opt, const char *name);
int z_PathUnit(ODR o, Z_PathUnit **p, int opt, const char *name);
int z_Path(ODR o, Z_Path **p, int opt, const char *name);
int z_ElementInfoList(ODR o, Z_Path **p, int opt, const char *name);
int z_ElementDataType(ODR o, Z_ElementDataType **p, int opt, const char *name);
int z_TagSetInfoElements(ODR o, Z_TagSetInfoElements **p, int opt,
			 const char *name);
int z_TagSetInfo(ODR o, Z_TagSetInfo **p, int opt, const char *name);
int z_RecordSyntaxInfo(ODR o, Z_RecordSyntaxInfo **p, int opt,
		       const char *name);
int z_AttributeSetInfo(ODR o, Z_AttributeSetInfo **p, int opt,
		       const char *name);
int z_AttributeType(ODR o, Z_AttributeType **p, int opt, const char *name);
int z_AttributeDescription(ODR o, Z_AttributeDescription **p, int opt,
			   const char *name);
int z_TermListElement(ODR o, Z_TermListElement **p, int opt, const char *name);
int z_TermListInfo(ODR o, Z_TermListInfo **p, int opt, const char *name);
int z_ExtendedServicesInfo(ODR o, Z_ExtendedServicesInfo **p, int opt,
			   const char *name);
int z_AttributeDetails(ODR o, Z_AttributeDetails **p, int opt,
		       const char *name);
int z_AttributeSetDetails(ODR o, Z_AttributeSetDetails **p, int opt,
			  const char *name);
int z_AttributeTypeDetails(ODR o, Z_AttributeTypeDetails **p, int opt,
			   const char *name);
int z_OmittedAttributeInterpretation(ODR o,
				     Z_OmittedAttributeInterpretation **p,
				     int opt, const char *name);
int z_EScanInfo(ODR o, Z_EScanInfo **p, int opt, const char *name);
int z_TermListDetails(ODR o, Z_TermListDetails **p, int opt, const char *name);
int z_ElementSetDetails(ODR o, Z_ElementSetDetails **p, int opt,
			const char *name);
int z_RetrievalRecordDetails(ODR o, Z_RetrievalRecordDetails **p, int opt,
			     const char *name);
int z_PerElementDetails(ODR o, Z_PerElementDetails **p, int opt,
			const char *name);
int z_RecordTag(ODR o, Z_RecordTag **p, int opt, const char *name);
int z_SortDetails(ODR o, Z_SortDetails **p, int opt, const char *name);
int z_SortKeyDetails(ODR o, Z_SortKeyDetails **p, int opt, const char *name);
int z_ProcessingInformation(ODR o, Z_ProcessingInformation **p, int opt,
			    const char *name);
int z_VariantSetInfo(ODR o, Z_VariantSetInfo **p, int opt, const char *name);
int z_VariantClass(ODR o, Z_VariantClass **p, int opt, const char *name);
int z_VariantType(ODR o, Z_VariantType **p, int opt, const char *name);
int z_VariantValue(ODR o, Z_VariantValue **p, int opt, const char *name);
int z_ValueSetEnumerated(ODR o, Z_ValueSetEnumerated **p, int opt,
			 const char *name);
int z_ValueSet(ODR o, Z_ValueSet **p, int opt, const char *name);
int z_ValueRange(ODR o, Z_ValueRange **p, int opt, const char *name);
int z_ValueDescription(ODR o, Z_ValueDescription **p, int opt,
		       const char *name);
int z_UnitInfo(ODR o, Z_UnitInfo **p, int opt, const char *name);
int z_UnitType(ODR o, Z_UnitType **p, int opt, const char *name);
int z_Units(ODR o, Z_Units **p, int opt, const char *name);
int z_CategoryList(ODR o, Z_CategoryList **p, int opt, const char *name);
int z_CategoryInfo(ODR o, Z_CategoryInfo **p, int opt, const char *name);
int z_ExplainRecord(ODR o, Z_ExplainRecord **p, int opt, const char *name);

int z_LanguageCode(ODR o, char **p, int opt, const char *name)
{
    return z_InternationalString(o, p, opt, 0);
}

int z_CommonInfo(ODR o, Z_CommonInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, odr_generalizedtime, &(*p)->dateAdded,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_generalizedtime, &(*p)->dateChanged,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, odr_generalizedtime, &(*p)->expiry,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_LanguageCode, &(*p)->humanStringLanguage,
		     ODR_CONTEXT, 3, 1) &&
        z_OtherInformation(o, &(*p)->otherInfo, 1, 0) &&
        odr_sequence_end(o);
}

int z_HumanStringUnit(ODR o, Z_HumanStringUnit **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_LanguageCode, &(*p)->language, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->text, ODR_CONTEXT,
		     1, 0) &&
        odr_sequence_end(o);
}

int z_HumanString(ODR o, Z_HumanString **p, int opt, const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, (Odr_fun)z_HumanStringUnit, &(*p)->strings,
			&(*p)->num_strings, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_IconObjectUnit(ODR o, Z_IconObjectUnit **p, int opt, const char *name)
{
    static Odr_arm arm[] = 
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_IconObjectUnit_ianaType,
	 z_InternationalString, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_IconObjectUnit_z3950type,
	 z_InternationalString, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 3, Z_IconObjectUnit_otherType,
	 z_InternationalString, 0},
	{-1, -1, -1, -1, 0, 0}
    };

    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
    	odr_constructed_begin(o, &(*p)->bodyType, ODR_CONTEXT, 1, 0) &&
	odr_choice(o, arm, &(*p)->bodyType, &(*p)->which, 0) &&
	odr_constructed_end(o) &&
        odr_implicit(o, odr_octetstring, &(*p)->content, ODR_CONTEXT, 2, 0) &&
        odr_sequence_end(o);
}

int z_IconObject(ODR o, Z_IconObject **p, int opt, const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, (Odr_fun)z_IconObjectUnit, &(*p)->elements,
    	&(*p)->num, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_ContactInfo(ODR o, Z_ContactInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->address,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->email,
		     ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->phone,
		     ODR_CONTEXT, 4, 1) &&
	odr_sequence_end(o);
}

int z_NetworkAddressIA(ODR o, Z_NetworkAddressIA **p, int opt,
		       const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt;
    return
        odr_implicit(o, z_InternationalString, &(*p)->hostAddress,
		     ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, odr_integer, &(*p)->port, ODR_CONTEXT, 1, 0) &&
	odr_sequence_end(o);
}

int z_NetworkAddressOPA(ODR o, Z_NetworkAddressOPA **p, int opt,
			const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt;
    return
        odr_implicit(o, z_InternationalString, &(*p)->pSel,
		     ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->sSel,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->tSel,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->nSap,
		     ODR_CONTEXT, 3, 0) &&
	odr_sequence_end(o);
}

int z_NetworkAddressOther(ODR o, Z_NetworkAddressOther **p, int opt,
			  const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt;
    return
        odr_implicit(o, z_InternationalString, &(*p)->type,
		     ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->address,
		     ODR_CONTEXT, 1, 0) &&
	odr_sequence_end(o);
}

int z_NetworkAddress(ODR o, Z_NetworkAddress **p, int opt, const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_NetworkAddress_iA,
	 (Odr_fun)z_NetworkAddressIA, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_NetworkAddress_oPA,
	 (Odr_fun)z_NetworkAddressOPA, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_NetworkAddress_other,
	    (Odr_fun)z_NetworkAddressOther, 0},
	{-1, -1, -1, -1, 0, 0}
    };

    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
    	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_AccessInfo(ODR o, Z_AccessInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
	odr_implicit_settag(o, ODR_CONTEXT, 0) &&
	(odr_sequence_of(o, (Odr_fun)z_QueryTypeDetails,
			 &(*p)->queryTypesSupported,
			 &(*p)->num_queryTypesSupported, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 1) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->diagnosticsSets,
			 &(*p)->num_diagnosticsSets, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->attributeSetIds,
			 &(*p)->num_attributeSetIds, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->schemas,
			 &(*p)->num_schemas, 0) ||
	 odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 4) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->recordSyntaxes,
			 &(*p)->num_recordSyntaxes, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 5) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->resourceChallenges,
			 &(*p)->num_resourceChallenges, 0) || odr_ok(o)) &&
        odr_implicit(o, z_AccessRestrictions, &(*p)->restrictedAccess,
		     ODR_CONTEXT, 6, 1) &&
        odr_implicit(o, z_Costs, &(*p)->costInfo, ODR_CONTEXT, 8, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 9) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->variantSets,
			 &(*p)->num_variantSets, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 10) &&
	(odr_sequence_of(o, (Odr_fun)z_ElementSetName, &(*p)->elementSetNames,
			 &(*p)->num_elementSetNames, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 11) &&
	(odr_sequence_of(o, (Odr_fun)z_InternationalString, &(*p)->unitSystems,
			 &(*p)->num_unitSystems, 0) || odr_ok(o)) &&
	odr_sequence_end(o);
}

int z_QueryTypeDetails(ODR o, Z_QueryTypeDetails **p, int opt,
		       const char *name)
{
    static Odr_arm arm[] =
    {
	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_QueryTypeDetails_private,
	 (Odr_fun)z_PrivateCapabilities, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_QueryTypeDetails_rpn,
	 (Odr_fun)z_RpnCapabilities, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_QueryTypeDetails_iso8777,
	 (Odr_fun)z_Iso8777Capabilities, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 3, Z_QueryTypeDetails_z39_58,
	 (Odr_fun)z_HumanString, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 4, Z_QueryTypeDetails_erpn,
	 (Odr_fun)z_RpnCapabilities, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 5, Z_QueryTypeDetails_rankedList,
	 (Odr_fun)z_HumanString, 0},
	{-1, -1, -1, -1, 0, 0}
    };

    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_PrivateCapOperator(ODR o, Z_PrivateCapOperator **p, int opt,
			 const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->roperator,
		     ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
	odr_sequence_end(o);
}

int z_PrivateCapabilities(ODR o, Z_PrivateCapabilities **p, int opt,
			  const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt && odr_ok(o);
    return
    	odr_implicit_settag(o, ODR_CONTEXT, 0) &&
	(odr_sequence_of(o, (Odr_fun)z_PrivateCapOperator, &(*p)->operators,
			 &(*p)->num_operators, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 1) &&
	(odr_sequence_of(o, (Odr_fun)z_SearchKey, &(*p)->searchKeys,
			 &(*p)->num_searchKeys, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_HumanString, &(*p)->description,
			 &(*p)->num_description, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_RpnCapabilities(ODR o, Z_RpnCapabilities **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
	odr_implicit_settag(o, ODR_CONTEXT, 0) &&
	(odr_sequence_of(o, (Odr_fun)odr_integer, &(*p)->operators,
			 &(*p)->num_operators, 0) || odr_ok(o)) &&
        odr_implicit(o, odr_bool, &(*p)->resultSetAsOperandSupported,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, odr_bool, &(*p)->restrictionOperandSupported,
		     ODR_CONTEXT, 2, 0) &&
        odr_implicit(o, z_ProximitySupport, &(*p)->proximity, ODR_CONTEXT,
		     3, 1) &&
        odr_sequence_end(o);
}

int z_Iso8777Capabilities(ODR o, Z_Iso8777Capabilities **p, int opt,
			  const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
	odr_implicit_settag(o, ODR_CONTEXT, 0) &&
	odr_sequence_of(o, (Odr_fun)z_SearchKey, &(*p)->searchKeys,
			&(*p)->num_searchKeys, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->restrictions, ODR_CONTEXT,
		     1, 1) &&
        odr_sequence_end(o);
}

int z_ProxSupportPrivate(ODR o, Z_ProxSupportPrivate **p, int opt,
			 const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt && odr_ok(o);
    return
    	odr_implicit(o, odr_integer, &(*p)->unit, ODR_CONTEXT, 0, 0) &&
	odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
	odr_sequence_end(o);
}

int z_ProxSupportUnit(ODR o, Z_ProxSupportUnit **p, int opt, const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_ProxSupportUnit_known,
	 (Odr_fun)odr_integer, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_ProxSupportUnit_private,
	 (Odr_fun)z_ProxSupportPrivate, 0},
	{-1, -1, -1, -1, 0, 0}
    };
    
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
    	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_ProximitySupport(ODR o, Z_ProximitySupport **p, int opt,
		       const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
    	odr_implicit(o, odr_bool, &(*p)->anySupport, ODR_CONTEXT, 0, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 1) &&
	(odr_sequence_of(o, (Odr_fun)z_ProxSupportUnit, &(*p)->unitsSupported,
			 &(*p)->num_unitsSupported, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_SearchKey(ODR o, Z_SearchKey **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->searchKey,
		     ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_sequence_end(o);
}

int z_AccessRestrictionsUnit(ODR o, Z_AccessRestrictionsUnit **p, int opt,
			     const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_explicit(o, odr_integer, &(*p)->accessType, ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->accessText, ODR_CONTEXT, 1, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->accessChallenges,
			 &(*p)->num_accessChallenges, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_AccessRestrictions(ODR o, Z_AccessRestrictions **p, int opt,
			 const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, (Odr_fun)z_AccessRestrictionsUnit, &(*p)->elements,
			&(*p)->num, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_CostsOtherCharge(ODR o, Z_CostsOtherCharge **p, int opt,
		       const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt && odr_ok(o);
    return
        odr_implicit(o, z_HumanString, &(*p)->forWhat, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_Charge, &(*p)->charge, ODR_CONTEXT, 2, 1) &&
        odr_sequence_end(o);
}

int z_Costs(ODR o, Z_Costs **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_Charge, &(*p)->connectCharge, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_Charge, &(*p)->connectTime, ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, z_Charge, &(*p)->displayCharge, ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_Charge, &(*p)->searchCharge, ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, z_Charge, &(*p)->subscriptCharge, ODR_CONTEXT, 4, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 5) &&
	(odr_sequence_of(o, (Odr_fun)z_CostsOtherCharge, &(*p)->otherCharges,
			 &(*p)->num_otherCharges, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_Charge(ODR o, Z_Charge **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_IntUnit, &(*p)->cost, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_Unit, &(*p)->perWhat, ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->text, ODR_CONTEXT, 3, 1) &&
        odr_sequence_end(o);
}

int z_DatabaseList(ODR o, Z_DatabaseList **p, int opt, const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, z_DatabaseName, &(*p)->databases,
	&(*p)->num_databases, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_AttributeCombinations(ODR o, Z_AttributeCombinations **p, int opt,
			    const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, odr_oid, &(*p)->defaultAttributeSet,
		     ODR_CONTEXT, 0, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 1) &&
	odr_sequence_of(o, (Odr_fun)z_AttributeCombination,
			&(*p)->legalCombinations,
			&(*p)->num_legalCombinations, 0) &&
        odr_sequence_end(o);
}

int z_AttributeCombination(ODR o, Z_AttributeCombination **p, int opt,
			   const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, (Odr_fun)z_AttributeOccurrence, &(*p)->occurrences,
			&(*p)->num_occurrences, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_AttributeValueList(ODR o, Z_AttributeValueList **p, int opt,
			 const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, (Odr_fun)z_StringOrNumeric, &(*p)->attributes,
			&(*p)->num_attributes, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_AttributeOccurrence(ODR o, Z_AttributeOccurrence **p, int opt,
			  const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 3, Z_AttributeOcc_any_or_none,
	 (Odr_fun)odr_null, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 4, Z_AttributeOcc_specific,
	 (Odr_fun)z_AttributeValueList, 0},
	{-1, -1, -1, -1, 0, 0}
    };
    
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, odr_oid, &(*p)->attributeSet, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_integer, &(*p)->attributeType,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, odr_null, &(*p)->mustBeSupplied, ODR_CONTEXT, 2, 1) &&
	odr_choice(o, arm, &(*p)->attributeValues, &(*p)->which, 0) &&
        odr_sequence_end(o);
}

int z_AttributeValue(ODR o, Z_AttributeValue **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_explicit(o, z_StringOrNumeric, &(*p)->value, ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_StringOrNumeric, &(*p)->subAttributes,
			 &(*p)->num_subAttributes, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, (Odr_fun)z_StringOrNumeric, &(*p)->superAttributes,
			 &(*p)->num_superAttributes, 0) || odr_ok(o)) &&
        odr_implicit(o, odr_null, &(*p)->partialSupport, ODR_CONTEXT, 4, 1) &&
	odr_sequence_end(o);
}



int z_TargetInfo(ODR o, Z_TargetInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo,
		     ODR_CONTEXT, 0, 1) &&
	odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->recentNews,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_IconObject, &(*p)->icon,
		     ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, odr_bool, &(*p)->namedResultSets,
		     ODR_CONTEXT, 4, 0) &&
        odr_implicit(o, odr_bool, &(*p)->multipleDBsearch,
		     ODR_CONTEXT, 5, 0) &&
        odr_implicit(o, odr_integer, &(*p)->maxResultSets,
		     ODR_CONTEXT, 6, 1) &&
        odr_implicit(o, odr_integer, &(*p)->maxResultSize,
		     ODR_CONTEXT, 7, 1) &&
        odr_implicit(o, odr_integer, &(*p)->maxTerms,
		     ODR_CONTEXT, 8, 1) &&
        odr_implicit(o, z_IntUnit, &(*p)->timeoutInterval,
		     ODR_CONTEXT, 9, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->welcomeMessage,
		     ODR_CONTEXT, 10, 1) &&
        odr_implicit(o, z_ContactInfo, &(*p)->contactInfo,
		     ODR_CONTEXT, 11, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 12, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 13) &&
	(odr_sequence_of(o, z_InternationalString, &(*p)->nicknames,
			 &(*p)->num_nicknames, 0) || odr_ok(o)) &&
        odr_implicit(o, z_HumanString, &(*p)->usageRest,
		     ODR_CONTEXT, 14, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->paymentAddr,
		     ODR_CONTEXT, 15, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->hours, ODR_CONTEXT, 16, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 17) &&
	(odr_sequence_of(o, (Odr_fun)z_DatabaseList, &(*p)->dbCombinations,
			 &(*p)->num_dbCombinations, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 18) &&
	(odr_sequence_of(o, (Odr_fun)z_NetworkAddress, &(*p)->addresses,
			 &(*p)->num_addresses, 0) || odr_ok(o)) &&
        odr_implicit_settag (o, ODR_CONTEXT, 101) &&
        (odr_sequence_of(o, (Odr_fun) z_InternationalString, &(*p)->languages,
			 &(*p)->num_languages, 0) || odr_ok(o)) &&
        odr_implicit(o, z_AccessInfo, &(*p)->commonAccessInfo,
		     ODR_CONTEXT, 19, 1) &&
        odr_sequence_end(o);
}

int z_DatabaseInfo(ODR o, Z_DatabaseInfo **p, int opt, const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_DatabaseInfo_actualNumber,
	 (Odr_fun)odr_integer, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_DatabaseInfo_approxNumber,
	 (Odr_fun)odr_integer, 0},
	{-1, -1, -1, -1, 0, 0}
    };

    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->name, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, odr_null, &(*p)->explainDatabase, ODR_CONTEXT, 2, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, z_DatabaseName, &(*p)->nicknames,
	    &(*p)->num_nicknames, 0) || odr_ok(o)) &&
        odr_implicit(o, z_IconObject, &(*p)->icon, ODR_CONTEXT, 4, 1) &&
        odr_implicit(o, odr_bool, &(*p)->userFee, ODR_CONTEXT, 5, 0) &&
        odr_implicit(o, odr_bool, &(*p)->available, ODR_CONTEXT, 6, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->titleString,
		     ODR_CONTEXT, 7, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 8) &&
	(odr_sequence_of(o, (Odr_fun)z_HumanString, &(*p)->keywords,
			 &(*p)->num_keywords, 0) || odr_ok(o)) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 9, 1) &&
        odr_implicit(o, z_DatabaseList, &(*p)->associatedDbs,
		     ODR_CONTEXT, 10, 1) &&
        odr_implicit(o, z_DatabaseList, &(*p)->subDbs, ODR_CONTEXT, 11, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->disclaimers,
		     ODR_CONTEXT, 12, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->news, ODR_CONTEXT, 13, 1) &&
	((odr_constructed_begin(o, &(*p)->u.actualNumber,
				ODR_CONTEXT, 14, 0) &&
	  odr_choice(o, arm, &(*p)->u.actualNumber, &(*p)->which, 0) &&
	  odr_constructed_end(o)) || odr_ok(o)) &&
        odr_implicit(o, z_HumanString, &(*p)->defaultOrder,
		     ODR_CONTEXT, 15, 1) &&
        odr_implicit(o, odr_integer, &(*p)->avRecordSize,
		     ODR_CONTEXT, 16, 1) &&
        odr_implicit(o, odr_integer, &(*p)->maxRecordSize,
		     ODR_CONTEXT, 17, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->hours, ODR_CONTEXT, 18, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->bestTime, ODR_CONTEXT, 19, 1) &&
        odr_implicit(o, odr_generalizedtime, &(*p)->lastUpdate,
		     ODR_CONTEXT, 20, 1) &&
        odr_implicit(o, z_IntUnit, &(*p)->updateInterval,
		     ODR_CONTEXT, 21, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->coverage, ODR_CONTEXT, 22, 1) &&
        odr_implicit(o, odr_bool, &(*p)->proprietary, ODR_CONTEXT, 23, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->copyrightText,
		     ODR_CONTEXT, 24, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->copyrightNotice,
		     ODR_CONTEXT, 25, 1) &&
        odr_implicit(o, z_ContactInfo, &(*p)->producerContactInfo,
		     ODR_CONTEXT, 26, 1) &&
        odr_implicit(o, z_ContactInfo, &(*p)->supplierContactInfo,
		     ODR_CONTEXT, 27, 1) &&
        odr_implicit(o, z_ContactInfo, &(*p)->submissionContactInfo,
		     ODR_CONTEXT, 28, 1) &&
        odr_implicit(o, z_AccessInfo, &(*p)->accessInfo, ODR_CONTEXT, 29, 1) &&
        odr_sequence_end(o);
}

int z_TagTypeMapping(ODR o, Z_TagTypeMapping **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt;
    return
    	odr_implicit(o, odr_integer, &(*p)->tagType, ODR_CONTEXT, 0, 0) &&
	odr_implicit(o, odr_oid, &(*p)->tagSet, ODR_CONTEXT, 1, 1) &&
	odr_implicit(o, odr_null, &(*p)->defaultTagType, ODR_CONTEXT, 2, 1) &&
	odr_sequence_end(o);
}

int z_SchemaInfo(ODR o, Z_SchemaInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_oid, &(*p)->schema, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name, ODR_CONTEXT,
	    2, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 3, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 4) &&
	(odr_sequence_of(o, (Odr_fun)z_TagTypeMapping, &(*p)->tagTypeMapping,
			 &(*p)->num_tagTypeMapping, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 5) &&
	(odr_sequence_of(o, (Odr_fun)z_ElementInfo, &(*p)->recordStructure,
			 &(*p)->num_recordStructure, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_ElementInfo(ODR o, Z_ElementInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->elementName,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_Path, &(*p)->elementTagPath, ODR_CONTEXT, 2, 0) &&
        odr_explicit(o, z_ElementDataType, &(*p)->dataType,
		     ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, odr_bool, &(*p)->required, ODR_CONTEXT, 4, 0) &&
        odr_implicit(o, odr_bool, &(*p)->repeatable, ODR_CONTEXT, 5, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 6, 1) &&
        odr_sequence_end(o);
}

int z_PathUnit(ODR o, Z_PathUnit **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt;
    return
    	odr_implicit(o, odr_integer, &(*p)->tagType, ODR_CONTEXT, 1, 0) &&
	odr_explicit(o, z_StringOrNumeric, &(*p)->tagValue,
		     ODR_CONTEXT, 2, 0) &&
	odr_sequence_end(o);
}

int z_Path(ODR o, Z_Path **p, int opt, const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    odr_implicit_settag(o, ODR_CONTEXT, 201);
    if (odr_sequence_of(o, (Odr_fun)z_OtherInformationUnit, &(*p)->list,
			&(*p)->num, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_ElementInfoList(ODR o, Z_Path **p, int opt, const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    odr_implicit_settag(o, ODR_CONTEXT, 201);
    if (odr_sequence_of(o, (Odr_fun)z_OtherInformationUnit, &(*p)->list,
			&(*p)->num, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_ElementDataType(ODR o, Z_ElementDataType **p, int opt, const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_ElementDataType_primitive,
	 (Odr_fun)odr_integer, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_ElementDataType_structured,
	 (Odr_fun)z_ElementInfoList, 0},
	{-1, -1, -1, -1, 0, 0}
    };
    
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
    	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_TagSetInfoElements(ODR o, Z_TagSetInfoElements **p, int opt,
			 const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt;
    return
    	odr_implicit(o, z_InternationalString, &(*p)->elementname,
		     ODR_CONTEXT, 1, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, z_InternationalString, &(*p)->nicknames,
			 &(*p)->num_nicknames, 0) || odr_ok(o)) &&
	odr_explicit(o, z_StringOrNumeric, &(*p)->elementTag,
		     ODR_CONTEXT, 3, 0) &&
	odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 4, 1) &&
	odr_implicit(o, odr_integer, &(*p)->dataType, ODR_CONTEXT, 5, 1) &&
	z_OtherInformation(o, &(*p)->otherTagInfo, 1, 0) &&
   	odr_sequence_end(o);
}

int z_TagSetInfo(ODR o, Z_TagSetInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_oid, &(*p)->tagSet, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 2, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 3, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 4) &&
	(odr_sequence_of(o, (Odr_fun)z_TagSetInfoElements, &(*p)->elements,
			 &(*p)->num_elements, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_RecordSyntaxInfo(ODR o, Z_RecordSyntaxInfo **p, int opt,
		       const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_oid, &(*p)->recordSyntax, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, (Odr_fun)odr_oid, &(*p)->transferSyntaxes,
			 &(*p)->num_transferSyntaxes, 0) || odr_ok(o)) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 4, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->asn1Module,
		     ODR_CONTEXT, 5, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 6) &&
	(odr_sequence_of(o, (Odr_fun)z_ElementInfo, &(*p)->abstractStructure,
	    &(*p)->num_abstractStructure, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_AttributeSetInfo(ODR o, Z_AttributeSetInfo **p, int opt,
		       const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_oid, &(*p)->attributeSet, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, (Odr_fun)z_AttributeType, &(*p)->attributes,
			 &(*p)->num_attributes, 0) || odr_ok(o)) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 4, 1) &&
        odr_sequence_end(o);
}

int z_AttributeType(ODR o, Z_AttributeType **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, odr_integer, &(*p)->attributeType,
		     ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	odr_sequence_of(o, (Odr_fun)z_AttributeDescription,
			&(*p)->attributeValues,
			&(*p)->num_attributeValues, 0) &&
        odr_sequence_end(o);
}

int z_AttributeDescription(ODR o, Z_AttributeDescription **p, int opt,
			   const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_explicit(o, z_StringOrNumeric, &(*p)->attributeValue,
		     ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, (Odr_fun)z_StringOrNumeric,
			 &(*p)->equivalentAttributes,
			 &(*p)->num_equivalentAttributes, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_TermListElement(ODR o, Z_TermListElement **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
    	return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->title, ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, odr_integer, &(*p)->searchCost, ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, odr_bool, &(*p)->scanable, ODR_CONTEXT, 4, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 5) &&
	(odr_sequence_of(o, z_InternationalString, &(*p)->broader,
			 &(*p)->num_broader, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 6) &&
	(odr_sequence_of(o, z_InternationalString, &(*p)->narrower,
			 &(*p)->num_narrower, 0) || odr_ok(o)) &&
	odr_sequence_end(o);
}

int z_TermListInfo(ODR o, Z_TermListInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->databaseName,
		     ODR_CONTEXT, 1, 0) &&
 	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_TermListElement, &(*p)->termLists,
			 &(*p)->num_termLists, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_ExtendedServicesInfo(ODR o, Z_ExtendedServicesInfo **p, int opt,
			   const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_oid, &(*p)->type, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, odr_bool, &(*p)->privateType, ODR_CONTEXT, 3, 0) &&
        odr_implicit(o, odr_bool, &(*p)->restrictionsApply,
		     ODR_CONTEXT, 5, 0) &&
        odr_implicit(o, odr_bool, &(*p)->feeApply, ODR_CONTEXT, 6, 0) &&
        odr_implicit(o, odr_bool, &(*p)->available, ODR_CONTEXT, 7, 0) &&
        odr_implicit(o, odr_bool, &(*p)->retentionSupported,
		     ODR_CONTEXT, 8, 0) &&
        odr_implicit(o, odr_integer, &(*p)->waitAction, ODR_CONTEXT, 9, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 10, 1) &&
        odr_implicit(o, z_External, &(*p)->specificExplain,
		     ODR_CONTEXT, 11, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->esASN,
		     ODR_CONTEXT, 12, 1) &&
        odr_sequence_end(o);
}

int z_AttributeDetails(ODR o, Z_AttributeDetails **p, int opt,
		       const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->databaseName,
		     ODR_CONTEXT, 1, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_AttributeSetDetails,
			 &(*p)->attributesBySet,
			 &(*p)->num_attributesBySet, 0) && odr_ok(o)) &&
        odr_implicit(o, z_AttributeCombinations, &(*p)->attributeCombinations,
		     ODR_CONTEXT, 3, 1) &&
        odr_sequence_end(o);
}

int z_AttributeSetDetails(ODR o, Z_AttributeSetDetails **p, int opt,
			  const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, odr_oid, &(*p)->attributeSet,
		     ODR_CONTEXT, 0, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 1) &&
	odr_sequence_of(o, (Odr_fun)z_AttributeTypeDetails,
			&(*p)->attributesByType,
			&(*p)->num_attributesByType, 0) &&
        odr_sequence_end(o);
}

int z_AttributeTypeDetails(ODR o, Z_AttributeTypeDetails **p, int opt,
			   const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, odr_integer, &(*p)->attributeType,
		     ODR_CONTEXT, 0, 0) &&
        odr_implicit(o, z_OmittedAttributeInterpretation,
		     &(*p)->defaultIfOmitted,
		     ODR_CONTEXT, 1, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_AttributeValue, &(*p)->attributeValues,
			 &(*p)->num_attributeValues, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_OmittedAttributeInterpretation(ODR o,
				     Z_OmittedAttributeInterpretation **p,
				     int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_explicit(o, z_StringOrNumeric, &(*p)->defaultValue,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->defaultDescription,
		     ODR_CONTEXT, 1, 1) &&
        odr_sequence_end(o);
}

int z_EScanInfo(ODR o, Z_EScanInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, odr_integer, &(*p)->maxStepSize, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->collatingSequence,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, odr_bool, &(*p)->increasing, ODR_CONTEXT, 2, 1) &&
	odr_sequence_end(o);
}

int z_TermListDetails(ODR o, Z_TermListDetails **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->termListName,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_AttributeCombinations, &(*p)->attributes,
		     ODR_CONTEXT, 3, 1) &&
	odr_implicit(o, z_EScanInfo, &(*p)->scanInfo, ODR_CONTEXT, 4, 1) &&
        odr_implicit(o, odr_integer, &(*p)->estNumberTerms,
		     ODR_CONTEXT, 5, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 6) &&
	(odr_sequence_of(o, (Odr_fun)z_Term, &(*p)->sampleTerms,
	    &(*p)->num_sampleTerms, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_ElementSetDetails(ODR o, Z_ElementSetDetails **p, int opt,
			const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->databaseName,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_ElementSetName, &(*p)->elementSetName,
		     ODR_CONTEXT, 2, 0) &&
        odr_implicit(o, odr_oid, &(*p)->recordSyntax, ODR_CONTEXT, 3, 0) &&
        odr_implicit(o, odr_oid, &(*p)->schema, ODR_CONTEXT, 4, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 5, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 6) &&
	(odr_sequence_of(o, (Odr_fun)z_PerElementDetails,
			 &(*p)->detailsPerElement,
			 &(*p)->num_detailsPerElement, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_RetrievalRecordDetails(ODR o, Z_RetrievalRecordDetails **p, int opt,
			     const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->databaseName,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, odr_oid, &(*p)->schema, ODR_CONTEXT, 2, 0) &&
        odr_implicit(o, odr_oid, &(*p)->recordSyntax, ODR_CONTEXT, 3, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 4, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 5) &&
	(odr_sequence_of(o, (Odr_fun)z_PerElementDetails,
			 &(*p)->detailsPerElement,
			 &(*p)->num_detailsPerElement, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_PerElementDetails(ODR o, Z_PerElementDetails **p, int opt,
			const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_RecordTag, &(*p)->recordTag, ODR_CONTEXT, 1, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_Path, &(*p)->schemaTags,
			 &(*p)->num_schemaTags, 0) ||
	 odr_ok(o)) &&
        odr_implicit(o, odr_integer, &(*p)->maxSize, ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, odr_integer, &(*p)->minSize, ODR_CONTEXT, 4, 1) &&
        odr_implicit(o, odr_integer, &(*p)->avgSize, ODR_CONTEXT, 5, 1) &&
        odr_implicit(o, odr_integer, &(*p)->fixedSize, ODR_CONTEXT, 6, 1) &&
        odr_implicit(o, odr_bool, &(*p)->repeatable, ODR_CONTEXT, 8, 0) &&
        odr_implicit(o, odr_bool, &(*p)->required, ODR_CONTEXT, 9, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 12, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->contents, ODR_CONTEXT, 13, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->billingInfo,
		     ODR_CONTEXT, 14, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->restrictions,
		     ODR_CONTEXT, 15, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 16) &&
	(odr_sequence_of(o, z_InternationalString, &(*p)->alternateNames,
			 &(*p)->num_alternateNames, 0) || odr_ok(o)) &&
	odr_implicit_settag(o, ODR_CONTEXT, 17) &&
	(odr_sequence_of(o, z_InternationalString, &(*p)->genericNames,
			 &(*p)->num_genericNames, 0) || odr_ok(o)) &&
        odr_implicit(o, z_AttributeCombinations, &(*p)->searchAccess,
		     ODR_CONTEXT, 18, 1) &&
        odr_sequence_end(o);
}

int z_RecordTag(ODR o, Z_RecordTag **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_explicit(o, z_StringOrNumeric, &(*p)->qualifier,
		     ODR_CONTEXT, 0, 1) &&
        odr_explicit(o, z_StringOrNumeric, &(*p)->tagValue,
		     ODR_CONTEXT, 1, 0) &&
        odr_sequence_end(o);
}

int z_SortDetails(ODR o, Z_SortDetails **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->databaseName,
		     ODR_CONTEXT, 1, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 2) &&
	(odr_sequence_of(o, (Odr_fun)z_SortKeyDetails, &(*p)->sortKeys,
			 &(*p)->num_sortKeys, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_SortKeyDetails (ODR o, Z_SortKeyDetails **p, int opt, const char *name)
{
    static Odr_arm arm[] = {
	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_SortKeyDetails_character,
	 (Odr_fun) odr_null, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_SortKeyDetails_numeric,
	 (Odr_fun) odr_null, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_SortKeyDetails_structured,
	 (Odr_fun) z_HumanString, 0},
	{-1, -1, -1, -1, (Odr_fun) 0, 0}
    };
    if (!odr_sequence_begin (o, p, sizeof(**p), 0))
	return opt && odr_ok (o);
    return
	odr_implicit (o, z_HumanString,
		      &(*p)->description, ODR_CONTEXT, 0, 1) &&
	odr_implicit_settag (o, ODR_CONTEXT, 1) &&
	(odr_sequence_of(o, (Odr_fun) z_Specification,
			 &(*p)->elementSpecifications,
			 &(*p)->num_elementSpecifications, 0) || odr_ok(o)) &&
	odr_implicit (o, z_AttributeCombinations,
		      &(*p)->attributeSpecifications, ODR_CONTEXT, 2, 1) &&
	((odr_constructed_begin (o, &(*p)->u, ODR_CONTEXT, 3, 0) &&
	  odr_choice (o, arm, &(*p)->u, &(*p)->which, 0) &&
	  odr_constructed_end (o)) || odr_ok(o)) &&
	odr_implicit (o, odr_integer,
		      &(*p)->caseSensitivity, ODR_CONTEXT, 4, 1) &&
	odr_sequence_end (o);
}

int z_ProcessingInformation(ODR o, Z_ProcessingInformation **p, int opt,
			    const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_DatabaseName, &(*p)->databaseName,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, odr_integer, &(*p)->processingContext,
		     ODR_CONTEXT, 2, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 3, 0) &&
        odr_implicit(o, odr_oid, &(*p)->oid, ODR_CONTEXT, 4, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 5, 1) &&
        odr_implicit(o, z_External, &(*p)->instructions, ODR_CONTEXT, 6, 1) &&
        odr_sequence_end(o);
}

int z_VariantSetInfo(ODR o, Z_VariantSetInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, odr_oid, &(*p)->variantSet, ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o, (Odr_fun)z_VariantClass, &(*p)->variants,
			 &(*p)->num_variants, 0) || odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_VariantClass(ODR o, Z_VariantClass **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, odr_integer, &(*p)->variantClass, ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	odr_sequence_of(o, (Odr_fun)z_VariantType, &(*p)->variantTypes,
			&(*p)->num_variantTypes, 0) &&
        odr_sequence_end(o);
}

int z_VariantType(ODR o, Z_VariantType **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_implicit(o, odr_integer, &(*p)->variantType,
		     ODR_CONTEXT, 2, 0) &&
        odr_implicit(o, z_VariantValue, &(*p)->variantValue,
		     ODR_CONTEXT, 3, 1) &&
        odr_sequence_end(o);
}

int z_VariantValue(ODR o, Z_VariantValue **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_explicit(o, odr_integer, &(*p)->dataType, ODR_CONTEXT, 0, 0) &&
        odr_explicit(o, z_ValueSet, &(*p)->values, ODR_CONTEXT, 1, 1) &&
	odr_sequence_end(o);
}

int z_ValueSetEnumerated(ODR o, Z_ValueSetEnumerated **p, int opt,
			 const char *name)
{
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_sequence_of(o, (Odr_fun)z_ValueDescription, &(*p)->elements,
			&(*p)->num, 0))
	return 1;
    *p = 0;
    return opt && odr_ok(o);
}
    
int z_ValueSet(ODR o, Z_ValueSet **p, int opt, const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_ValueSet_range,
	 (Odr_fun)z_ValueRange, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_ValueSet_enumerated,
	 (Odr_fun)z_ValueSetEnumerated, 0},
	{-1, -1, -1, -1, 0, 0}
    };
    
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
    	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_ValueRange(ODR o, Z_ValueRange **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_explicit(o, z_ValueDescription, &(*p)->lower, ODR_CONTEXT, 0, 1) &&
        odr_explicit(o, z_ValueDescription, &(*p)->upper, ODR_CONTEXT, 1, 1) &&
	odr_sequence_end(o);
}

int z_ValueDescription(ODR o, Z_ValueDescription **p, int opt,
		       const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_NONE, -1, -1, Z_ValueDescription_integer,
	 (Odr_fun)odr_integer, 0},
	{ODR_NONE, -1, -1, Z_ValueDescription_string,
	 (Odr_fun)z_InternationalString, 0},
	{ODR_NONE, -1, -1, Z_ValueDescription_octets,
	 (Odr_fun)odr_octetstring, 0},
	{ODR_NONE, -1, -1, Z_ValueDescription_oid,
	 (Odr_fun)odr_oid, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_ValueDescription_unit,
	 (Odr_fun)z_Unit, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_ValueDescription_valueAndUnit,
	 (Odr_fun)z_IntUnit, 0},
	{-1, -1, -1, -1, 0, 0}
    };
    
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
    	return 1;
    *p = 0;
    return opt && odr_ok(o);
}

int z_UnitInfo(ODR o, Z_UnitInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->unitSystem,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 2, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	(odr_sequence_of(o,  (Odr_fun)z_UnitType, &(*p)->units, 
			 &(*p)->num_units, 0) ||
	 odr_ok(o)) &&
        odr_sequence_end(o);
}

int z_UnitType(ODR o, Z_UnitType **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_explicit(o, z_StringOrNumeric, &(*p)->unitType,
		     ODR_CONTEXT, 2, 0) &&
	odr_implicit_settag(o, ODR_CONTEXT, 3) &&
	odr_sequence_of(o, (Odr_fun)z_Units, &(*p)->units,
			&(*p)->num_units, 0) &&
        odr_sequence_end(o);
}

int z_Units(ODR o, Z_Units **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->name,
		     ODR_CONTEXT, 0, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 1, 1) &&
        odr_explicit(o, z_StringOrNumeric, &(*p)->unit,
		     ODR_CONTEXT, 2, 0) &&
        odr_sequence_end(o);
}

int z_CategoryList(ODR o, Z_CategoryList **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_CommonInfo, &(*p)->commonInfo, ODR_CONTEXT, 0, 1) &&
	odr_implicit_settag(o, ODR_CONTEXT, 1) &&
	odr_sequence_of(o, (Odr_fun)z_CategoryInfo, &(*p)->categories,
			&(*p)->num_categories, 0) &&
        odr_sequence_end(o);
}

int z_CategoryInfo(ODR o, Z_CategoryInfo **p, int opt, const char *name)
{
    if (!odr_sequence_begin(o, p, sizeof(**p), 0))
        return opt && odr_ok(o);
    return
        odr_implicit(o, z_InternationalString, &(*p)->category,
		     ODR_CONTEXT, 1, 0) &&
        odr_implicit(o, z_InternationalString, &(*p)->originalCategory,
		     ODR_CONTEXT, 2, 1) &&
        odr_implicit(o, z_HumanString, &(*p)->description,
		     ODR_CONTEXT, 3, 1) &&
        odr_implicit(o, z_InternationalString, &(*p)->asn1Module,
		     ODR_CONTEXT, 4, 1) &&
        odr_sequence_end(o);
}

int z_ExplainRecord(ODR o, Z_ExplainRecord **p, int opt, const char *name)
{
    static Odr_arm arm[] =
    {
    	{ODR_IMPLICIT, ODR_CONTEXT, 0, Z_Explain_targetInfo,
	 (Odr_fun)z_TargetInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 1, Z_Explain_databaseInfo,
	 (Odr_fun)z_DatabaseInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 2, Z_Explain_schemaInfo,
	 (Odr_fun)z_SchemaInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 3, Z_Explain_tagSetInfo,
	 (Odr_fun)z_TagSetInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 4, Z_Explain_recordSyntaxInfo,
	 (Odr_fun)z_RecordSyntaxInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 5, Z_Explain_attributeSetInfo,
	 (Odr_fun)z_AttributeSetInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 6, Z_Explain_termListInfo,
	 (Odr_fun)z_TermListInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 7, Z_Explain_extendedServicesInfo,
	 (Odr_fun)z_ExtendedServicesInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 8, Z_Explain_attributeDetails,
	 (Odr_fun)z_AttributeDetails, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 9, Z_Explain_termListDetails,
	 (Odr_fun)z_TermListDetails, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 10, Z_Explain_elementSetDetails,
	 (Odr_fun)z_ElementSetDetails, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 11, Z_Explain_retrievalRecordDetails,
	 (Odr_fun)z_RetrievalRecordDetails, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 12, Z_Explain_sortDetails,
	 (Odr_fun)z_SortDetails, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 13, Z_Explain_processing,
	 (Odr_fun)z_ProcessingInformation, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 14, Z_Explain_variants,
	 (Odr_fun)z_VariantSetInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 15, Z_Explain_units,
	 (Odr_fun)z_UnitInfo, 0},
	{ODR_IMPLICIT, ODR_CONTEXT, 100, Z_Explain_categoryList,
	 (Odr_fun)z_CategoryList, 0},
	{-1, -1, -1, -1, 0, 0}
    };
    
    if (!odr_initmember(o, p, sizeof(**p)))
	return opt && odr_ok(o);
    if (odr_choice(o, arm, &(*p)->u, &(*p)->which, 0))
    	return 1;
    *p = 0;
    return opt && odr_ok(o);
}
