######################################################################
#
# German Language text and icon macros (translated from english.dm
# 9 March 2000)
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.
#
# Under the 'text macros' comments are text macros of the form:
# _macroname_ {macro value}
# Everything between the {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Under the 'icons' comments are macros concerned with displaying
# icons which themselves contain text.
# Above each macro (or group of macros) for an icon is a comment line
# that looks something like '## "HOME" ## top_nav_button ## chome ##'.
# The first field of the comment ("HOME" in this case) is the text
# that appears in the english version of the icon. This is the text
# that must be translated, nothing needs to be done to the macros 
# themselves. The other two fields of the comments are used by 
# automatic icon generating software which reads the newly translated
# file and generates appropriate icons.
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################


######################################################################
# Global (base) package
package Global
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultcontent_ [l=de] {Die angegebene Seite konnte nicht gefunden
werden. Bitte benutzen sie den "Zur&uuml;ck" Knopf ihres Browsers oder
den obigen "Home" Knopf um zur Hauptseite der elektronischen
Bibliothek zur&uuml;ckzukehren.}

_textdefaulttitle_ [l=de] {GSDL Fehler}

_collectionextra_ [l=de] {Diese Sammlung enth&auml;lt _about:numdocs_
Dokumente.  Sie wurde vor _about:builddate_ Tagen erstellt.}

_textimagecollection_ [l=de] {}
_textimageabout_ [l=de] {Info}
_textimagehome_ [l=de] {Hauptseite}
_textimagehelp_ [l=de] {Hilfe}
_textimagepref_ [l=de] {Voreinstellungen}
_textimagegreenstone_ [l=de] {Greenstone Digital Library Software}

_textimagesearch_ [l=de] {Suche nach einem bestimmten Begriff}
_textimageTitle_ [l=de] {Alphabetische Liste der Titel}
_textimageList_ [l=de] {Liste der Dokumente}
_textimageCreator_ [l=de] {Alphabetische Liste der Autoren}
_textimageSeries_ [l=de] {Sortiert nach Ausgaben}
_textimageDate_ [l=de] {Sortiert nach Datum}
_textimageSubject_ [l=de] {Sortiert nach Sparte}
_textimageOrganization_ [l=de] {Sortiert nach Organisation}
_textimageHowto_ [l=de] {&quot;Wie geht das?&quot;-Kategorien}
_textimageTopic_ [l=de] {St&ouml;bern in Ausgaben zu speziellen Themen}
_textimageBrowse_ [l=de] {St&ouml;bern}
_textimagePeople_ [l=de] {Alphabetische Liste der Personen}

_texticontabsearchgreen_ [l=de] {Suche}
_texticontabdategreen_ [l=de] {Daten}
_texticontabseriesgreen_ [l=de] {Serien}
_texticontabauthorgreen_ [l=de] {Autoren A-Z}
_texticontabtitlegreen_ [l=de] {Titel A-Z}
_texticontablistgreen_ [l=de] {Auflistung}
_texticontabsubjectgreen_ [l=de] {Sparten}
_texticontaborggreen_ [l=de] {Organisation}
_texticontabhowgreen_ [l=de] {Wie geht das?}
_texticontabtopicgreen_ [l=de] {Themen}
_texticontabbrwsegreen_ [l=de] {St&ouml;bern}
_texticontabPeoplegreen_ [l=de] {Personen A-Z}

_texticontext_ [l=de] {Sichten des Dokuments}
_texticonclosedbook_ [l=de] {&Ouml;ffnen dieses Dokuments und Sichten des Inhalts}
_texticonnext_ [l=de] {zur n&auml;chsten Sektion}
_texticonprev_ [l=de] {zur vorhergehenden Sektion}

_page_ [l=de] {Seite }
_pages_ [l=de] {Seiten}
_of_ [l=de] { of }
_vol_ [l=de] {Volume}
_num_ [l=de] {Number}

_textmonth00_ [l=de] {}
_textmonth01_ [l=de] {Januar}
_textmonth02_ [l=de] {Februar}
_textmonth03_ [l=de] {M&auml;rz}
_textmonth04_ [l=de] {April}
_textmonth05_ [l=de] {Mai}
_textmonth06_ [l=de] {Juni}
_textmonth07_ [l=de] {Juli}
_textmonth08_ [l=de] {August}
_textmonth09_ [l=de] {September}
_textmonth10_ [l=de] {Oktober}
_textmonth11_ [l=de] {November}
_textmonth12_ [l=de] {Dezember}

_magazines_ [l=de] {Magazine}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "HAUPTSEITE" ## top_nav_button ## chome ##
_httpiconchomeof_ [l=de] {_httpimg_/de/chomeof.gif}
_httpiconchomeon_ [l=de] {_httpimg_/de/chomeon.gif}
_widthchomex_ [l=de] {75}
_heightchomex_ [l=de] {20}

## "HILFE" ## top_nav_button ## chelp ##
_httpiconchelpof_ [l=de] {_httpimg_/de/chelpof.gif}
_httpiconchelpon_ [l=de] {_httpimg_/de/chelpon.gif}
_widthchelpx_ [l=de] {36}
_heightchelpx_ [l=de] {20}

## "VOREINSTELLUNGEN" ## top_nav_button ## cpref ##
_httpiconcprefof_ [l=de] {_httpimg_/de/cprefof.gif}
_httpiconcprefon_ [l=de] {_httpimg_/de/cprefon.gif}
_widthcprefx_ [l=de] {124}
_heightcprefx_ [l=de] {20}

## "hilfe" ## green_title ## h_help ##
_httpiconhhelp_ [l=de] {_httpimg_/de/h\_help.gif}
_widthhhelp_ [l=de] {200}
_heighthhelp_ [l=de] {57}

## "autoren a-z" ## nav_bar_button ## tauth ##
_httpicontauthgr_ [l=de] {_httpimg_/de/tauthgr.gif}
_httpicontauthof_ [l=de] {_httpimg_/de/tauthof.gif}
_httpicontauthon_ [l=de] {_httpimg_/de/tauthon.gif}
_widthtauthx_ [l=de] {102}
_heighttauthx_ [l=de] {17}

## "serien" ## nav_bar_button ## tser ##
_httpicontsergr_ [l=de] {_httpimg_/de/tsergr.gif}
_httpicontserof_ [l=de] {_httpimg_/de/tserof.gif}
_httpicontseron_ [l=de] {_httpimg_/de/tseron.gif}
_widthtserx_ [l=de] {87}
_heighttserx_ [l=de] {17}

## "daten" ## nav_bar_button ## tdate ##
_httpicontdategr_ [l=de] {_httpimg_/de/tdategr.gif}
_httpicontdateof_ [l=de] {_httpimg_/de/tdateof.gif}
_httpicontdateon_ [l=de] {_httpimg_/de/tdateon.gif}
_widthtdatex_ [l=de] {87}
_heighttdatex_ [l=de] {17}

## "sparten" ## nav_bar_button ## tsubj ##
_httpicontsubjgr_ [l=de] {_httpimg_/de/tsubjgr.gif}
_httpicontsubjon_ [l=de] {_httpimg_/de/tsubjon.gif}
_httpicontsubjof_ [l=de] {_httpimg_/de/tsubjof.gif}
_widthtsubjx_ [l=de] {87}
_heighttsubjx_ [l=de] {17}

## "organisation" ## nav_bar_button ## torg ##
_httpicontorggr_ [l=de] {_httpimg_/de/torggr.gif}
_httpicontorgon_ [l=de] {_httpimg_/de/torgon.gif}
_httpicontorgof_ [l=de] {_httpimg_/de/torgof.gif}
_widthtorgx_ [l=de] {105}
_heighttorgx_ [l=de] {17}

## "wie geht das?" ## nav_bar_button ## thow ##
_httpiconthowgr_ [l=de] {_httpimg_/de/thowgr.gif}
_httpiconthowon_ [l=de] {_httpimg_/de/thowon.gif}
_httpiconthowof_ [l=de] {_httpimg_/de/thowof.gif}
_widththowx_ [l=de] {115}
_heightthowx_ [l=de] {17}

## "thema" ## nav_bar_button ## ttopic ##
_httpiconttopicgr_ [l=de] {_httpimg_/de/ttopicgr.gif}
_httpiconttopicon_ [l=de] {_httpimg_/de/ttopicon.gif}
_httpiconttopicof_ [l=de] {_httpimg_/de/ttopicof.gif}
_widthttopicx_ [l=de] {87}
_heightttopicx_ [l=de] {17}

## "st&ouml;bern" ## nav_bar_button ## tbrwse ##
_httpicontbrwsegr_ [l=de] {_httpimg_/de/tbrwsegr.gif}
_httpicontbrwseon_ [l=de] {_httpimg_/de/tbrwseon.gif}
_httpicontbrwseof_ [l=de] {_httpimg_/de/tbrwseof.gif}
_widthtbrwsex_ [l=de] {87}
_heighttbrwsex_ [l=de] {17}

## "suche" ## nav_bar_button ## tsrch ##
_httpicontsrchgr_ [l=de] {_httpimg_/de/tsrchgr.gif}
_httpicontsrchof_ [l=de] {_httpimg_/de/tsrchof.gif}
_httpicontsrchon_ [l=de] {_httpimg_/de/tsrchon.gif}
_widthtsrchx_ [l=de] {87}
_heighttsrchx_ [l=de] {17}

## "titel a-z" ## nav_bar_button ## ttitl ##
_httpiconttitlgr_ [l=de] {_httpimg_/de/ttitlgr.gif}
_httpiconttitlof_ [l=de] {_httpimg_/de/ttitlof.gif}
_httpiconttitlon_ [l=de] {_httpimg_/de/ttitlon.gif}
_widthttitlx_ [l=de] {87}
_heightttitlx_ [l=de] {17}

## "personen" ## nav_bar_button ## tpeop ##
_httpicontpeopgr_ [l=de] {_httpimg_/de/tpeopgr.gif}
_httpicontpeopof_ [l=de] {_httpimg_/de/tpeopof.gif}
_httpicontpeopon_ [l=de] {_httpimg_/de/tpeopon.gif}
_widthtpeopx_ [l=de] {87}
_heighttpeopx_ [l=de] {17}



######################################################################
# 'about' page
package about
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textabcol_ [l=de] {&Uuml;ber diese Sammlung}

_textsubcols1_ [l=de] {<p>Die komplette Sammlung umfa&szlig;t _1_ individuelle
Kollektionen:
<blockquote>}

_textsubcols2_ [l=de] {</blockquote>
Auf der Seite mit den Einstellugen k&ouml;nnen sie pr&uuml;fen (und
 &auml;Yndern) welche individuellen Kollektionen sie momentan benutzen.}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "info" ## green_title ## h_about ##
_httpiconhabout_ [l=de] {_httpimg_/de/h\_about.gif}
_widthhabout_ [l=de] {200}
_heighthabout_ [l=de] {57}



######################################################################
# document package
package document
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textTitlepage_ [l=de] {_texticonhtitle_}
_textCreatorpage_ [l=de] {_texticonhauth_}
_textSubjectpage_ [l=de] {_texticonhsubj_}
_textSeriespage_ [l=de] {_texticonhser_}
_textDatepage_ [l=de] {_texticonhdate_}
_textHowtopage_ [l=de] {_texticonhhow_}
_textOrganizationpage_ [l=de] {_texticonhorg_}
_textBrowsepage_ [l=de] {_texticonhbrwse_}
_textPeoplepage_ [l=de] {_texticonhpeople_}

_texticonhtitle_ [l=de] {Titel A-Z}
_texticonhauth_ [l=de] {Autoren A-Z}
_texticonhsubj_ [l=de] {Sparten}
_texticonhser_ [l=de] {Serien}
_texticonhdate_ [l=de] {Daten}
_texticonhhow_ [l=de] {Wie geht das?}
_texticonhorg_ [l=de] {Organisationen}
_texticonhbrwse_ [l=de] {St&ouml;bern}
_texticonhpeople_ [l=de] {Personen A-Z}

_texticonopenbookshelf_ [l=de] {Schliessen dieser Sektion der Bibliothek}
_texticonclosedbookshelf_ [l=de] {&Ouml;ffnen dieser Sektion der Bibliothek und Sichten des Inhalts}
_texticonopenbook_ [l=de] {Schliessen dieses Buches}
_texticonclosedfolder_ [l=de] {&Ouml;ffnen dieses Ordners und Sichten des Inhalts}
_texticonclosedfolder2_ [l=de] {&Ouml;ffnen der individuellen Kollektion: }
_texticonopenfolder_ [l=de] {Schliessen dieses Ordners}
_texticonopenfolder2_ [l=de] {Schliessen der individuellen Kollektion: }
_texticonsmalltext_ [l=de] {Sichten des Textabschnittes}
_texticonsmalltext2_ [l=de] {Sichten des Texts: }
_texticonpointer_ [l=de] {Augenblickliche Sektion}
_texticondetach_ [l=de] {&Ouml;ffnen dieser Seite in einem neuen Fenster}
_texticonhighlight_ [l=de] {Suchbegriffe werden hervorgehoben}
_texticonnohighlight_ [l=de] {Suchbegriffe werden nicht hervorgehoben}
_texticoncontracttoc_ [l=de] {Verkleinerte Version des Inhaltsverzeichnisses}
_texticonexpandtoc_ [l=de] {Expandierte Version des Inhaltsverzeichnisses}
_texticonexpandtext_ [l=de] {Anzeigen des gesamten Texts}
_texticoncontracttext_ [l=de] {Anzeigen des Textes nur f&uuml;r die augenblicklich ausgew&auml;hlte Sektion}
_texticonwarning_ [l=de] {<b>Warnung: </b>}
_texticoncont_ [l=de] {Weitermachen?}

_textltwarning_ [l=de] {
<p><center>
<table cellspacing=0 cellpadding=0 width=_pagewidth_>
<tr valign=top><td>_iconwarning_Wenn der Text hier expandiert wird, wird eine sehr grosse Menge an Daten dargestellt werden m&uuml;ssen _imagecont_
</td></tr></table></center>
}

_textgoto_ [l=de] {Gehe zur Seite}
_textintro_ [l=de] { <i>(Einf&uuml;hrender Text)</i>}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "titel a-z" ## green_title ## h_title ##
_httpiconhtitle_ [l=de] {_httpimg_/de/h\_title.gif}
_widthhtitle_ [l=de] {200}
_heighthtitle_ [l=de] {57}

## "autoren a-z" ## green_title ## h_auth ##
_httpiconhauth_ [l=de] {_httpimg_/de/h\_auth.gif}
_widthhauth_ [l=de] {200}

## "sparten" ## green_title ## h_subj ##
_httpiconhsubj_ [l=de] {_httpimg_/de/h\_subj.gif}
_widthhsubj_ [l=de] {200}
_heighthsubj_ [l=de] {57}

## "serien" ## green_title ## h_ser ##
_httpiconhser_ [l=de] {_httpimg_/de/h\_ser.gif}
_widthhser_ [l=de] {200}
_heighthser_ [l=de] {57}

## "daten" ## green_title ## h_date ##
_httpiconhdate_ [l=de] {_httpimg_/de/h\_date.gif}
_widthhdate_ [l=de] {200}
_heighthdate_ [l=de] {57}

## "wie geht das?" ## green_title ## h_how ##
_httpiconhhow_ [l=de] {_httpimg_/de/h\_how.gif}
_widthhhow_ [l=de] {200}
_heighthhow_ [l=de] {57}

## "themen" ## green_title ## h_topic ##
_httpiconhtopic_ [l=de] {_httpimg_/de/h\_topic.gif}
_widthhtopic_ [l=de] {200}
_heighthtopic_ [l=de] {57}

## "organisation" ## green_title ## h_org ##
_httpiconhorg_ [l=de] {_httpimg_/de/h\_org.gif}
_widthhorg_ [l=de] {250}
_heighthorg_ [l=de] {57}

## "st&ouml;bern" ## green_title ## h_brwse ##
_httpiconhbrwse_ [l=de] {_httpimg_/de/h\_brwse.gif}
_widthhbrwse_ [l=de] {200}
_heighthbrwse_ [l=de] {57}

## "personen" ## green_title ## h_people ##
_httpiconhpeople_ [l=de] {_httpimg_/de/h\_people.gif}
_widthhpeople_ [l=de] {200}
_heighthpeople_ [l=de] {57}

## "WEITERMACHEN?" ## top_nav_button ## cont ##
_httpiconcontoff_ [l=de] {_httpimg_/de/contoff.gif}
_httpiconconton_ [l=de] {_httpimg_/de/conton.gif}
_widthcontx_ [l=de] {104}
_heightcontx_ [l=de] {17}

## "EXPANDIEREN
#  DES TEXTS" ## document_button ## eallt ## 
_httpiconealltof_ [l=de] {_httpimg_/de/ealltof.gif}
_httpiconeallton_ [l=de] {_httpimg_/de/eallton.gif}
_widthealltx_ [l=de] {65}
_heightealltx_ [l=de] {30}

## "KONTRAKTIONDES
#        INHALTS" ## document_button ## econc ##
_httpiconeconcof_ [l=de] {_httpimg_/de/econcof.gif}
_httpiconeconcon_ [l=de] {_httpimg_/de/econcon.gif}
_widtheconcx_ [l=de] {92}
_heighteconcx_ [l=de] {30}

## "SEPARATES
#  FENSTER" ## document_button ## edtch ##
_httpiconedtchof_ [l=de] {_httpimg_/de/edtchof.gif}
_httpiconedtchon_ [l=de] {_httpimg_/de/edtchon.gif}
_widthedtchx_ [l=de] {65}
_heightedtchx_ [l=de] {30}

## "EXPANDIEREN
#DES INHALTS" ## document_button ## eexpc ##
_httpiconeexpcof_ [l=de] {_httpimg_/de/eexpcof.gif}
_httpiconeexpcon_ [l=de] {_httpimg_/de/eexpcon.gif}
_widtheexpcx_ [l=de] {65}
_heighteexpcx_ [l=de] {30}

## "KONTRAKTION
#   DES TEXTS" ## document_button ## etsec ##
_httpiconetsecof_ [l=de] {_httpimg_/de/etsecof.gif}
_httpiconetsecon_ [l=de] {_httpimg_/de/etsecon.gif}
_widthetsecx_ [l=de] {74}
_heightetsecx_ [l=de] {30}

## "HERVORHEBUNG" ## document_button ## ehl ##
_httpiconehlof_ [l=de] {_httpimg_/de/ehlof.gif}
_httpiconehlon_ [l=de] {_httpimg_/de/ehlon.gif}
_widthehlx_ [l=de] {81}
_heightehlx_ [l=de] {30}

## "         KEINE
#HERVORHEBUNG" ## document_button ## enhl ##
_httpiconenhlof_ [l=de] {_httpimg_/de/enhlof.gif}
_httpiconenhlon_ [l=de] {_httpimg_/de/enhlon.gif}
_widthenhlx_ [l=de] {81}
_heightenhlx_ [l=de] {30}



######################################################################
# 'search' page
package query
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches
_textquerytitle_ [l=de] {_If_(_thislast_,Treffer _thisfirst_ - _thislast_ zur Anfrage: _cgiargq_,Keine Treffer f&uuml;r die Anfrage: _cgiargq_)}
_textnoquerytitle_ [l=de] {Suchseite}

_texticonthispage_ [l=de] {Suche}
_textsome_ [l=de] {_If_(_cgiargb_,gestaffelt,einige)}
_textall_ [l=de] {_If_(_cgiargb_,boolsch,alle)}
_texticonqueryresultsbar_ [l=de] {}
_textfreqmsg1_ [l=de] {Zahl der W&ouml;rter: }
_textpostprocess_ [l=de] {_If_(_quotedquery_,<br><i>weiterverarbeitet um _quotedquery_ zu finden</i>
)}

_textmorethan_ [l=de] {Mehr als }
_textapprox_ [l=de] {&Uuml;ber }
_textnodocs_ [l=de] {Keine Dokumente zur Anfrage passenden Dokumente gefunden.}
_text1doc_ [l=de] {Eins zur Anfrage passendes Dokument gefunden.}
_textlotsdocs_ [l=de] {zur Anfrage passenden Dokumente gefunden.}
_textmatches_ [l=de] {Passende Dokumente }
_textbeginsearch_ [l=de] {Suche beginnen}

_textsimplesearch_ [l=de] {Suche nach _If_(_hselection_, _hselection_)_If_(_jselection_,_textjselect_)_If_(_nselection_, in der _nselection_ Sprache) 
die _querytypeselection_ der W&ouml;rter enthalten}

_textadvancedsearch_ [l=de] {Suche nach _If_(_hselection_, _hselection_, _defaultindextext_)_If_(_jselection_,_textjselect_)_If_(_nselection_, in der _nselection_ Sprache) 
mit einer _querytypeselection_ Anfrage}

_textjselect_ [l=de] {_If_(_hselection_, aus) _jselection_}

_textstemon_ [l=de] { (Wortendungen werden ignoriert)}
_textclearhistory_ [l=de] {L&ouml;schen der alten Suchresultate}
_textexpand_ [l=de] {Expandierung}
_textcontract_ [l=de] {Kontraktion}
_textsearchhistory_ [l=de] {Alte Suchresultate}
_textquery_ [l=de] {Anfrage}
_textresults_ [l=de] {Resultate}
_textview_ [l=de] {Sichtung}
_textnohistory_ [l=de] {Alte Suchresultate nicht verf&uuml;gbar}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "suche" ## green_title ## h_search ##
_httpiconhsearch_ [l=de] {_httpimg_/de/h\_search.gif}
_widthhsearch_ [l=de] {200}
_heighthsearch_ [l=de] {57}

## "resultate" ## green_bar_left_aligned ## qryresb ##
_httpiconqryresb_ [l=de] {_httpimg_/de/qryresb.gif}
_widthqryresb_ [l=de] {_pagewidth_}
_heightqryresb_ [l=de] {17}

## "sichtung" ## hand_made ##
_httpicondisplay_ [l=de] {_httpimg_/display.gif}
_widthdisplay_ [l=de] {60}
_heightdisplay_ [l=de] {20}



######################################################################
# 'preferences' page
package preferences
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsearchprefs_ [l=de] {Suchvoreinstellungen}
_textcollectionprefs_ [l=de] {Voreinstellungen zu Kollektionen}
_textpresentationprefs_ [l=de] {Voreinstellungen zur Pr&auml;sentation}
_textpreferences_ [l=de] {Voreinstellungen}
_textignorecase_ [l=de] { ignoriere Gro&szlig;-/Kleinschreibung}
_textmatchcase_ [l=de] { Gro&szlig;-/Kleinschreibung mu&szlig; passen}
_textstem_ [l=de] { ignoriere Wortendungen}
_textnostem_ [l=de] { das vollst&auml;ndige Wort mu&szlig; passen}
_textprefop_ [l=de] {Zeige maximal _maxdocoption_ hits Treffer an, mit _hitsperpageoption_ Treffern per Seite.}
_textextlink_ [l=de] {Zugang zu externen Seiten: }
_textintlink_ [l=de] {Quelldokumente aufgefunden in:}
_textlanguage_ [l=de] {Schnittstellensprache: }
_textencoding_ [l=de] {Kodierung: }
_textformat_ [l=de] {Schnittstellenformat: }
_textall_ [l=de] {alle}
_textsimplemode_ [l=de] {einfache Anfragen}
_textadvancedmode_ [l=de] {komplexe Anfragen (erm&ouml;glicht boolsche Suche mit !, &, |, und Klammern)}
_textlinkinterm_ [l=de] {via einer dazwischenliegenden Seite}
_textlinkdirect_ [l=de] {gehe direkt dorthin}
_textdigitlib_ [l=de] {die elektronische Bibliothek}
_textweb_ [l=de] {das Web}
_textlangeng_ [l=de] {Englisch}
_textlangmaori_ [l=de] {M_amn_ori}
_textlangchinese_ [l=de] {Chinesisch}
_textgraphical_ [l=de] {Graphisch}
_texttextual_ [l=de] {Textuell}
_textcollectionoption_ [l=de] {<p>
Individuelle Sammlungen die eingebunden werden sollen:
<br>}
_textfcoption_ [l=de] {Produziere Navigationsleiste am Kopfende des Dokuments}
_texthloption_ [l=de] {Hervorhebung von Suchbegriffen im Text des Dokuments}
_texthistorydisplay_ [l=de] {Anzeige der alten Resultate}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "voreinstellungen" ## green_title ## h_pref ##
_httpiconhpref_ [l=de] {_httpimg_/de/h\_pref.gif}
_widthhpref_ [l=de] {200}
_heighthpref_ [l=de] {57}



######################################################################
# 'delete search history' page
package delhistory
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdsh_ [l=de] {L&ouml;sche alte Resultate}

_textselectdelete_ [l=de] {<a href="_httpclearhistory_&hdh=1">L&ouml;schen
aller Datens&auml;tze</a> oder Auswahl <select name=hmode><option
value=save>von Datens&auml;tzen die nicht gel&ouml;scht werden
sollen<option value=delete selected>delete</select><br>
Datens&auml;tze k&ouml;nnen ausgew&auml;hlt werden, indem ihre Nummern in das bereitgestellte Feld eingetragen werden,<br> oder indem auf das Felder im Datensatz geklickt wird.<br> M&ouml;gliche Werte sind 1,2,3-6,7- etc }

_textclearselected_ [l=de] {L&ouml;sche Selektionen}
_textselect_ [l=de] {Selektiere}


#------------------------------------------------------------
# icons
#------------------------------------------------------------



######################################################################
# 'help' page -- this is lower priority for translating than the
# rest of this file
package help
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textHelp_ [l=de] {Help}
_textSearchshort_ [l=de] {Suche nach bestimmten W&ouml;rtern}
_textSeriesshort_ [l=de] {Zugriff auf Publikationen nach Serien}
_textDateshort_ [l=de] {Zugriff auf Publikationen nach Zeit}
_textSubjectshort_ [l=de] {Zugriff auf Publikationen nach Sparten}
_textTitleshort_ [l=de] {Zugriff auf Publikationen nach Titel}
_textBrowseshort_ [l=de] {St&ouml;bern in Publikationen}
_textCreatorshort_ [l=de] {Zugriff auf Publikationen nach Autor}
_textOrganizationshort_ [l=de] {Zugriff auf Publikationen nach Organisation}
_textHowtoshort_ [l=de] {Zugriff auf Publikationen nach "Wie geht das?" Kategorien}
_textTopicshort_ [l=de] {Zugriff auf Publikationen nach Thema}
_textPeopleshort_ [l=de] {Zugriff auf Publikationen nach Personen}
_textdefaultshorttext_ [l=de] {Klassifikation is nicht definiert}

_textSearchlong_ [l=de] { <p>Sie k&ouml;nnen <i>nach bestimmten Begriffen
suchen</i>, die im Text der Suchseite erscheinen. Das ist die erste
Seite, die angezeigt wird, wenn sie anfangen. Sie kann von allen
anderen Seiten durch Anklicken des <i>Suche</i> Knopfes erreicht
werden.  }

_textTitlelong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Titel zugreifen</i> indem sie den <i>Titel A-Z</i> Knopf
anklicken. Dann wird ihnen eine alphabetisch geordnete Liste der
B&uuml;cher angezeigt.  }

_textOrganizationlong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen
geordnet nach Organisation zugreifen</i> indem sie den
<i>Organisationen</i> Knopf anklicken. Dann wird ihnen eine Liste der
Organisationen angezeigt.  }

_textHowtolong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen
geordnet nach "Wie geht das?" Kategorie zugreifen</i> indem sie den
<i>Wie geht das?</i> Knopf anklicken. Dann wird ihnen eine Liste der
"Wie geht das?" Kategorien angezeigt.  }

_textCreatorlong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Autor zugreifen</i> indem sie den <i>Autor</i> Knopf
anklicken. Dann wird ihnen eine nach Autor geordnete Liste der
B&uuml;cher angezeigt.  }

_textTopiclong_ [l=de] {  <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Thema zugreifen</i> indem sie den <i>Thema</i> Knopf
anklicken. Dann wird ihnen eine Liste der Themen angezeigt.  }

_textSubjectlong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Sparte zugreifen</i> indem sie den <i>Sparte</i> Knopf
anklicken. Dann wird ihnen eine Liste der Sparten angezeigt,
dargestellt durch B&uuml;cherregale.  }

_textSerieslong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Serie zugreifen</i> indem sie den <i>Serie</i> Knopf
anklicken. Dann wird ihnen eine Liste der Serien angezeigt, die sich momentan in der Sammlung befinden.  }

_textDatelong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Datum zugreifen</i> indem sie den <i>Datum</i> Knopf
anklicken. Dann wird ihnen eine chronologisch geordnete Liste aller
Ausgaben angezeigt.  }

_textBrowselong_ [l=de] { <p>Sie k&ouml;nnen durch <i>Publikationen
st&ouml;bern</i> indem sie den <i>St&ouml;bern</i> Knopf anklicken.  }

_textPeoplelong_ [l=de] { <p>Sie k&ouml;nnen auf <i> Publikationen geordnet
nach Personen zugreifen</i> indem sie den <i>Personen A-Z</i> Knopf
anklicken. Dann wird ihnen eine Liste aller Eintr&auml;ge angezeigt,
die nach Nachnamen geordnet ist.  }

_textdefaultlongtext_ [l=de] { <p>Klicken sie auf den <i>Unbekannt</i> Knopf
um durch die Publikationen zu st&ouml;bern. In diesem Fall wird die
Liste nach einem unbekannten Feld sortiert.  }

_texthelptopics_ [l=de] {
<h2 align=left>Themen</h2>
<ul>
  <li><a href="\#finding-information">_textsimplehelpheading_</a>
  _topicreadingdocs_
  <li><a href="\#searching">Wie man nach bestimmten W&ouml;rtern suchen kann</a>
<ul>
  <li><a href="\#query-terms">Suchbegriffe</a>
  <li><a href="\#query-type">Typ der Anfrage</a>
  <li><a href="\#scope-of-queries">Reichweite der Anfragen</a>
</ul>
  <li><a href="\#preferences">_textchangeprefs_</a>
<ul>
  <li><a href="\#col-prefs">Voreinstellungen zu den Sammlungen</a>
  <li><a href="\#pres-prefs">Voreinstellungen zur Pr&auml;sentation</a>
  <li><a href="\#search-prefs">Suchvoreinstellungen</a>
</ul>
</ul>
}

# there are 4 versions of this section of the help text.
# which version is used is currently set within the server
# (it should probably use the macro language e.g. [type=book])
# 1 = html (like fao collections) -- section is empty
# 2 = book (like hdl collection) -- macros beginning with book
# 3 = bibliographic (like csbib) -- macros beginning with bib
# 4 = standard (like gberg) -- the default

_topicreadingdocs_ [l=de] {<li><a href="\#reading-docs">_textreadingdocs_</a>}

_textreadingdocs_ [l=de] {Wie Dokumente gelesen werden k&ouml;nnen}
_booktextreadingdocs_ [l=de] {Wie B&uuml;cher gelesen werden k&ouml;nnen}
_bibtextreadingdocs_ [l=de] {Wie man weitere Informationen zu einem
bibliographischen Eintrag erhalten kann}

_texthelpreadingdocs_ [l=de] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p> Sie k&ouml;onnen feststellem, dass sie bei einem einzelnen
Dokument angekommen sind, wenn dessen Titel und Autor links oben auf
der Seite angezeigt werden. Daneben ist die aktuelle Seitennummer, ein
K&auml;stchen welches ihnen die Auswahl einer neuen Seite erlaubt und
vorw&auml;rts und r&uuml;ckw&auml;ts Pfeile.

<p>Darunter ist der Text des aktuellen Abschnitts. Unten befinden befinden
sich Pfeile, die sie zum n&auml;chsten Abschnitt oder zum vorherigen
bringen nachdem sie den aktuellen Abschnitt gelesen haben.

<p>Unter dem Titel und dem Namen des Autors befinden sich drei Kn&ouml;pfe.
Dr&uuml;cken sie auf <i>ganzes Dokument</i>, um den gesamten Text des
aktuellen Dokuments anzuzeigen. Ist 
das Dokument umfangreich, so kann der Ladevorgang einige Zeit in
Anspruch nehmen und es wird viel Arbeitsspeicher benn&ouml;tigt!
Dr&uuml;cken sie auf <i>neues Fenster</i>, um das Dokument in einem neuen
Browserfenster zu &ouml;ffnen. (Dies is sinnvoll, wenn sie Dokumente
vergleichen oder zwei auf einmal lesen wollen.) Wenn sie das Dokument
aufgrund einer Suche erhalten haben sind die Suchbegriffe
hervorgehoben. Dr&uuml;cken sie auf <i>nicht hervorheben</i>, um die
Suchbegriffe normal darzustellen.
<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconmore_"
border="0"></td><td>Dr&uuml;cken sie auf den Pfeil, um zum n&auml;chsten
Abschnitt zu gelangen ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... oder
zur&uuml;ck zum vorigen Abschnitt</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Gesamten Text
darstellen, oder nicht</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_"
border="0"></td><td>Diese Seite in einem neuen Fenster &ouml;ffnen</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Suchbegriffe
hervorheben, oder nicht</td></tr>
</table>

}

_booktexthelpreadingdocs_ [l=de] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>Sie k&ouml;nnen feststellem, dass sie bei einem einzelnen Buch angekommen
sind, wenn eine Photographie seines Titelbildes links oben auf der Seite
angezeigt wird. Daneben ist das Inhaltsverzeichnis angezeigt. Ein Pfeil
markiert wo sie sich befinden. Das Inhaltsverzeichnis kann expandiert
werden. Dr&uuml;cken sie auf die dargestellten Ordner, um sie zu
&ouml;ffnen bzw. zu schliessen. Dr&uuml;cken sie auf das offene Buch, um es
zu schliessen.

<p>Darunter ist der Text des aktuellen Abschnitts. Unten befinden befinden
sich Pfeile, die sie zum n&auml;chsten Abschnitt oder zum vorherigen
bringen nachdem sie den aktuellen Abschnitt gelesen haben.

<p>Unter dem Titel und dem Namen des Autors befinden sich vier Kn&ouml;pfe.
Dr&uuml;cken sie auf <i>ganzes Dokument</i>, um den gesamten Text des
aktuellen Dokuments oder Buches anzuzeigen. Ist 
das Buch umfangreich, so kann der Ladevorgang einige Zeit in
Anspruch nehmen und es wird viel Arbeitsspeicher benn&ouml;tigt!
Dr&uuml;cken sie auf <i>Verzeichnis expandieren</i>, um das
Inhaltsverzeichnis des aktuellen Buches vollst&auml;ndig zu
expandieren. Die Titel aller Kapitel und Unterkapitel werden dann
angezeigt.
Dr&uuml;cken sie auf <i>neues Fenster</i>, um das Buch in einem neuen
Browserfenster zu &ouml;ffnen. (Dies is sinnvoll, wenn sie B&uuml;cher
vergleichen oder zwei auf einmal lesen wollen.) Wenn sie das Buch
aufgrund einer Suche erhalten haben sind die Suchbegriffe
hervorgehoben. Dr&uuml;cken sie auf <i>nicht hervorheben</i>, um die
Suchbegriffe normal darzustellen.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconbshelf_"
border="0"></td><td>Dieses B&uuml;cherregal &ouml;ffnen</td></tr>
<tr><td><img src="_httpiconopenbook_" border="0"></td><td><img 
src="_httpiconbook_" border="0"></td><td>Dieses Buch &ouml;ffnen/schliessen</td></tr>
<tr><td colspan=2><img src="_httpiconitext_" border="0"></td><td>Diesen Abschnitt des Texts zeigen</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Gesamten Text
darstellen, oder nicht</td></tr>
<tr><td><img src="_document:httpiconeexpcof_" border="0"></td><td><img
src="_document:httpiconeconcof_" border="0"></td><td>Inhaltsverzeichnis
expandieren, oder nicht</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Diese Seite in einem neuen Fenster &ouml;ffnen</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Suchbegriffe
hervorheben, oder nicht</td></tr>
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Pfeil
dr&uuml;cken, um zum n&auml;chsten Abschnitt zu gelangen ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... oder
zur&uuml;ck zum vorigen Abschnitt</td></tr>
</table>
}

_bibtexthelpreadingdocs_ [l=de] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p> Manche Literatur eintr&auml;e enthalten zus&auml;tzliche Informationen,
wie z.B. eine Zusammenfassung. Sie k&ouml;nnen am Aussehen der
Antwortseite, die sie aufgrund ihrer Anfrage erhalten, feststellen, ob
zus&auml;tzliche Informationen vorliegen. In diesem Fall werden die
Literatureintr&auml;ge mittels des _icontext_ Ikons anstatt des
_iconblanktext_ Ikons dargestellt.

<p>Wenn sie auf das _icontext_ Ikon dr&uuml;cken erhalten sie
zus&auml;tzliche Informationen &uuml;ber den Literatureintrag.

<p> Unter einem Literatureintrag befinden sich zwei
Kn&oum;pfe. Dr&uuml;cken sie auf <i>neues Fenster</i>, um das Buch in einem
neuen Browserfenster darzustellen. (Dies ist sinnvoll falls
Literatureintr&auml;ge vergleichen wollen.)
Wenn sie den Literatureintrag
aufgrund einer Suche erhalten haben sind die Suchbegriffe
hervorgehoben. Dr&uuml;cken sie auf <i>nicht hervorheben</i>, um die
Suchbegriffe normal darzustellen.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Open this page in a new window</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Suchbegriffe
hervorheben, oder nicht</td></tr> 
</table>
}

_texthelpsearching_ [l=de] {
<h2>Wie sie nach bestimmten Worten suchen k&ouml;nnen</h2>
<p>
  Ausgehend von der Suchseite starten sie eine Suchanfrage in den folgenden
  einfachen Schritten::<p>
  
  <ol><li>Spezifizieren sie welche Dokumente sie durchsuchen wollen
      <li>Sagen sie, ob sie nach allen oder lediglich einigen der
      Suchbegriffe suchen wollen
      <li>Geben sie die Suchbegriffe ein
      <li>Dr&uuml;cken sie den Knopf <i>Starte Anfrage</i>
  </ol>

<p> Wenn sie eine Anfrage durchf&uuml;hren werden die Titel von zwanzig
dazu gefundenen Dokumenten angezeigt. Am Ende der Seite befindet sich ein
Knopf mit dem sie die n&auml;chsten zwanzig Seiten dargestellt
bekommen. Dort finden sie einen Knopf, der sie zu den n&auml;chsten Zwanzig
und einen der sie zu den ersten zwanzig bringt, und so fort. Um ein
beliebiges Dokument zu sehen dr&uuml;cken sie auf seinen Titel  oder den
kleinen Knopf daneben. 

<p> Gem&auml;ss der Voreinstellungen werden maximal bis zu 100 Dokumente zu
einer Anfrage zur&uuml;ckgegeben. Sie k&ouml;nnen diese Anzahl &auml;ndern
inden sie auf den Knopf <i>Voreinstellungen</i> am Kopf der Seite
dr&uuml;cken.<p> 

<p>_iconblankbar_
<a name=query-terms>
<h3>Suchbegriffe</h3>

<p> Was immer sie in das Suchfeld eingeben wird als Liste von Worten
interpretiert, die "Suchbegriffe" genannt werden. Jeder Begriff darf
ausschliesslich alphabetische Zeichen und Zahlen enthalten. Begriffe werden
durch Leerzeichen getrennt. Falls Interpunktionszeichen wie Punkte oder Kommata
auftauchen, dienen diese dazu, genau wie Leerzeichen, Begriffe zu
trennen. Im weiteren werden sie nicht weiter beachtet. Sie k&ouml;nnen
nicht nach Worten suchen die Interpunktionszeichen enthalten!

<p>Beispiel: die Anfrage<p>
    <ul><kbd>Agro-forestry in the Pacific Islands: Systems for Sustainability (1993)</kbd></ul>
      <p>wird genauso interpretiert wie<p>
      <ul><kbd>Agro forestry in the Pacific Islands  Systems for Sustainability  1993 </kbd></ul><p>

<p>_iconblankbar_
<a name=query-type>
<h3>Anfragearten</h3>

<p>Es gibt zwei unterschiedliche Arten von Anfragen.

<ul>
  <li>Anfragen nach <b>allen</b> eingegebenen Suchbegriffen. Anfragen
  dieser Art suchen nach Dokumenten, die alle eingegebenen Suchbegriffe
  beinhalten. Dokumente, die der Anfrage gen&uuml;gen werden in
  alphabetischer Reihenfolge dargestellt.<p>

  <li>Anfragen nach <b>einigen</b> der eingegebenen Suchbegriffen. Geben
      sie einfach einige der Begriffe an, die m&ouml;glicherweise in den
      Dokumenten enthalten sind nach denen sie suchen. Die Dokumente werden
      in der Reihenfolge dargestellt je nachdem wie stark sie die
      Suchanfrage erf&uuml;llen. Der Grad des Erf&uuml;llens der
      Suchanfrage wird folgendermassen bestimmt.
      <p><ul>
        <li> Je mehr Suchbegriffe ein Dokument enth&auml;lt desto besser
      erf&uuml;llt es die Anfrage.
        <li> Seltene Begriffe sind wichtiger als sehr oft vorkommende.
        <li> Kurze Dokumente erf&uuml;llen Anfragen besser als lange.
      </ul>
</ul>

<p> Benutzen sie so viele Suchbegriffe wie sie wollen -- einen ganzen Satz
oder gar einen ganzen Absatz. Falls sie nur einen einzigen Suchbegriff
angeben werden die Dokumente nach der H&auml;ufigkeit dessen Auftauchens
sortiert.<p>
_texthelpscope_
}

_textchangeprefs_ [l=de] {&Auml;ndern ihrer Voreinstellungen}

_texthelppreferences_ [l=de] {<h2>_textchangeprefs_</h2>

<p>Wenn sie den Knopf <i>Voreinstellungen</i> am Kopf der Seite
dr&uuml;cken, k&ouml;nnen sie einige Eigenschaften der
Benutzerschnittstelle so ver&auml;ndern, dass sie ihren Anforderungen
entspricht. 

<p>_iconblankbar_
<a name=col-prefs>
<h3 align=left>Kollektionsvoreinstellungen</h3>

Einige Kollektionen enthalten mehrere Unterkollektionen welche entwerder
unabh&auml;ngig oder gemeinsam als eine Einheit durchsucht werden
k&ouml;nnen. Falls dem so ist, k&ouml;nnen sie auf der Voreinstellungsseite
festlegen, welche der Unterkollektionen im Rahmen ihrer Anfragen
ber&uuml;cksichtigt werden sollen.

<p>_iconblankbar_
<a name=pres-prefs>
<h3 align=left>Darstellungsvoreinstellungen</h3>

Je nach vorliegender Kollektion k&ouml;nnen verschiedene Optionen
eingestellt werden, die die Art der Darstellung beeinflussen.

Kollektionen von Webseiten gestatten es ihnen die Darstellung der 
Greenstonenavigationsleiste, die sich am Kopf jeder Dokumentseite befindet
zu unterdr&uuml;cken. Auf diese Weise endet ihre Anfrage direkt auf der
Webseite, die ihre Anfrage erf&uuml;llt, ohne dass der Greenstoneseitenkopf
dargestellt wird. Um in diesem Falle eine weitere Suche durchf&uuml;hren zu
k&ouml;nnen m&uuml;ssen sie den "Zur&uuml;ck" Knopf ihres Browsers
bet&auml;tigen. Diese Art der Kollektionen erlaubt es ihnen auch die
Greenstonewarnmeldungen zu unterdr&uuml;cken, die gezeigt werden, wenn sie
einen Link verfolgen, der aus der Greenstonekollektion in das World-Wide
Web f&uuml;hrt. Weiterhin k&ouml;nnen sie in manchen Webkollektionen
einstellen, ob sie die Links auf der Ergebnisseite anstatt zur lokal in
der Kollektion gespeicherten Kopie direkt zur Originalwebseite f&uuml;hren
sollen. 

Kollektionen, die in verschiedenen Sprachen dargestellt werden k&ouml;nnen,
erlauben ihnen die Wahl der in der Benutzerschnittstelle zu verwendenden
Sprache. Ist die gew&auml;hlte Sprache Chinesisch, so k&ouml;nnen sie
ausserdem feststellen, welche der Standardkodierungen f&uuml;r Chinesisch
ihr Browser verwendet.

Schliesslich erlauben ihnen alle Kollektionen anstatt der graphischen
Standardschnittstelle eine textuelle Schnittstelle zu verwenden. Dies ist
besonders f&uuml;r sehbehinderte Benutzer, die auf die Verwendung grosser
Zeichens&auml;tze oder von Ger&auml;ten zur Sprachausgabe angewiesen sind,
sinnvoll.

<p>_iconblankbar_
<a name=search-prefs>
<h3 align=left>Suchvoreinstellungen</h3>
Zwei Knopfpaare steuern, ob bei ihren Anfragen Gross- und Kleinschreibung
beachtet wird, und ob Wortst&auml;mme Verwendung finden. Die ersten beiden
Kn&ouml;pfe steuern, ob Gross- und Kleinbuchstanben zwischen ihrer Anfrage
und den Dokumententextem &uuml;bereinstimmen m&uuml;ssen. Die zweiten
beiden Kn&ouml;pfe bestimmen, ob Wortenden bei der Suche ignoriert werden
oder nicht. 

<p>Beispiel: wenn die Kn&ouml;pfe <i>ignoriere Gross-/Kleinschreibung</i> und
<i>ignoriere Wortendungen</i> angew&aauml;hlt sind, wird die Anfrage<p>
    <ul><kbd>African buildings</kbd></ul>
      <p>genauso behandelt wie die Anfrage<p>
      <ul><kbd>africa build</kbd>,</ul><p>
      da der Grossbuchstabe in "African" zu einem Kleinbuchstaben
      transformiert wird und die Endungen "n" and "ing" von
      "African" und "building" entfernt werden (ausserdem wird "s" von
      "builds" entfernt).

<p>Sie k&ouml;nnen auch auf einen komplexeren Anfragemodus umschalten,
welcher es ihnen gestattet Begriffe zu kombinieren indem sie sie mittels
der Operatoren AND (&), OR (|), und NOT (!) verkn&uuml;pfen. Dies erlaubt
es ihnen pr&auml;zisere Anfragen zu spezifizieren.

<p>Schliesslich k&ouml;nnen sie die Anzahl der als Antwort
zur&uuml;ckgegebenen passenden Dokumente und  der
auf einer Seite dargestellten Dokumente einstellen.

}

_texttanumbrowseoptions_ [l=de] {Es gibt _numbrowseoptions_ Arten Informationen in
dieser Kollektion zu finden:}

_textsimplehelpheading_ [l=de] {Wie man Informationen findet}

_texthelpscope_ [l=de] {
<p>_iconblankbar_
<a name=scope-of-queries>
<h3 align=left>Reichweite der Anfragen</h3>

<p> In den meisten Kollektionen k&ouml;nnen sie in verschiedenen Indexen
suchen. Es kann zum Beispiel einen Autoren- und einen Titelindex
geben. Oder es gibt einen Kapitel- und einen Paragraphenindex. In jedem
Fall wird zu ihrer Anfrage passendes Dokument immer vollst&auml;ndig
zur&uuml;ckgegeben egal welchen Index sie zur Suche verwendet haben.
<p>Sollte es sich bei Dokumenten um B&uuml;cher handeln, so werden sie immer
an der passenden Stelle (in der Kollektion) ge&ouml;ffnet.
}
