/**********************************************************************
 *
 * gsdlconf.h -- system specific includes
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef GSDLCONF_H
#define GSDLCONF_H

#if defined(__WIN32__)
#include "../win32cfg.h"
#else
#include "../config.h"
#endif

// Note: all macros used in the gsdl software (except the _H macros) should
// now start with GSDL_

// GSDL_NEED_STRINGS_H should be defined if some string functions
// needed (like strcasecmp) are in strings.h
#if defined(__IBMCPP__)
#  define GSDL_NEED_STRINGS_H
#endif

// GSDL_USE_IOS_H should be defined if the .h extension needs to
// be used for the io stream headers
#if defined(__GNUG__) || defined(__IBMCPP__)
#  define GSDL_USE_IOS_H 1
#endif

// GSDL_USE_STL_H should be defined if the .h extension needs to
// be used for the stl header files
#if defined(__IBMCPP__)
#  define GSDL_USE_STL_H 1
#endif

// GSDL_USE_ALGO_H should be defined if algo.h should be used 
// instead of algorithm.h
#if defined(__IBMCPP__)
#  define GSDL_USE_ALGO_H 1
#endif

// GSDL_NAMESPACE_BROKEN should be defined if namespaces should
// not be used
#if defined(__GNUG__) || defined(__IBMCPP__)
#  define GSDL_NAMESPACE_BROKEN 1
#endif

// GSDL_USE_OBJECTSPACE should now be used instead of USE_OBJECTSPACE
#if defined(USE_OBJECTSPACE)
#  define GSDL_USE_OBJECTSPACE
#endif

// GSDL_NEED_DESTROY_USHORT should be defined if the compiler needs
// a definition for void destroy(short unsigned int *)
#if defined(__IBMCPP__)
# define GSDL_NEED_DESTROY_USHORT
#endif

// mktemp

#if !defined(__WIN32__) || defined(__GNUC__)
#include <unistd.h>
#define GSDL_MKTEMP(str) mktemp(str)
#else
#include <io.h>
#define GSDL_MKTEMP(str) _mktemp(str)
#endif



// file locking

#if defined(__WIN32__)

#if !defined(LK_UNLOCK) && defined(LK_UNLCK)
#define LK_UNLOCK LK_UNLCK
#endif

#if defined (GSDL_USE_IOS_H)
#include <io.h>
#include <sys/locking.h>

#if defined(__GNUC__)
#define GSDL_GET_FILEDESC(str) str.filedesc()
#else
#define GSDL_GET_FILEDESC(str) str.fd()
#endif

#define GSDL_UNLOCK_FILE(fd) _locking(fd, LK_UNLCK, 200)
#define GSDL_LOCK_FILE(fd) lock_val = _locking(fd, LK_NBLCK, 200)

#else

// when using <fstream> (i.e. VC++ 6.0) I can't work out how
// to return a filedesc. File locking won't currently work
// for those windows compilers requiring GSDL_USE_IOS_H to
// not be set -- Stefan.
#define GSDL_GET_FILEDESC(str) 1
#define GSDL_LOCK_FILE(fd) lock_val = 0
#define GSDL_UNLOCK_FILE(fd) 0
#endif

#else
#define GSDL_GET_FILEDESC(str) str.filedesc()

#if GSDL_USE_FLOCK
#include <sys/lock.h>

#ifndef LOCK_SH
#define LOCK_SH	1
#endif

#ifndef LOCK_EX
#define LOCK_EX	2
#endif

#ifndef LOCK_NB
#define LOCK_NB 4
#endif

#ifndef LOCK_UN
#define LOCK_UN 8
#endif

#define GSDL_UNLOCK_FILE(fd) flock (fd, LOCK_UN)
#define GSDL_LOCK_FILE(fd) lock_val = flock (fd, LOCK_EX + LOCK_NB)

#else
// use fcntl
#include <fcntl.h>
#define GSDL_UNLOCK_FILE(fd) \
	{					\
	  struct flock flock;			\
	  flock.l_type = F_UNLCK;		\
	  flock.l_whence = SEEK_SET;		\
	  flock.l_start = flock.l_len = 0L;	\
	  fcntl (fd, F_SETLK, &flock);	\
	}
#define GSDL_LOCK_FILE(fd) \
	{					\
	  struct flock flock;			\
	  flock.l_type = F_WRLCK;		\
	  flock.l_whence = SEEK_SET;			\
	  flock.l_start = flock.l_len = 0L;	\
	  lock_val = fcntl (fd, F_SETLK, &flock);	\
	}

#endif
#endif

#endif
