/**********************************************************************
 *
 * fileutil.h -- a few useful file utilities
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef FILEUTIL_H
#define FILEUTIL_H

#include "text_t.h"


// returns the proper concatenation of the two paths
text_t filename_cat (text_t path1, text_t path2);
text_t filename_cat (text_t path1, text_t path2, text_t path3);
text_t filename_cat (text_t path1, text_t path2, text_t path3, text_t path4);
text_t filename_cat (text_t path1, text_t path2, text_t path3, text_t path4, 
		     text_t path5);
text_t filename_cat (text_t path1, text_t path2, text_t path3, text_t path4, 
		     text_t path5, text_t path6);

// returns true if filename can be opened
bool file_exists (const text_t &filename);

// returns true if filename can be written to
bool file_writable (const text_t &filename);

// returns true if directory exists
bool directory_exists (const text_t &dirname);

// note that read_dir appends to filelist, it doesn't clear
// it first
bool read_dir (const text_t &dirname, text_tarray &filelist);
bool read_dir (const text_t &dirname, text_tset &filelist);

bool file_copy (const text_t &fromfile, const text_t &tofile);

text_t file_tail (const text_t &filename, int numlines, int linelength);

// returns true if directory created successfully
bool mk_dir (const text_t &dirname);

bool read_file (const text_t &filename, text_t &content);

#endif
