#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace/std/iostream>
#  include <ospace/std/fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#  include <fstream.h>
#else
#  include <iostream>
#  include <fstream>
#endif

#include "cnfgator.h"

configurator::configurator(configurable *configureobject) {
  configureobjs.push_back(configureobject);
}

void configurator::add_configurable(configurable *configureobject) {
  configureobjs.push_back(configureobject);
}

bool configurator::configure(text_t filename) {
  // read in the build configuration file
  text_t key;
  text_tarray cfgline;
  char *cstr = filename.getcstr();
  ifstream confin (cstr);
  delete cstr;

  if (confin) {
    while (read_cfg_line(confin, cfgline) >= 0) {
      if (cfgline.size () >= 2) {
	key = cfgline[0];
	cfgline.erase(cfgline.begin());

	// configure the configurables
	configurable *configureObject;
	vector<configurable *>::iterator configureIter = configureobjs.begin();

	while (configureIter != configureobjs.end()) {
	  configureObject = *configureIter;
	  configureIter ++;
    
	  configureObject->configure (key, cfgline);
	}
      }
    }
    confin.close ();
    return true;
  }
  return false;
}
