/**********************************************************************
 *
 * cfgread.h -- reads in configuration files
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef CFGREAD_H
#define CFGREAD_H

#include "gsdlconf.h"
#include "text_t.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <fstream.h>
#else
#  include <fstream>
#endif

// return 0 on success, -1 on failure
int write_ini_line (ofstream &fileout, const text_t &key, const text_t value);
int read_ini_line (ifstream &filein, text_t &key, text_t &value);
int write_cfg_line (ofstream &fileout, const text_tarray &values);
int read_cfg_line (ifstream &filein, text_tarray &values);

#endif
