#include "Image.h" 

#define xoutRound(x) ((int)(x + 0.5))
double Image::scale=1.0;

Image::Image(){
  filename=NULL;
  x=0;
  y=0;
  width=0;
  height=0;
 }
 
 Image::Image(GString *fname,int _width,int _height,int _x,int _y){
  filename=fname->copy();
  width=_width;
  height=_height;
  x=_x;
  y=_y;
 }

Image::Image(const Image& a){
  filename=a.filename->copy();
  width=a.width;
  height=a.height;
  x=a.x;
  y=a.y;
} 
 Image::~Image(){
   delete filename;
 }

 Image& Image::operator=(const Image& a){
   if (this!=&a){
     filename=a.filename->copy();
     width=a.width;
     height=a.height;
     x=a.x;
     y=a.y;
   }
  return *this;
 }
  
void Image::setScale(double x){scale=x;}
double Image::getScale(){return scale;}

GString* Image::getHtmlString(){
    int _width=xoutRound((double)width*scale);
    int _height=xoutRound((double)height*scale);
    GString* wd=GString::IntToStr(_width-1);
    GString* ht=GString::IntToStr(_height-1);
    GString* tmp=new GString("<img width=");
    tmp->append(wd);
    tmp->append(" height=");
    tmp->append(ht);
    tmp->append(" src=\"");
    tmp->append(filename);
    tmp->append("\">");
    delete wd;
    delete ht;
    return tmp;
    
} 





