//========================================================================
//
// TextOutputDev.h
//
// Copyright 1997 Derek B. Noonburg
//
// Changed 1999 by G.Ovtcharov
//========================================================================

#ifndef TEXTOUTPUTDEV_H
#define TEXTOUTPUTDEV_H

#ifdef __GNUC__
#pragma interface
#endif

 #include <stdio.h>
#include "gtypes.h"
#include "GfxFont.h"
#include "OutputDev.h"
#include "Image.h"
#include "GVector.h" 
#include "HtmlLinks.h"
#include "HtmlFonts.h"
#include "Link.h"
#include "Catalog.h"

class GfxState;
class GString;
//------------------------------------------------------------------------
// TextString
//------------------------------------------------------------------------



class HtmlString {
public:

  // Constructor.
  HtmlString(GfxState *state, GBool hexCodes1,HtmlFontAccu* fonts);

  // Destructor.
  ~HtmlString();

  // Add a character to the string.
  void addChar(GfxState *state, double x, double y,
	       double dx, double dy,
	       Guchar c, GBool useASCII7);

  // Add a 16-bit character to the string.
  void addChar16(GfxState *state, double x, double y,
		 double dx, double dy,
		 int c, GfxFontCharSet16 charSet);
   

private:
// aender die text variable
  double xMin, xMax;		// bounding box x coordinates
  double yMin, yMax;		// bounding box y coordinates
  int col;			// starting column
  GString *text;		// the text
  double *xRight;		// right-hand x coord of each char
  HtmlString *yxNext;		// next string in y-major order
  HtmlString *xyNext;		// next string in x-major order
  GBool hexCodes;		// subsetted font with hex char codes
  int fontpos;
  GString* htext;
 
  
  friend class HtmlPage;
  friend class HString;

};


//------------------------------------------------------------------------
// TextPage
//------------------------------------------------------------------------



class HtmlPage {
public:

  // Constructor.
  HtmlPage(GBool useASCII7, GBool rawOrder);

  // Destructor.
  ~HtmlPage();

  // Begin a new string.
  void beginString(GfxState *state, GString *s, GBool hex1);

  // Add a character to the current string.
  void addChar(GfxState *state, double x, double y,
	       double dx, double dy, Guchar c);

  // Add a 16-bit character to the current string.
  void addChar16(GfxState *state, double x, double y,
		 double dx, double dy, int c,
		 GfxFontCharSet16 charSet);

  // End the current string, sorting it into the list of strings.
  void endString();

  // Coalesce strings that look like parts of the same line.
  void coalesce();

  // Find a string.  If <top> is true, starts looking at top of page;
  // otherwise starts looking at <xMin>,<yMin>.  If <bottom> is true,
  // stops looking at bottom of page; otherwise stops looking at
  // <xMax>,<yMax>.  If found, sets the text bounding rectange and
  // returns true; otherwise returns false.
  

  // new functions
 

  
  void AddImage(const Image& x);
  // Dump contents of page to a file.
 
  void AddLink(const HtmlLink& x){
    links->AddLink(x);
  }

 void dump(FILE *f);

  // Clear the page.
  void clear();
  
  void conv();
private:

  GBool useASCII7;		// use 7-bit ASCII?
  GBool rawOrder;		// keep strings in content stream order

  HtmlString *curStr;		// currently active string

  HtmlString *yxStrings;	// strings in y-major order
  HtmlString *xyStrings;	// strings in x-major order
  HtmlString *yxCur1, *yxCur2;	// cursors for yxStrings list

  
  GVector<Image> *images;
  HtmlFontAccu *fonts;
  HtmlLinks *links;

  int pageWidth;
  int pageHeight; 

  int x;
  int y;

};

//------------------------------------------------------------------------
// TextOutputDev
//------------------------------------------------------------------------

class HtmlOutputDev: public OutputDev {
public:

  // Open a text output file.  If <fileName> is NULL, no file is written
  // (this is useful, e.g., for searching text).  If <useASCII7> is true,
  // text is converted to 7-bit ASCII; otherwise, text is converted to
  // 8-bit ISO Latin-1.  <useASCII7> should also be set for Japanese
  // (EUC-JP) text.  If <rawOrder> is true, the text is kept in content
  // stream order.
  HtmlOutputDev(char *fileName, GBool useASCII7, GBool rawOrder);

  // Destructor.
  virtual ~HtmlOutputDev();

  // Check if file was successfully created.
  virtual GBool isOk() { return ok; }

  //---- get info about output device

  // Does this device use upside-down coordinates?
  // (Upside-down means (0,0) is the top left corner of the page.)
  virtual GBool upsideDown() { return gTrue; }

  // Does this device use drawChar() or drawString()?
  virtual GBool useDrawChar() { return gTrue; }

  //----- initialization and control

  // Start a page.
  virtual void startPage(int pageNum, GfxState *state);

  // End a page.
  virtual void endPage();

  //----- update text state
  virtual void updateFont(GfxState *state);

  //----- text drawing
  virtual void beginString(GfxState *state, GString *s);
  virtual void endString(GfxState *state);
  virtual void drawChar(GfxState *state, double x, double y,
			double dx, double dy, Guchar c);
  virtual void drawChar16(GfxState *state, double x, double y,
			  double dx, double dy, int c);

  
  virtual void drawImageMask(GfxState *state, Stream *str,
			     int width, int height, GBool invert,
			     GBool inlineImg);
  virtual void drawImage(GfxState *state, Stream *str, int width,
			 int height, GfxImageColorMap *colorMap,
			 GBool inlineImg);

  //new feature    
  virtual int DevType() {return 1234;}
  virtual void drawLink(Link *link,Catalog *cat); 

private:
  GString* getLinkDest(Link *link,Catalog *catalog);
  FILE *f;			// text file
  FILE *page;                   // html file
  FILE *tin;
  GBool needClose;		// need to close the file?
  HtmlPage *pages;		// text for the current page
  GBool rawOrder;		// keep text in content stream order
  GBool hexCodes;		// subsetted font with hex char codes
  GBool ok;			// set up ok?
  GBool dumpJPEG;
  int pageNum;
  int imgNum;
  GString *Docname;
};

#endif
