#include "HtmlFonts.h"
#include <stdio.h>

 struct Fonts{
    char *Fontname;
    char *name;
  };

  static Fonts fonts[]={  
     {"Courier",               "Courier" },
     {"Courier-Bold",           "Courier"},
     {"Courier-BoldOblique",    "Courier"},
     {"Courier-Oblique",        "Courier"},
     {"Helvetica",              "Helvetica"},
     {"Helvetica-Bold",         "Helvetica"},
     {"Helvetica-BoldOblique",  "Helvetica"},
     {"Helvetica-Oblique",      "Helvetica"},
     {"Symbol",                 "Symbol"   },
     {"Times-Bold",             "Times"    },
     {"Times-BoldItalic",       "Times"    },
     {"Times-Italic",           "Times"    },
     {"Times-Roman",            "Times"    },
     {" "          ,            "Times"    },

};

#define xoutRound(x) ((int)(x + 0.5))

const int font_num=13;
GString* HtmlFont::DefaultFont=new GString("Times"); // Arial,Helvetica,sans-serif
double HtmlFont::scale=1.0;

HtmlFontColor::HtmlFontColor( GfxColor* col){
  r=static_cast<int>(255*col->getR());
  g=static_cast<int>(255*col->getG());
  b=static_cast<int>(255*col->getB());
  if (!(Ok(r)&&Ok(b)&&Ok(g))) {printf("Error : Bad color \n");r=0;g=0;b=0;}
}

GString *HtmlFontColor::convtoX(unsigned int xcol) const{
  GString *xret=new GString();
  char tmp;
  unsigned  int k;
  k = (xcol/16);
  if ((k>=0)&&(k<10)) tmp=(char) ('0'+k); else tmp=(char)('a'+k-10);
  xret->append(tmp);
  k = (xcol%16);
  if ((k>=0)&&(k<10)) tmp=(char) ('0'+k); else tmp=(char)('a'+k-10);
  xret->append(tmp);
 return xret;
}

GString *HtmlFontColor::toString() const{
 GString *tmp=new GString("#");
 GString *tmpr=convtoX(r); 
 GString *tmpg=convtoX(g);
 GString *tmpb=convtoX(b);
 tmp->append(tmpr);
 tmp->append(tmpg);
 tmp->append(tmpb);
 delete tmpr;
 delete tmpg;
 delete tmpb;
 return tmp;
} 

HtmlFont::HtmlFont(GString* ftname,int _size,GfxColor *col){
 color=col;
 GString *fontname=new GString(ftname);
 size=static_cast<int>((double)_size*scale)-1;
 italic = gFalse;
 bold = gFalse;
 FontName=new GString(ftname);
 if (fontname){
  if (strstr(fontname->lowerCase()->getCString(),"bold"))  bold=gTrue;
 
  if (strstr(fontname->lowerCase()->getCString(),"italic")||
      strstr(fontname->lowerCase()->getCString(),"oblique"))  italic=gTrue;
  
  int i=0;
  while (strcmp(ftname->getCString(),fonts[i].Fontname)&&(i<font_num)) i++;
  pos=i;
  delete fontname;
 }  
  if (!DefaultFont) DefaultFont=new GString(fonts[font_num].name);

}
 
HtmlFont::HtmlFont(const HtmlFont& x){
   size=x.size;
   italic=x.italic;
   bold=x.bold;
   pos=x.pos;
   color=x.color;
   FontName=new GString(x.FontName);
 }


HtmlFont::~HtmlFont(){
 if (!FontName) delete FontName;
}
HtmlFont& HtmlFont::operator=(const HtmlFont& x){
   if (this==&x) return *this; 
   size=x.size;
   italic=x.italic;
   bold=x.bold;
   pos=x.pos;
   color=x.color;
   if (FontName) delete FontName;
   FontName=new GString(x.FontName);
   return *this;
}

void HtmlFont::clear(){
  if(DefaultFont) delete DefaultFont;
}



GBool HtmlFont::isEqual(const HtmlFont& x) const{
  return ((size==x.size)&&(pos==x.pos)&&(color.isEqual(x.getColor())));
  // (bold==x.bold)&&(italic==x.italic))
}

GString* HtmlFont::getFontName(){
   if (pos!=font_num) return new GString(fonts[pos].name);
    else return new GString(DefaultFont);
}

GString* HtmlFont::getFullName(){
   return new GString(FontName);
} 

void HtmlFont::setDefaultFont(GString* defaultFont){
  if (DefaultFont) delete DefaultFont;
  DefaultFont=new GString(defaultFont);
}



double HtmlFont::getScale(){return scale;}
void HtmlFont::setScale(double x){scale=x;}

GString* HtmlFont::getDefaultFont(){
   return DefaultFont;
}
  
GString* HtmlFont::simple(GString* ftname, GString *content){
  GString *cont=new GString (content);
  GString *fontname=new GString(ftname);
  
  GBool b=gFalse;
  GBool i=gFalse;
  
  if (fontname){
  
  if (strstr(fontname->lowerCase()->getCString(),"bold")) b=gTrue;
 
  if (strstr(fontname->lowerCase()->getCString(),"italic")||
      strstr(fontname->lowerCase()->getCString(),"oblique")) i=gTrue;
  }
  if (b) {
    cont->insert(0,"<b>",3);
    cont->append("</b>",4);
  }
  if (i) {
    cont->insert(0,"<i>",3);
    cont->append("</i>",4);
  } 
  delete fontname;
  return cont;
}

HtmlFontAccu::HtmlFontAccu(){
 accu=new GVector<HtmlFont>();
}

HtmlFontAccu::~HtmlFontAccu(){
  if (accu) delete accu;
}

int HtmlFontAccu::AddFont(const HtmlFont& font){
 GVector<HtmlFont>::iterator i; 
 for (i=accu->begin();i!=accu->end();i++)
    if (font.isEqual(*i)) return (int)(i-(accu->begin())) ;
  accu->push_back(font);
  return (accu->size()-1);
}


GString* HtmlFontAccu::getCSStyle(int i,GString* content){
  GString *tmp=new GString("<span class=\"ft");
  GString *iStr=GString::IntToStr(i);
  tmp->append(iStr);
  tmp->append("\">");
  tmp->append(content);
  tmp->append("</span>");
  delete iStr;
  return tmp;
}

GString* HtmlFontAccu::CSStyle(int i){
   GString *tmp=new GString();
   GString *iStr=GString::IntToStr(i);

   GVector<HtmlFont>::iterator g=accu->begin();
   g+=i;
   HtmlFont font=*g;
   GString *Size=GString::IntToStr(font.getSize());
   GString *colorStr=font.getColor().toString();
   tmp->append(".ft");
   tmp->append(iStr);
   tmp->append("{font-size:");
   tmp->append(Size);
   tmp->append("px;font-family:");
   tmp->append(font.getFontName());
   tmp->append(";color:");
   tmp->append(colorStr);
   //   if (font.isItalic())
   //  tmp->append(";font-style:italic"); 
   // if (font.isBold())
   //    tmp->append(";font-weight:bold");
   tmp->append(";}");
   delete colorStr;
   delete iStr;
   delete Size;
   return tmp;
}
 


