/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Range
implements Serializable {
    Vector m_RangeStrings = new Vector();
    boolean b_Invert = false;
    boolean[] m_SelectFlags = null;
    int m_Upper = -1;

    public void setUpper(int n) {
        if (n > 0) {
            this.m_Upper = n;
            this.setFlags();
        }
    }

    public boolean getInvert() {
        return this.b_Invert;
    }

    public void setInvert(boolean bl) {
        this.b_Invert = bl;
    }

    public String getRanges() {
        String string = null;
        Enumeration enumeration = this.m_RangeStrings.elements();
        while (enumeration.hasMoreElements()) {
            string = string == null ? (String)enumeration.nextElement() : String.valueOf(string) + ',' + (String)enumeration.nextElement();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setRanges(String string) throws Exception {
        String string2;
        int n;
        Vector<String> vector = new Vector<String>(10);
        while ((n = string.indexOf(44)) >= 0) {
            string2 = string.substring(0, n).trim();
            if (string2.equals("") || !this.isValidRange(string2)) {
                throw new Exception("Invalid range list at " + string2 + string.substring(n));
            }
            vector.addElement(string2);
            string = string.substring(n + 1);
        }
        string2 = string.trim();
        if (string2.equals("") || !this.isValidRange(string2)) {
            throw new Exception("Invalid range list at " + string2);
        }
        vector.addElement(string2);
        if (vector.size() == 0) {
            throw new Exception("Empty range list");
        }
        this.m_RangeStrings = vector;
        if (this.m_Upper > 0) {
            this.setFlags();
        }
    }

    public boolean isInRange(int n) {
        if (this.m_SelectFlags == null) {
            return this.b_Invert;
        }
        if (this.b_Invert) {
            return !this.m_SelectFlags[n];
        }
        return this.m_SelectFlags[n];
    }

    public String toString() {
        if (this.m_RangeStrings.size() == 0) {
            return "Empty";
        }
        String string = "Strings: ";
        Enumeration enumeration = this.m_RangeStrings.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement() + " ";
        }
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + "Invert: " + this.b_Invert + "\n";
        if (this.m_SelectFlags != null) {
            String string2 = null;
            int n = 0;
            while (n < this.m_SelectFlags.length) {
                if (this.isInRange(n)) {
                    string2 = string2 == null ? "Cols: " + (n + 1) : String.valueOf(string2) + "," + (n + 1);
                }
                ++n;
            }
            if (string2 != null) {
                string = String.valueOf(string) + string2 + "\n";
            }
        }
        return string;
    }

    protected void setFlags() {
        this.m_SelectFlags = new boolean[this.m_Upper + 1];
        Enumeration enumeration = this.m_RangeStrings.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = this.rangeLower(string);
            int n2 = this.rangeUpper(string);
            int n3 = n;
            while (n3 <= this.m_Upper && n3 <= n2) {
                this.m_SelectFlags[n3] = true;
                ++n3;
            }
        }
    }

    protected int rangeSingle(String string) {
        if (string.toLowerCase().equals("first")) {
            return 0;
        }
        if (string.toLowerCase().equals("last")) {
            return this.m_Upper;
        }
        int n = Integer.parseInt(string) - 1;
        if (n < 0) {
            n = 0;
        }
        if (n > this.m_Upper) {
            n = this.m_Upper;
        }
        return n;
    }

    protected int rangeLower(String string) {
        int n = string.indexOf(45);
        if (n >= 0) {
            return Math.min(this.rangeLower(string.substring(0, n)), this.rangeLower(string.substring(n + 1)));
        }
        return this.rangeSingle(string);
    }

    protected int rangeUpper(String string) {
        int n = string.indexOf(45);
        if (n >= 0) {
            return Math.max(this.rangeUpper(string.substring(0, n)), this.rangeUpper(string.substring(n + 1)));
        }
        return this.rangeSingle(string);
    }

    protected boolean isValidRange(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(45);
        if (n >= 0) {
            return this.isValidRange(string.substring(0, n)) && this.isValidRange(string.substring(n + 1));
        }
        if (string.toLowerCase().equals("first")) {
            return true;
        }
        if (string.toLowerCase().equals("last")) {
            return true;
        }
        try {
            int n2 = Integer.parseInt(string);
            return n2 > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("Usage: Range <rangespec>");
            }
            Range range = new Range();
            range.setRanges(stringArray[0]);
            range.setUpper(10);
            range.setInvert(true);
            System.out.println("Input: " + stringArray[0] + "\n" + range.toString());
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

