/*
 * Decompiled with CFR 0.152.
 */
package jaws.evaluationPackage;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Random;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.AbstractClassifier;
import jaws.evaluationPackage.BatchClassifier;
import jaws.evaluationPackage.Classifier;
import jaws.evaluationPackage.DistributionClassifier;
import jaws.evaluationPackage.Drawable;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.evaluationPackage.UpdateableClassifier;

public class Evaluation {
    private static int k_MarginResolution = 500;
    private int m_numClasses;
    private int m_numFolds;
    private double m_incorrect = 0.0;
    private double m_correct = 0.0;
    private double m_unclassified = 0.0;
    private double m_missingClass = 0.0;
    private double m_withClass = 0.0;
    private double[][] m_confusionMatrix;
    private String[] m_classNames;
    private double[] m_classPriors;
    private double m_classPriorsSum;
    private boolean m_classIsNominal;
    private double[][] m_costMatrix;
    private double m_correctWithCost;
    private double m_incorrectWithCost;
    private double m_unclassifiedWithCost;
    private double m_withClassWithCost;
    private double m_sumErr;
    private double m_sumAbsErr;
    private double m_sumSqrErr;
    private double m_sumClass;
    private double m_sumSqrClass;
    private double m_sumPredicted;
    private double m_sumSqrPredicted;
    private double m_sumClassPredicted;
    private double m_sumPriorAbsErr;
    private double m_sumPriorSqrErr;
    private double m_sumKBInfo;
    private double[] m_MarginCounts;

    public void crossValidateModel(AbstractClassifier abstractClassifier, Instances instances, int n, String[] stringArray) throws Exception {
        this.crossValidateModel(abstractClassifier.getClass().getName(), instances, n, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void crossValidateModel(String string, Instances instances, int n, String[] stringArray) throws Exception {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
        }
        instances = new Instances(instances);
        instances.deleteStringAttributes();
        if (instances.classAttribute().isNominal()) {
            instances.stratify(n);
        }
        int n2 = 0;
        while (n2 < n) {
            AbstractClassifier abstractClassifier;
            try {
                abstractClassifier = (AbstractClassifier)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Exception("Can't find class with name " + string + '.');
            }
            if (stringArray != null) {
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            if (abstractClassifier instanceof OptionHandler) {
                try {
                    ((OptionHandler)((Object)abstractClassifier)).parseOptions(stringArray2);
                    Utils.checkForRemainingOptions(stringArray2);
                }
                catch (Exception exception) {
                    throw new Exception("Can't parse given options in " + "cross-validation!");
                }
            }
            Instances instances2 = instances.trainCV(n, n2);
            if (this.m_costMatrix != null) {
                instances2.applyCostMatrix(this.m_costMatrix);
            }
            this.setPriors(instances2);
            abstractClassifier.buildClassifier(instances2);
            Instances instances3 = instances.testCV(n, n2);
            this.evaluateModel(abstractClassifier, instances3);
            ++n2;
        }
        this.m_numFolds = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String evaluateModel(String string, String[] stringArray) throws Exception {
        try {
            AbstractClassifier abstractClassifier = (AbstractClassifier)Class.forName(string).newInstance();
            return Evaluation.evaluateModel(abstractClassifier, stringArray);
        }
        catch (Exception exception) {
            throw new Exception("Can't find class with name " + string + '.');
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the class name of a classifier");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            System.out.println(Evaluation.evaluateModel(string, stringArray));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String evaluateModel(AbstractClassifier var0, String[] var1_1) throws Exception {
        block44: {
            block52: {
                block50: {
                    block51: {
                        block47: {
                            block49: {
                                block48: {
                                    block46: {
                                        block45: {
                                            var4_2 = null;
                                            var8_3 = null;
                                            var9_4 = 1;
                                            var10_5 = 10;
                                            var11_6 = -1;
                                            var21_7 = false;
                                            var22_8 = false;
                                            var23_9 = false;
                                            var24_10 = false;
                                            var25_11 = false;
                                            var26_12 = false;
                                            var27_13 = false;
                                            var30_14 = new StringBuffer();
                                            var31_15 = null;
                                            var34_16 = new Random(1L);
                                            try {
                                                var25_11 = Utils.getFlag('g', var1_1);
                                                var24_10 = Utils.getFlag('p', var1_1);
                                                var27_13 = Utils.getFlag('r', var1_1);
                                                var18_17 = Utils.getOption('c', var1_1);
                                                if (var18_17.length() != 0) {
                                                    var11_6 = Integer.parseInt(var18_17);
                                                }
                                                if ((var15_18 = Utils.getOption('t', var1_1)).length() == 0) {
                                                    throw new Exception("No training file given.");
                                                }
                                                var32_19 = new BufferedInputStream(new FileInputStream(var15_18));
                                                var16_20 = Utils.getOption('T', var1_1);
                                                var2_21 = var0 instanceof UpdateableClassifier != false && var16_20.length() != 0 && var8_3 == null ? new Instances(var32_19, 1) : new Instances(var32_19);
                                                if (var11_6 != -1) {
                                                    var2_21.setClassIndex(var11_6 - 1);
                                                } else {
                                                    var2_21.setClassIndex(var2_21.numAttributes() - 1);
                                                }
                                                var5_22 = new Instances(var2_21);
                                                var5_22.deleteStringAttributes();
                                                var19_23 = Utils.getOption('s', var1_1);
                                                if (var19_23.length() != 0) {
                                                    var9_4 = Integer.parseInt(var19_23);
                                                }
                                                if ((var20_24 = Utils.getOption('x', var1_1)).length() != 0) {
                                                    var10_5 = Integer.parseInt(var20_24);
                                                }
                                                if ((var17_25 = Utils.getOption('m', var1_1)).length() != 0) {
                                                    var8_3 = var2_21.readCostMatrix(new FileInputStream(var17_25));
                                                }
                                                var21_7 = Utils.getFlag('i', var1_1);
                                                var22_8 = Utils.getFlag('o', var1_1);
                                                var23_9 = Utils.getFlag('v', var1_1);
                                                var26_12 = Utils.getFlag('e', var1_1);
                                                if (var11_6 > var2_21.numAttributes()) {
                                                    throw new Exception("Index of class attribute too large.");
                                                }
                                                if (!(var0 instanceof Drawable) && var25_11) {
                                                    throw new Exception("Classifier is not drawable!");
                                                }
                                                if (var1_1 != null) {
                                                    var31_15 = new String[var1_1.length];
                                                    System.arraycopy(var1_1, 0, var31_15, 0, var1_1.length);
                                                }
                                                if (var0 instanceof OptionHandler) {
                                                    ((OptionHandler)var0).parseOptions(var1_1);
                                                }
                                                Utils.checkForRemainingOptions(var1_1);
                                            }
                                            catch (Exception var35_26) {
                                                throw new Exception('\n' + var35_26.getMessage() + Evaluation.makeOptionString(var0));
                                            }
                                            if (var8_3 == null) {
                                                var28_29 = new Evaluation(var5_22);
                                                var29_30 = new Evaluation(var5_22);
                                            } else {
                                                var28_29 = new Evaluation(var5_22, var8_3);
                                                var29_30 = new Evaluation(var5_22, var8_3);
                                            }
                                            if (!(var0 instanceof UpdateableClassifier) || var16_20.length() == 0 || var8_3 != null) break block45;
                                            var28_29.setPriors(var5_22);
                                            var29_30.setPriors(var5_22);
                                            var0.buildClassifier(var5_22);
                                            var7_31 = new Instance(var5_22.numAttributes());
                                            var7_31.setDataset(var5_22);
                                            if (true) ** GOTO lbl92
                                        }
                                        var3_33 = new Instances(var5_22);
                                        if (var8_3 != null) {
                                            var3_33.applyCostMatrix(var8_3);
                                        }
                                        var28_29.setPriors(var3_33);
                                        var29_30.setPriors(var3_33);
                                        var0.buildClassifier(var3_33);
                                        break block46;
                                        do {
                                            var35_27 = 0;
                                            var36_32 = 0;
                                            while (var36_32 < var2_21.numAttributes()) {
                                                if (!var2_21.attribute(var36_32).isString()) {
                                                    var7_31.setValue(var35_27, var2_21.instance(0).value(var36_32));
                                                    ++var35_27;
                                                }
                                                ++var36_32;
                                            }
                                            var28_29.updatePriors(var7_31);
                                            var29_30.updatePriors(var7_31);
                                            ((UpdateableClassifier)var0).updateClassifier(var7_31);
                                            var2_21.delete(0);
lbl92:
                                            // 2 sources

                                        } while (var2_21.readInstance(var32_19));
                                    }
                                    if (var24_10) {
                                        return Evaluation.printClassifications(var0, var5_22, var16_20, var11_6);
                                    }
                                    if (var25_11) {
                                        return ((Drawable)var0).graph();
                                    }
                                    if (!var22_8 && !var27_13) {
                                        var30_14.append("\n" + var0.toString() + "\n");
                                    }
                                    if (!var26_12 && (var16_20.length() != 0 || var23_9)) break block47;
                                    if (!(var0 instanceof UpdateableClassifier) || var16_20.length() == 0 || var8_3 != null) break block48;
                                    var32_19 = new BufferedInputStream(new FileInputStream(var15_18));
                                    var2_21 = new Instances(var32_19, 1);
                                    if (var11_6 != -1) {
                                        var2_21.setClassIndex(var11_6 - 1);
                                    } else {
                                        var2_21.setClassIndex(var2_21.numAttributes() - 1);
                                    }
                                    var7_31 = new Instance(var5_22.numAttributes());
                                    var7_31.setDataset(var5_22);
                                    if (true) ** GOTO lbl126
                                }
                                var28_29.evaluateModel(var0, var5_22);
                                break block49;
                                do {
                                    var35_27 = 0;
                                    var36_32 = 0;
                                    while (var36_32 < var2_21.numAttributes()) {
                                        if (!var2_21.attribute(var36_32).isString()) {
                                            var7_31.setValue(var35_27, var2_21.instance(0).value(var36_32));
                                            ++var35_27;
                                        }
                                        ++var36_32;
                                    }
                                    var28_29.evaluateModelOnce((Classifier)var0, var7_31);
                                    var2_21.delete(0);
lbl126:
                                    // 2 sources

                                } while (var2_21.readInstance(var32_19));
                            }
                            if (var27_13) {
                                return var28_29.toCumulativeMarginDistributionString();
                            }
                            var30_14.append(var28_29.toSummaryString("\n=== Error on training" + " data ===\n"));
                            if (var2_21.classAttribute().isNominal()) {
                                var30_14.append("\n\n" + var28_29.toMatrixString());
                                if (var21_7) {
                                    var30_14.append("\n\n" + var28_29.toInformationRetrievalStatisticsString() + "\n");
                                }
                            }
                        }
                        if (var16_20.length() == 0) break block50;
                        try {
                            var33_34 = new BufferedInputStream(new FileInputStream(var16_20));
                        }
                        catch (Exception var35_28) {
                            throw new Exception("Can't open file " + var35_28.getMessage() + '.');
                        }
                        if (!(var0 instanceof Classifier)) break block51;
                        var4_2 = new Instances(var33_34, 1);
                        if (var11_6 != -1) {
                            var4_2.setClassIndex(var11_6 - 1);
                        } else {
                            var4_2.setClassIndex(var2_21.numAttributes() - 1);
                        }
                        var7_31 = new Instance(var5_22.numAttributes());
                        var7_31.setDataset(var5_22);
                        if (true) ** GOTO lbl186
                    }
                    if (var0 instanceof BatchClassifier) {
                        var4_2 = new Instances(var33_34);
                        if (var11_6 != -1) {
                            var4_2.setClassIndex(var11_6 - 1);
                        } else {
                            var4_2.setClassIndex(var2_21.numAttributes() - 1);
                        }
                        var4_2.deleteStringAttributes();
                        var29_30.evaluateModel(var0, var4_2);
                    }
                    break block52;
                }
                var34_16.setSeed(var9_4);
                var5_22.randomize(var34_16);
                var29_30.crossValidateModel(var0.getClass().getName(), var5_22, var10_5, var31_15);
                if (var2_21.classAttribute().isNumeric()) {
                    var30_14.append("\n\n" + var29_30.toSummaryString("=== Cross-validation ===\n"));
                    break block44;
                } else {
                    var30_14.append("\n\n" + var29_30.toSummaryString("=== Stratified " + "cross-validation ===\n"));
                }
                break block44;
                do {
                    var35_27 = 0;
                    var36_32 = 0;
                    while (var36_32 < var4_2.numAttributes()) {
                        if (!var4_2.attribute(var36_32).isString()) {
                            var7_31.setValue(var35_27, var4_2.instance(0).value(var36_32));
                            ++var35_27;
                        }
                        ++var36_32;
                    }
                    var29_30.evaluateModelOnce((Classifier)var0, var7_31);
                    var4_2.delete(0);
lbl186:
                    // 2 sources

                } while (var4_2.readInstance(var33_34));
            }
            var30_14.append("\n\n" + var29_30.toSummaryString("=== Error on test data ===\n"));
        }
        if (var2_21.classAttribute().isNominal()) {
            var30_14.append("\n\n" + var29_30.toMatrixString());
            if (var21_7) {
                var30_14.append("\n\n" + var29_30.toInformationRetrievalStatisticsString() + "\n");
            }
        }
        return var30_14.toString();
    }

    public void evaluateModel(AbstractClassifier abstractClassifier, Instances instances) throws Exception {
        int n = 0;
        while (n < instances.numAttributes()) {
            if (instances.attribute(n).isString()) {
                throw new Exception("Can't evaluate on data with " + "string attributes!");
            }
            ++n;
        }
        if (abstractClassifier instanceof BatchClassifier) {
            double[] dArray = ((BatchClassifier)abstractClassifier).classifyInstances(instances);
            if (this.m_classIsNominal) {
                n = 0;
                while (n < instances.numInstances()) {
                    this.updateStatsForClassifier(this.makeDistribution(dArray[n]), instances.instance(n));
                    ++n;
                }
            } else {
                n = 0;
                while (n < instances.numInstances()) {
                    this.updateStatsForPredictor(dArray[n], instances.instance(n));
                    ++n;
                }
            }
        } else {
            n = 0;
            while (n < instances.numInstances()) {
                this.evaluateModelOnce((Classifier)abstractClassifier, instances.instance(n));
                ++n;
            }
        }
    }

    public void evaluateModelOnce(Classifier classifier, Instance instance) throws Exception {
        Instance instance2 = new Instance(instance);
        instance2.setDataset(instance.dataset());
        instance2.setClassMissing();
        int n = 0;
        while (n < instance2.numAttributes()) {
            if (instance2.attribute(n).isString()) {
                throw new Exception("Can't evaluate on data with string " + "attributes!");
            }
            ++n;
        }
        if (this.m_classIsNominal) {
            if (classifier instanceof DistributionClassifier) {
                this.updateStatsForClassifier(((DistributionClassifier)classifier).distributionForInstance(instance2), instance);
            } else {
                this.updateStatsForClassifier(this.makeDistribution(classifier.classifyInstance(instance2)), instance);
            }
        } else {
            this.updateStatsForPredictor(classifier.classifyInstance(instance2), instance);
        }
    }

    public void evaluateModelOnce(double d, Instance instance) throws Exception {
        if (this.m_classIsNominal) {
            this.updateStatsForClassifier(this.makeDistribution(d), instance);
        } else {
            this.updateStatsForPredictor(d, instance);
        }
    }

    public final double errorRate() {
        if (!this.m_classIsNominal) {
            return Math.sqrt(this.m_sumSqrErr / this.m_withClass);
        }
        if (this.m_costMatrix == null) {
            return this.m_incorrect / this.m_withClass;
        }
        return this.m_incorrectWithCost / this.m_withClassWithCost;
    }

    public final double correlationCoefficient() throws Exception {
        if (this.m_classIsNominal) {
            throw new Exception("Can't compute correlation coefficient: " + "class is nominal!");
        }
        double d = 0.0;
        double d2 = this.m_sumSqrClass - this.m_sumClass * this.m_sumClass / this.m_withClass;
        double d3 = this.m_sumSqrPredicted - this.m_sumPredicted * this.m_sumPredicted / this.m_withClass;
        double d4 = this.m_sumClassPredicted - this.m_sumClass * this.m_sumPredicted / this.m_withClass;
        d = d2 * d3 == 0.0 ? 1.0 : d4 / Math.sqrt(d2 * d3);
        return d;
    }

    public final double meanAbsoluteError() {
        return this.m_sumAbsErr / this.m_withClass;
    }

    public final double meanPriorAbsoluteError() {
        return this.m_sumPriorAbsErr / this.m_withClass;
    }

    public final double relativeAbsoluteError() throws Exception {
        return 100.0 * this.meanAbsoluteError() / this.meanPriorAbsoluteError();
    }

    public final double rootMeanSquaredError() {
        return Math.sqrt(this.m_sumSqrErr / this.m_withClass);
    }

    public final double rootMeanPriorSquaredError() {
        return Math.sqrt(this.m_sumPriorSqrErr / this.m_withClass);
    }

    public final double rootRelativeSquaredError() {
        return 100.0 * this.rootMeanSquaredError() / this.rootMeanPriorSquaredError();
    }

    public final double priorEntropy() throws Exception {
        if (!this.m_classIsNominal) {
            throw new Exception("Can't compute entropy of class prior: " + "class numeric!");
        }
        double d = 0.0;
        int n = 0;
        while (n < this.m_numClasses) {
            d -= this.m_classPriors[n] / this.m_classPriorsSum * Utils.log2(this.m_classPriors[n] / this.m_classPriorsSum);
            ++n;
        }
        return d;
    }

    public final double KBTotalInformation() throws Exception {
        if (!this.m_classIsNominal) {
            throw new Exception("Can't compute K&B Info score: " + "class numeric!");
        }
        return this.m_sumKBInfo;
    }

    public final double KBInformation() throws Exception {
        if (!this.m_classIsNominal) {
            throw new Exception("Can't compute K&B Info score: " + "class numeric!");
        }
        return this.m_sumKBInfo / this.m_withClass;
    }

    public final double KBRelative() throws Exception {
        if (!this.m_classIsNominal) {
            throw new Exception("Can't compute K&B Info score: " + "class numeric!");
        }
        return 100.0 * this.KBInformation() / this.priorEntropy();
    }

    public String toCumulativeMarginDistributionString() throws Exception {
        if (!this.m_classIsNominal) {
            throw new Exception("Class must be nominal for margin distributions");
        }
        String string = "";
        double d = 0.0;
        int n = 0;
        while (n <= k_MarginResolution) {
            if (this.m_MarginCounts[n] != 0.0) {
                double d2 = (double)n * 2.0 / (double)k_MarginResolution - 1.0;
                string = string + Utils.doubleToString(d2, 7, 3) + ' ' + Utils.doubleToString((d += this.m_MarginCounts[n]) * 100.0 / this.m_withClass, 7, 3) + '\n';
            } else if (n == 0) {
                string = Utils.doubleToString(-1.0, 7, 3) + ' ' + Utils.doubleToString(0.0, 7, 3) + '\n';
            }
            ++n;
        }
        return string;
    }

    public String toInformationRetrievalStatisticsString() throws Exception {
        if (this.m_numClasses != 2) {
            throw new Exception("Can only compute IR statistics for " + "2-class problems!");
        }
        return this.toInformationRetrievalStatisticsString("=== IR " + "statistics ===\n");
    }

    public String toInformationRetrievalStatisticsString(String string) throws Exception {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_numClasses != 2) {
            throw new Exception("Can only compute IR statistics " + "for 2-class problems!");
        }
        if (Utils.gr(this.m_confusionMatrix[1][1] + this.m_confusionMatrix[1][0], this.m_confusionMatrix[0][0] + this.m_confusionMatrix[0][1])) {
            n2 = 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        double d = this.m_confusionMatrix[n][n] / (this.m_confusionMatrix[n][n] + this.m_confusionMatrix[n2][n]);
        double d2 = this.m_confusionMatrix[n][n] / (this.m_confusionMatrix[n][n] + this.m_confusionMatrix[n][n2]);
        double d3 = 2.0 * d * d2 / (d + d2);
        stringBuffer.append("Precision " + Utils.doubleToString(d, 7, 2) + "\n");
        stringBuffer.append("Recall    " + Utils.doubleToString(d2, 7, 2) + "\n");
        stringBuffer.append("F-measure " + Utils.doubleToString(d3, 7, 2));
        return stringBuffer.toString();
    }

    public String toSummaryString() {
        return this.toSummaryString("=== Summary ===\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toSummaryString(String string) {
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = (int)Math.max(Math.log(this.m_withClass + 1.0), Math.log(this.m_missingClass + 1.0)) + 4;
        stringBuffer.append(string + "\n");
        try {
            if (this.m_withClass > 0.0) {
                if (this.m_classIsNominal) {
                    stringBuffer.append("Correctly Classified Instances               ");
                    stringBuffer.append(Utils.doubleToString(this.m_correct, n, 4) + Utils.doubleToString(100.0 * this.m_correct / this.m_withClass, 15, 4) + " %\n");
                    stringBuffer.append("Incorrectly Classified Instances             ");
                    stringBuffer.append(Utils.doubleToString(this.m_incorrect, n, 4) + Utils.doubleToString(100.0 * this.m_incorrect / this.m_withClass, 15, 4) + " %\n");
                    stringBuffer.append("Unclassified Classified Instances            ");
                    stringBuffer.append(Utils.doubleToString(this.m_unclassified, n, 4) + Utils.doubleToString(100.0 * this.m_unclassified / this.m_withClass, 15, 4) + " %\n");
                    if (this.m_costMatrix != null) {
                        stringBuffer.append("Correctly Classified Instances With Cost     ");
                        stringBuffer.append(Utils.doubleToString(this.m_correctWithCost, n, 4) + Utils.doubleToString(100.0 * this.m_correctWithCost / this.m_withClassWithCost, 15, 4) + " %\n");
                        stringBuffer.append("Incorrectly Classified Instances With Cost   ");
                        stringBuffer.append(Utils.doubleToString(this.m_incorrectWithCost, n, 4) + Utils.doubleToString(100.0 * this.m_incorrectWithCost / this.m_withClassWithCost, 15, 4) + " %\n");
                        stringBuffer.append("Unclassified Classified Instances With Cost  ");
                        stringBuffer.append(Utils.doubleToString(this.m_unclassifiedWithCost, n, 4) + Utils.doubleToString(100.0 * this.m_unclassifiedWithCost / this.m_withClassWithCost, 15, 4) + " %\n");
                    }
                    stringBuffer.append("K&B Relative Info Score                      ");
                    stringBuffer.append(Utils.doubleToString(this.KBRelative(), 15 + n, 4) + " %\n");
                    stringBuffer.append("K&B Information Score                        ");
                    stringBuffer.append(Utils.doubleToString(this.KBTotalInformation(), n, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.KBInformation(), 10, 4) + " bits/instance\n");
                    stringBuffer.append("Mean absolute error                          ");
                    stringBuffer.append(Utils.doubleToString(this.meanAbsoluteError(), 15 + n, 4) + "\n");
                    stringBuffer.append("Root mean squared error                      ");
                    stringBuffer.append(Utils.doubleToString(this.rootMeanSquaredError(), 15 + n, 4) + "\n");
                    stringBuffer.append("Relative absolute error                      ");
                    stringBuffer.append(Utils.doubleToString(this.relativeAbsoluteError(), 15 + n, 4) + " %\n");
                    stringBuffer.append("Root relative squared error                  ");
                    stringBuffer.append(Utils.doubleToString(this.rootRelativeSquaredError(), 15 + n, 4) + " %\n");
                } else {
                    stringBuffer.append("Mean absolute error                          ");
                    stringBuffer.append(Utils.doubleToString(this.meanAbsoluteError(), 15 + n, 4) + "\n");
                    stringBuffer.append("Root mean squared error                      ");
                    stringBuffer.append(Utils.doubleToString(this.rootMeanSquaredError(), 15 + n, 4) + "\n");
                    stringBuffer.append("Correlation coefficient                      ");
                    stringBuffer.append(Utils.doubleToString(this.correlationCoefficient(), 15 + n, 4) + "\n");
                    stringBuffer.append("Relative absolute error                      ");
                    stringBuffer.append(Utils.doubleToString(this.relativeAbsoluteError(), 15 + n, 4) + " %\n");
                    stringBuffer.append("Root relative squared error                  ");
                    stringBuffer.append(Utils.doubleToString(this.rootRelativeSquaredError(), 15 + n, 4) + " %\n");
                }
            }
            stringBuffer.append("Total Number of Instances                    ");
            stringBuffer.append(Utils.doubleToString(this.m_withClass, n, 4));
            if (this.m_costMatrix != null) {
                stringBuffer.append("\n" + "Total Number of Instances With Cost          ");
                stringBuffer.append(Utils.doubleToString(this.m_withClassWithCost, n, 4));
            }
            if (!(this.m_missingClass > 0.0)) return stringBuffer.toString();
            stringBuffer.append("\nIgnored Class Unknown Instances            ");
            stringBuffer.append(Utils.doubleToString(this.m_missingClass, n, 4));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Arggh - Must be a bug in Evaluation class");
        }
        return stringBuffer.toString();
    }

    public String toMatrixString() throws Exception {
        if (!this.m_classIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        return this.toMatrixString("=== Confusion Matrix ===\n");
    }

    public String toMatrixString(String string) throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        if (!this.m_classIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.m_numClasses) {
            n = 0;
            while (n < this.m_numClasses) {
                if (this.m_confusionMatrix[n2][n] > d) {
                    d = this.m_confusionMatrix[n2][n];
                }
                ++n;
            }
            ++n2;
        }
        int n3 = 1 + Math.max((int)(Math.log(d) / Math.log(10.0) + 3.0), (int)(Math.log(this.m_numClasses) / Math.log(cArray.length)));
        stringBuffer.append(string + "\n");
        n2 = 0;
        while (n2 < this.m_numClasses) {
            stringBuffer.append(" " + this.num2ShortID(n2, cArray, n3));
            ++n2;
        }
        stringBuffer.append("   <-- classified as\n");
        n2 = 0;
        while (n2 < this.m_numClasses) {
            n = 0;
            while (n < this.m_numClasses) {
                stringBuffer.append(" " + Utils.doubleToString(this.m_confusionMatrix[n2][n], n3, 2));
                ++n;
            }
            stringBuffer.append(" | " + this.num2ShortID(n2, cArray, n3) + " = " + this.m_classNames[n2]);
            if (n2 != this.m_numClasses - 1) {
                stringBuffer.append("\n");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setPriors(Instances instances) throws Exception {
        if (!this.m_classIsNominal) {
            int n = 0;
            while (n < this.m_numClasses) {
                this.m_classPriors[n] = 1.0E-4;
                ++n;
            }
            this.m_classPriorsSum = (double)this.m_numClasses * 1.0E-4;
            n = 0;
            while (n < instances.numInstances()) {
                if (!instances.instance(n).classIsMissing()) {
                    this.m_classPriors[0] = this.m_classPriors[0] + instances.instance(n).classValue() * instances.instance(n).weight();
                    this.m_classPriorsSum += instances.instance(n).weight();
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_numClasses) {
                this.m_classPriors[n] = 1.0;
                ++n;
            }
            this.m_classPriorsSum = this.m_numClasses;
            n = 0;
            while (n < instances.numInstances()) {
                if (!instances.instance(n).classIsMissing()) {
                    int n2 = (int)instances.instance(n).classValue();
                    this.m_classPriors[n2] = this.m_classPriors[n2] + instances.instance(n).weight();
                    this.m_classPriorsSum += instances.instance(n).weight();
                }
                ++n;
            }
        }
    }

    public void updatePriors(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (!this.m_classIsNominal) {
                this.m_classPriors[0] = this.m_classPriors[0] + instance.classValue() * instance.weight();
                this.m_classPriorsSum += instance.weight();
            } else {
                int n = (int)instance.classValue();
                this.m_classPriors[n] = this.m_classPriors[n] + instance.weight();
                this.m_classPriorsSum += instance.weight();
            }
        }
    }

    public boolean equals(Evaluation evaluation) {
        if (this.m_classIsNominal != evaluation.m_classIsNominal) {
            return false;
        }
        if (this.m_numClasses != evaluation.m_numClasses) {
            return false;
        }
        if (this.m_incorrect != evaluation.m_incorrect) {
            return false;
        }
        if (this.m_correct != evaluation.m_correct) {
            return false;
        }
        if (this.m_unclassified != evaluation.m_unclassified) {
            return false;
        }
        if (this.m_missingClass != evaluation.m_missingClass) {
            return false;
        }
        if (this.m_withClass != evaluation.m_withClass) {
            return false;
        }
        if (this.m_sumErr != evaluation.m_sumErr) {
            return false;
        }
        if (this.m_sumAbsErr != evaluation.m_sumAbsErr) {
            return false;
        }
        if (this.m_sumSqrErr != evaluation.m_sumSqrErr) {
            return false;
        }
        if (this.m_sumClass != evaluation.m_sumClass) {
            return false;
        }
        if (this.m_sumSqrClass != evaluation.m_sumSqrClass) {
            return false;
        }
        if (this.m_sumPredicted != evaluation.m_sumPredicted) {
            return false;
        }
        if (this.m_sumSqrPredicted != evaluation.m_sumSqrPredicted) {
            return false;
        }
        if (this.m_sumClassPredicted != evaluation.m_sumClassPredicted) {
            return false;
        }
        if (this.m_classIsNominal) {
            int n = 0;
            while (n < this.m_numClasses) {
                int n2 = 0;
                while (n2 < this.m_numClasses) {
                    if (this.m_confusionMatrix[n][n2] != evaluation.m_confusionMatrix[n][n2]) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String printClassifications(AbstractClassifier var0, Instances var1_1, String var2_2, int var3_3) throws Exception {
        block29: {
            var4_4 = new StringBuffer();
            if (var2_2.length() == 0) return var4_4.toString();
            var5_5 = null;
            try {
                var5_5 = new BufferedInputStream(new FileInputStream(var2_2));
            }
            catch (Exception var6_6) {
                throw new Exception("Can't open file " + var6_6.getMessage() + '.');
            }
            if (!(var0 instanceof Classifier)) break block29;
            var6_7 = new Instances(var5_5, 1);
            if (var3_3 != -1) {
                var6_7.setClassIndex(var3_3 - 1);
            } else {
                var6_7.setClassIndex(var6_7.numAttributes() - 1);
            }
            var7_9 = new Instance(var1_1.numAttributes());
            var7_9.setDataset(var1_1);
            var8_11 = 0;
            if (true) ** GOTO lbl73
        }
        var6_8 = new Instances(var5_5);
        if (var3_3 != -1) {
            var6_8.setClassIndex(var3_3 - 1);
        } else {
            var6_8.setClassIndex(var6_8.numAttributes() - 1);
        }
        var6_8.deleteStringAttributes();
        var7_10 = ((BatchClassifier)var0).classifyInstances(var6_8);
        var8_12 = 0;
        if (true) ** GOTO lbl92
        do {
            var9_13 = 0;
            var10_15 = 0;
            while (var10_15 < var6_7.numAttributes()) {
                if (!var6_7.attribute(var10_15).isString()) {
                    var7_9.setValue(var9_13, var6_7.instance(0).value(var10_15));
                    ++var9_13;
                }
                ++var10_15;
            }
            var10_14 = new Instance(var7_9);
            var10_14.setDataset(var7_9.dataset());
            var11_16 = ((Classifier)var0).classifyInstance(var10_14);
            if (var6_7.classAttribute().isNumeric()) {
                if (Instance.isMissingValue(var11_16)) {
                    var4_4.append(var8_11 + " missing ");
                } else {
                    var4_4.append(var8_11 + " " + var11_16 + " ");
                }
                if (var7_9.classIsMissing()) {
                    var4_4.append("missing\n");
                } else {
                    var4_4.append(var7_9.classValue() + "\n");
                }
            } else {
                if (Instance.isMissingValue(var11_16)) {
                    var4_4.append(var8_11 + " missing ");
                } else {
                    var4_4.append(var8_11 + " " + var6_7.classAttribute().value((int)var11_16) + " ");
                }
                if (var0 instanceof DistributionClassifier) {
                    if (Instance.isMissingValue(var11_16)) {
                        var4_4.append("missing ");
                    } else {
                        var4_4.append(((DistributionClassifier)var0).distributionForInstance(var10_14)[(int)var11_16] + " ");
                    }
                }
                var4_4.append(var7_9.classLabel() + "\n");
            }
            var6_7.delete(0);
            ++var8_11;
lbl73:
            // 2 sources

        } while (var6_7.readInstance(var5_5));
        return var4_4.toString();
        do {
            if (var6_8.classAttribute().isNumeric()) {
                if (Instance.isMissingValue(var7_10[var8_12])) {
                    var4_4.append(var8_12 + " missing\n");
                } else {
                    var4_4.append(var8_12 + " " + var7_10[var8_12] + "\n");
                }
            } else if (Instance.isMissingValue(var7_10[var8_12])) {
                var4_4.append(var8_12 + " missing\n");
            } else {
                var4_4.append(var8_12 + " " + var6_8.classAttribute().value((int)var7_10[var8_12]) + "\n");
            }
            ++var8_12;
lbl92:
            // 2 sources

        } while (var8_12 < var6_8.numInstances());
        return var4_4.toString();
    }

    private static final String makeOptionString(AbstractClassifier abstractClassifier) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nGeneral options:\n\n");
        stringBuffer.append("-t <name of training file>\n");
        stringBuffer.append("\tThe name of the file with the training data.\n");
        stringBuffer.append("-T <name of test file>\n");
        stringBuffer.append("\tThe name of the file with the test data. If\n");
        stringBuffer.append("\tthis name is missing, a cross-validation on\n");
        stringBuffer.append("\tthe training data is performed.\n");
        stringBuffer.append("-c <class index>\n");
        stringBuffer.append("\tThe number of the attribute to be used as the\n");
        stringBuffer.append("\tclass.\n");
        stringBuffer.append("-x <number of folds>\n");
        stringBuffer.append("\tThe number of folds in case a cross-validation\n");
        stringBuffer.append("\tis performed.\n");
        stringBuffer.append("-s <random number seed>\n");
        stringBuffer.append("\tThe random number seed for cross-validation.\n");
        stringBuffer.append("-m <name of file with cost matrix>\n");
        stringBuffer.append("\tThe name of a file that contains a cost matrix\n");
        stringBuffer.append("\tfor the learning problem being considered.\n");
        stringBuffer.append("-o\n");
        stringBuffer.append("\tIf this flag is set, only statistics are\n");
        stringBuffer.append("\tprinted, not the classifier itself.\n");
        stringBuffer.append("-i\n");
        stringBuffer.append("\tOutputs information retrieval statistics for\n");
        stringBuffer.append("\ttwo-class problems.\n");
        stringBuffer.append("-r\n");
        stringBuffer.append("\tOutputs cumulative margin distribution.\n");
        stringBuffer.append("-p\n");
        stringBuffer.append("\tOutputs the predicted value for each test\n");
        stringBuffer.append("\tinstance.\n");
        stringBuffer.append("-e\n");
        stringBuffer.append("\tOutputs statistics for the training data even\n");
        stringBuffer.append("\tif test data is provided.\n");
        stringBuffer.append("-v\n");
        stringBuffer.append("\tOutputs no statistics for the training data even\n");
        stringBuffer.append("\tif no test data is provided.\n");
        if (abstractClassifier instanceof Drawable) {
            stringBuffer.append("-g\n");
            stringBuffer.append("\tOutputs a description of the classifier as a\n");
            stringBuffer.append("\tgraph.\n");
        }
        if (abstractClassifier instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + abstractClassifier.getClass().getName() + ":\n\n");
            Enumeration enumeration = ((OptionHandler)((Object)abstractClassifier)).listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private final String num2ShortID(int n, char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            cArray2[n3] = cArray[n % cArray.length];
            if ((n = n / cArray.length - 1) < 0) break;
            --n3;
        }
        --n3;
        while (n3 >= 0) {
            cArray2[n3] = 32;
            --n3;
        }
        return new String(cArray2);
    }

    private final double[] makeDistribution(double d) {
        double[] dArray = new double[this.m_numClasses];
        if (Instance.isMissingValue(d)) {
            return dArray;
        }
        if (this.m_classIsNominal) {
            dArray[(int)d] = 1.0;
        } else {
            dArray[0] = d;
        }
        return dArray;
    }

    private final void updateStatsForClassifier(double[] dArray, Instance instance) throws Exception {
        int n = (int)instance.classValue();
        double d = 1.0;
        if (!instance.classIsMissing()) {
            this.m_withClass += instance.weight();
            if (this.m_costMatrix != null) {
                d = this.m_costMatrix[n][Utils.maxIndex(this.m_costMatrix[n])];
            }
            this.m_withClassWithCost += d * instance.weight();
            this.updateMargins(dArray, n, instance.weight());
            int n2 = -1;
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < this.m_numClasses) {
                if (dArray[n3] > d2) {
                    n2 = n3;
                    d2 = dArray[n3];
                }
                ++n3;
            }
            if (n2 < 0) {
                this.m_unclassified += instance.weight();
                if (this.m_costMatrix != null) {
                    this.m_unclassifiedWithCost += d * instance.weight();
                }
                return;
            }
            double d3 = dArray[n];
            double d4 = this.m_classPriors[n] / this.m_classPriorsSum;
            this.m_sumKBInfo = d3 >= d4 ? (this.m_sumKBInfo += (Utils.log2(d3) - Utils.log2(d4)) * instance.weight()) : (this.m_sumKBInfo -= (Utils.log2(1.0 - d3) - Utils.log2(1.0 - d4)) * instance.weight());
            this.updateNumericScores(dArray, this.makeDistribution(instance.classValue()), instance.weight());
            double[] dArray2 = this.m_confusionMatrix[n];
            int n4 = n2;
            dArray2[n4] = dArray2[n4] + instance.weight();
            if (n2 != n) {
                this.m_incorrect += instance.weight();
                if (this.m_costMatrix != null) {
                    this.m_incorrectWithCost += d * instance.weight();
                }
            } else {
                if (this.m_costMatrix != null) {
                    this.m_correctWithCost += d * instance.weight();
                }
                this.m_correct += instance.weight();
            }
        } else {
            this.m_missingClass += instance.weight();
        }
    }

    private final void updateStatsForPredictor(double d, Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.m_withClass += instance.weight();
            if (Instance.isMissingValue(d)) {
                return;
            }
            this.m_sumClass += instance.weight() * instance.classValue();
            this.m_sumSqrClass += instance.weight() * instance.classValue() * instance.classValue();
            this.m_sumClassPredicted += instance.weight() * instance.classValue() * d;
            this.m_sumPredicted += d;
            this.m_sumSqrPredicted += d * d;
            this.updateNumericScores(this.makeDistribution(d), this.makeDistribution(instance.classValue()), instance.weight());
        } else {
            this.m_missingClass += instance.weight();
        }
    }

    private final void updateMargins(double[] dArray, int n, double d) {
        int n2;
        double d2 = dArray[n];
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < this.m_numClasses) {
            if (n3 != n && dArray[n3] > d3) {
                d3 = dArray[n3];
            }
            ++n3;
        }
        double d4 = d2 - d3;
        int n4 = n2 = (int)((d4 + 1.0) / 2.0 * (double)k_MarginResolution);
        this.m_MarginCounts[n4] = this.m_MarginCounts[n4] + d;
    }

    private final void updateNumericScores(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = 0;
        while (n < this.m_numClasses) {
            double d7 = dArray[n] - dArray2[n];
            d2 += d7;
            d3 += Math.abs(d7);
            d4 += d7 * d7;
            d7 = this.m_classPriors[n] / this.m_classPriorsSum - dArray2[n];
            d5 += Math.abs(d7);
            d6 += d7 * d7;
            ++n;
        }
        this.m_sumErr += d * d2 / (double)this.m_numClasses;
        this.m_sumAbsErr += d * d3 / (double)this.m_numClasses;
        this.m_sumSqrErr += d * d4 / (double)this.m_numClasses;
        this.m_sumPriorAbsErr += d * d5 / (double)this.m_numClasses;
        this.m_sumPriorSqrErr += d * d6 / (double)this.m_numClasses;
    }

    public Evaluation(Instances instances) throws Exception {
        this.m_numClasses = instances.numClasses();
        this.m_numFolds = 1;
        this.m_costMatrix = null;
        this.m_classIsNominal = instances.classAttribute().isNominal();
        if (this.m_classIsNominal) {
            this.m_confusionMatrix = new double[this.m_numClasses][this.m_numClasses];
            this.m_classNames = new String[this.m_numClasses];
            int n = 0;
            while (n < this.m_numClasses) {
                this.m_classNames[n] = instances.classAttribute().value(n);
                ++n;
            }
        }
        this.m_classPriors = new double[this.m_numClasses];
        this.m_classPriorsSum = 0.0;
        this.setPriors(instances);
        this.m_sumSqrPredicted = 0.0;
        this.m_sumPredicted = 0.0;
        this.m_sumPriorAbsErr = 0.0;
        this.m_sumKBInfo = 0.0;
        this.m_sumPriorSqrErr = 0.0;
        this.m_sumClassPredicted = 0.0;
        this.m_sumSqrClass = 0.0;
        this.m_sumClass = 0.0;
        this.m_sumSqrErr = 0.0;
        this.m_sumAbsErr = 0.0;
        this.m_sumErr = 0.0;
        this.m_MarginCounts = new double[k_MarginResolution + 1];
    }

    public Evaluation(Instances instances, double[][] dArray) throws Exception {
        this.m_numClasses = instances.numClasses();
        this.m_confusionMatrix = new double[this.m_numClasses][this.m_numClasses];
        this.m_classNames = new String[this.m_numClasses];
        this.m_numFolds = 1;
        int n = 0;
        while (n < this.m_numClasses) {
            this.m_classNames[n] = instances.classAttribute().value(n);
            ++n;
        }
        this.m_classIsNominal = instances.classAttribute().isNominal();
        if (!this.m_classIsNominal) {
            throw new Exception("Class has to be nominal if cost matrix " + "given!");
        }
        this.m_costMatrix = dArray;
        if (this.m_costMatrix.length != this.m_numClasses) {
            throw new Exception("Cost matrix not compatible with data!");
        }
        n = 0;
        while (n < this.m_numClasses) {
            if (this.m_costMatrix[n].length != this.m_numClasses) {
                throw new Exception("Cost matrix not compatible with data!");
            }
            ++n;
        }
        this.m_unclassifiedWithCost = 0.0;
        this.m_withClassWithCost = 0.0;
        this.m_incorrectWithCost = 0.0;
        this.m_correctWithCost = 0.0;
        this.m_classPriors = new double[this.m_numClasses];
        this.m_classPriorsSum = 0.0;
        this.setPriors(instances);
        this.m_sumSqrPredicted = 0.0;
        this.m_sumPredicted = 0.0;
        this.m_sumPriorAbsErr = 0.0;
        this.m_sumKBInfo = 0.0;
        this.m_sumPriorSqrErr = 0.0;
        this.m_sumClassPredicted = 0.0;
        this.m_sumSqrClass = 0.0;
        this.m_sumClass = 0.0;
        this.m_sumSqrErr = 0.0;
        this.m_sumAbsErr = 0.0;
        this.m_sumErr = 0.0;
    }
}

