/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import java.io.Serializable;
import java.util.Enumeration;
import jaws.corePackage.Attribute;
import jaws.corePackage.Copyable;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;

public class Instance
implements Copyable,
Serializable {
    private static final double MISSING_VALUE = Double.NaN;
    private Instances theDataset;
    private double[] theAttValues;
    private double theWeight;

    public Instance(Instance instance) {
        this.theAttValues = instance.theAttValues;
        this.theWeight = instance.theWeight;
        this.theDataset = null;
    }

    public Instance(double d, double[] dArray) {
        this.theAttValues = dArray;
        this.theWeight = d;
        this.theDataset = null;
    }

    public Instance(int n) {
        this.theAttValues = new double[n];
        int n2 = 0;
        while (n2 < this.theAttValues.length) {
            this.theAttValues[n2] = Double.NaN;
            ++n2;
        }
        this.theWeight = 1.0;
        this.theDataset = null;
    }

    public final Attribute attribute(int n) throws Exception {
        if (this.theDataset == null) {
            throw new Exception("Instance doesn't belong to a dataset!");
        }
        return this.theDataset.attribute(n);
    }

    public final Attribute classAttribute() throws Exception {
        if (this.theDataset == null) {
            throw new Exception("Instance doesn't belong to a dataset!");
        }
        return this.theDataset.classAttribute();
    }

    public final int classIndex() throws Exception {
        if (this.theDataset == null) {
            throw new Exception("Instance doesn't belong to a dataset!");
        }
        return this.theDataset.classIndex();
    }

    public final boolean classIsMissing() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public final String classLabel() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        return this.toString(this.classIndex());
    }

    public final double classValue() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public final Object copy() {
        Instance instance = new Instance(this);
        return instance;
    }

    public final Instances dataset() {
        return this.theDataset;
    }

    public final void deleteAttributeAt(int n) throws Exception {
        if (this.theDataset != null) {
            throw new Exception("Instance belongs to a dataset!");
        }
        this.forceDeleteAttributeAt(n);
    }

    public Enumeration enumerateAttributes() {
        return this.theDataset.enumerateAttributes();
    }

    public final boolean equalHeaders(Instance instance) throws Exception {
        if (this.theDataset == null) {
            throw new Exception("Instance doesn't belong to a dataset!");
        }
        return this.theDataset.equalHeaders(instance.theDataset);
    }

    public final void insertAttributeAt(int n) throws Exception {
        if (this.theDataset != null) {
            throw new Exception("Instance belongs to a dataset!");
        }
        this.forceInsertAttributeAt(n);
    }

    public final Instances instances() {
        return this.theDataset;
    }

    public final boolean isMissing(int n) {
        return Double.isNaN(this.theAttValues[n]);
    }

    public final boolean isMissing(Attribute attribute) {
        return this.isMissing(attribute.index());
    }

    public static boolean isMissingValue(double d) {
        return Double.isNaN(d);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public final int numAttributes() {
        return this.theAttValues.length;
    }

    public final int numClasses() throws Exception {
        if (this.theDataset == null) {
            throw new Exception("Instance doesn't belong to a dataset!");
        }
        return this.theDataset.numClasses();
    }

    public final void replaceMissingValues(double[] dArray) throws Exception {
        if (dArray == null || dArray.length != this.theAttValues.length) {
            throw new Exception("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        int n = 0;
        while (n < this.theAttValues.length) {
            if (this.isMissing(n)) {
                this.theAttValues[n] = dArray[n];
            }
            ++n;
        }
    }

    public final void setClassMissing() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        this.freshAttributeVector();
        this.setMissing(this.classIndex());
    }

    public final void setClassValue(double d) throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        this.freshAttributeVector();
        this.theAttValues[this.classIndex()] = d;
    }

    public final void setClassValue(String string) throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        this.setValue(this.classIndex(), string);
    }

    public final void setDataset(Instances instances) {
        this.theDataset = instances;
    }

    public final void setMissing(int n) {
        this.freshAttributeVector();
        this.theAttValues[n] = Double.NaN;
    }

    public final void setMissing(Attribute attribute) {
        this.setMissing(attribute.index());
    }

    public final void setValue(int n, double d) {
        this.freshAttributeVector();
        this.theAttValues[n] = d;
    }

    public final void setValue(int n, String string) throws Exception {
        if (this.theDataset == null) {
            throw new Exception("Instance doesn't belong to a dataset!");
        }
        if (!this.attribute(n).isNominal() && !this.attribute(n).isString()) {
            throw new Exception("Attribute neither nominal nor string!");
        }
        int n2 = this.attribute(n).indexOfValue(string);
        if (n2 == -1) {
            if (this.attribute(n).isNominal()) {
                throw new Exception("Value not defined for given nominal attribute!");
            }
            this.attribute(n).forceAddValue(string);
            n2 = this.attribute(n).indexOfValue(string);
        }
        this.freshAttributeVector();
        this.theAttValues[n] = n2;
    }

    public final void setValue(Attribute attribute, double d) {
        this.setValue(attribute.index(), d);
    }

    public final void setValue(Attribute attribute, String string) throws Exception {
        this.setValue(attribute.index(), string);
    }

    public final void setWeight(double d) {
        this.theWeight = d;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.theAttValues.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.toString(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public final String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isMissing(n)) {
            stringBuffer.append("?");
        } else if (this.theDataset == null) {
            stringBuffer.append(Utils.doubleToString(this.theAttValues[n], 6));
        } else if (this.theDataset.attribute(n).isNominal() || this.theDataset.attribute(n).isString()) {
            stringBuffer.append(this.theDataset.attribute(n).value((int)this.theAttValues[n]));
        } else {
            stringBuffer.append(Utils.doubleToString(this.theAttValues[n], 6));
        }
        return stringBuffer.toString();
    }

    public final String toString(Attribute attribute) {
        return this.toString(attribute.index());
    }

    public final double value(int n) {
        return this.theAttValues[n];
    }

    public final double value(Attribute attribute) {
        return this.theAttValues[attribute.index()];
    }

    public final double weight() {
        return this.theWeight;
    }

    final void forceDeleteAttributeAt(int n) {
        double[] dArray = new double[this.theAttValues.length - 1];
        System.arraycopy(this.theAttValues, 0, dArray, 0, n);
        if (n < this.theAttValues.length - 1) {
            System.arraycopy(this.theAttValues, n + 1, dArray, n, this.theAttValues.length - (n + 1));
        }
        this.theAttValues = dArray;
    }

    final void forceInsertAttributeAt(int n) {
        double[] dArray = new double[this.theAttValues.length + 1];
        System.arraycopy(this.theAttValues, 0, dArray, 0, n);
        dArray[n] = Double.NaN;
        System.arraycopy(this.theAttValues, n, dArray, n + 1, this.theAttValues.length - n);
        this.theAttValues = dArray;
    }

    private void freshAttributeVector() {
        double[] dArray = new double[this.theAttValues.length];
        System.arraycopy(this.theAttValues, 0, dArray, 0, this.theAttValues.length);
        this.theAttValues = dArray;
    }
}

